/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.core.sync.packets;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.helpers.IContainerCraftingPacket;
import appeng.items.storage.ItemViewCell;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import appeng.util.prioitylist.IPartitionList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTermHandler;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.INetworkInfo;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;

public class PacketNEIRecipe
extends WCTPacket {
    private ItemStack[][] recipe;

    public PacketNEIRecipe(ByteBuf stream) throws IOException {
        ByteArrayInputStream bytes = new ByteArrayInputStream(stream.array());
        bytes.skip(stream.readerIndex());
        NBTTagCompound comp = CompressedStreamTools.readCompressed((InputStream)bytes);
        if (comp != null) {
            this.recipe = new ItemStack[9][];
            for (int x = 0; x < this.recipe.length; ++x) {
                NBTTagList list = comp.getTagList("#" + x, 10);
                if (list.tagCount() <= 0) continue;
                this.recipe[x] = new ItemStack[list.tagCount()];
                for (int y = 0; y < list.tagCount(); ++y) {
                    this.recipe[x][y] = ItemStack.loadItemStackFromNBT((NBTTagCompound)list.getCompoundTagAt(y));
                }
            }
        }
    }

    public PacketNEIRecipe(NBTTagCompound recipe) throws IOException {
        ByteBuf data = Unpooled.buffer();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bytes);
        data.writeInt(this.getPacketID());
        CompressedStreamTools.writeCompressed((NBTTagCompound)recipe, (OutputStream)outputStream);
        data.writeBytes(bytes.toByteArray());
        this.configureWrite(data);
    }

    private WirelessTerminalGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        EntityPlayerMP pmp = (EntityPlayerMP)player;
        Container con = pmp.openContainer;
        if (con instanceof IContainerCraftingPacket) {
            IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
            IGridNode node = cct.getNetworkNode();
            if (node == null) {
                WirelessTerminalGuiObject obj = this.getGuiObject(RandomUtils.getWirelessTerm(player.inventory), player, player.worldObj, (int)player.posX, (int)player.posY, (int)player.posZ);
                node = obj.getActionableNode(true);
            }
            if (node != null) {
                IGrid grid = node.getGrid();
                if (grid == null) {
                    return;
                }
                IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
                IEnergyGrid energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class);
                ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
                IInventory craftMatrix = cct.getInventoryByName("crafting");
                IInventory playerInventory = cct.getInventoryByName("container.inventory");
                Actionable realForFake = Actionable.MODULATE;
                if (inv != null && this.recipe != null && security != null) {
                    ItemStack is;
                    InventoryCrafting testInv = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
                    for (int x = 0; x < 9; ++x) {
                        if (this.recipe[x] == null || this.recipe[x].length <= 0) continue;
                        testInv.setInventorySlotContents(x, this.recipe[x][0]);
                    }
                    IRecipe r = Platform.findMatchingRecipe((InventoryCrafting)testInv, (World)pmp.worldObj);
                    if (r != null && security.hasPermission(player, SecurityPermissions.EXTRACT) && (is = r.getCraftingResult(testInv)) != null) {
                        IMEMonitor storage = inv.getItemInventory();
                        IItemList all = storage.getStorageList();
                        ItemStack[] nullStack = new ItemStack[]{};
                        IPartitionList filter = ItemViewCell.createFilter((ItemStack[])nullStack);
                        for (int x = 0; x < craftMatrix.getSizeInventory(); ++x) {
                            ItemStack patternItem = testInv.getStackInSlot(x);
                            ItemStack currentItem = craftMatrix.getStackInSlot(x);
                            if (currentItem != null) {
                                AEItemStack in;
                                testInv.setInventorySlotContents(x, currentItem);
                                ItemStack newItemStack = r.matches(testInv, pmp.worldObj) ? r.getCraftingResult(testInv) : null;
                                testInv.setInventorySlotContents(x, patternItem);
                                if (!(newItemStack != null && Platform.isSameItemPrecise((ItemStack)newItemStack, (ItemStack)is) || (in = AEItemStack.create((ItemStack)currentItem)) == null)) {
                                    IAEItemStack out = (IAEItemStack)Platform.poweredInsert((IEnergySource)energy, (IMEInventory)storage, (IAEStack)in, (BaseActionSource)cct.getActionSource());
                                    if (out != null) {
                                        craftMatrix.setInventorySlotContents(x, out.getItemStack());
                                    } else {
                                        craftMatrix.setInventorySlotContents(x, null);
                                    }
                                    currentItem = craftMatrix.getStackInSlot(x);
                                }
                            }
                            if (patternItem == null || currentItem != null) continue;
                            ItemStack whichItem = Platform.extractItemsByRecipe((IEnergySource)energy, (BaseActionSource)cct.getActionSource(), (IMEMonitor)storage, (World)player.worldObj, (IRecipe)r, (ItemStack)is, (InventoryCrafting)testInv, (ItemStack)patternItem, (int)x, (IItemList)all, (Actionable)realForFake, (IPartitionList)filter);
                            if (whichItem == null) {
                                for (int y = 0; y < this.recipe[x].length; ++y) {
                                    AEItemStack request = AEItemStack.create((ItemStack)this.recipe[x][y]);
                                    if (request == null || filter != null && !filter.isListed((IAEStack)request)) continue;
                                    request.setStackSize(1L);
                                    IAEItemStack out = (IAEItemStack)Platform.poweredExtraction((IEnergySource)energy, (IMEInventory)storage, (IAEStack)request, (BaseActionSource)cct.getActionSource());
                                    if (out == null) continue;
                                    whichItem = out.getItemStack();
                                    break;
                                }
                            }
                            if (whichItem == null && playerInventory != null) {
                                whichItem = this.extractItemFromPlayerInventory(player, realForFake, patternItem);
                            }
                            craftMatrix.setInventorySlotContents(x, whichItem);
                        }
                        con.onCraftMatrixChanged(craftMatrix);
                    }
                }
            }
        }
    }

    private ItemStack extractItemFromPlayerInventory(EntityPlayer player, Actionable mode, ItemStack patternItem) {
        boolean checkFuzzy;
        InventoryAdaptor ia = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
        AEItemStack request = AEItemStack.create((ItemStack)patternItem);
        boolean bl = checkFuzzy = request.isOre() || patternItem.getItemDamage() == Short.MAX_VALUE || patternItem.hasTagCompound() || patternItem.isItemStackDamageable();
        if (!checkFuzzy) {
            return ia.removeItems(1, patternItem, null);
        }
        return ia.removeSimilarItems(1, patternItem, FuzzyMode.IGNORE_ALL, null);
    }
}

