/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.core.sync.packets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.common.container.WCTBaseContainer;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.INetworkInfo;

public class PacketSwapSlots
extends WCTPacket {
    private final int slotA;
    private final int slotB;

    public PacketSwapSlots(ByteBuf stream) {
        this.slotA = stream.readInt();
        this.slotB = stream.readInt();
    }

    public PacketSwapSlots(int slotA, int slotB) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.slotA = slotA;
        data.writeInt(this.slotA);
        this.slotB = slotB;
        data.writeInt(this.slotB);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        if (player != null) {
            if (player.openContainer instanceof ContainerWirelessCraftingTerminal) {
                ((ContainerWirelessCraftingTerminal)player.openContainer).swapSlotContents(this.slotA, this.slotB);
            }
            if (player.openContainer instanceof WCTBaseContainer) {
                ((WCTBaseContainer)player.openContainer).swapSlotContents(this.slotA, this.slotB);
            }
        }
    }
}

