/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.items;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.Platform;
import com.google.common.base.Splitter;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTermHandler;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTPlayerSource;
import net.p455w0rd.wirelesscraftingterminal.common.WCTGuiHandler;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketMagnetFilter;
import net.p455w0rd.wirelesscraftingterminal.handlers.KeybindHandler;
import net.p455w0rd.wirelesscraftingterminal.handlers.LocaleHandler;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;
import net.p455w0rd.wirelesscraftingterminal.items.ItemInfinityBooster;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;

public class ItemMagnet
extends Item {
    private int distanceFromPlayer;
    private WirelessTerminalGuiObject obj;
    private IPortableCell civ;
    private IEnergySource powerSrc;
    private IMEMonitor<IAEItemStack> monitor;
    private IMEInventoryHandler<IAEItemStack> cellInv;
    private BaseActionSource mySrc;
    private ItemStack thisItemStack;
    private int pickupTimer = 0;

    public ItemMagnet() {
        this.setMaxStackSize(1);
        this.distanceFromPlayer = 16;
        this.canRepair = false;
        this.setMaxDamage(0);
        this.setTextureName("ae2wct:magnetCard");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack item) {
        return this.isActivated(item);
    }

    public void setItemStack(ItemStack is) {
        this.thisItemStack = is;
    }

    public boolean isDamageable() {
        return false;
    }

    public ItemStack getItemStack() {
        if (this.thisItemStack != null && this.thisItemStack.getItem() instanceof ItemMagnet) {
            return this.thisItemStack;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack is, EntityPlayer player, List list, boolean par4) {
        list.add(this.color("aqua") + "==============================");
        String shift = LocaleHandler.PressShift.getLocal().replace("Shift", this.color("yellow") + this.color("bold") + this.color("italics") + "Shift" + this.color("gray"));
        if (ItemMagnet.isShiftKeyDown()) {
            String info = LocaleHandler.MagnetDesc.getLocal();
            for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)info, (int)37, (String)"\n", (boolean)false))) {
                list.add(line.trim());
            }
            list.add("");
            list.add(this.color("italics") + "" + LocaleHandler.MagnetDesc2.getLocal());
            if (this.isActivated(this.getItemStack())) {
                String boundKey2;
                String boundKey = Keyboard.getKeyName((int)KeybindHandler.openMagnetFilter.getKeyCode());
                if (!boundKey.equals("NONE")) {
                    list.add(this.color("italics") + LocaleHandler.OrPress.getLocal() + " " + this.color("yellow") + this.color("bold") + "[" + boundKey + "]");
                }
                if (!(boundKey2 = Keyboard.getKeyName((int)KeybindHandler.changeMagnetMode.getKeyCode())).equals("NONE")) {
                    list.add(this.color("italics") + LocaleHandler.Press.getLocal() + " " + this.color("yellow") + this.color("bold") + "[" + boundKey2 + "] " + this.color("gray") + this.color("italics") + LocaleHandler.ToSwitchMode.getLocal());
                }
            }
            list.add("");
            list.add(LocaleHandler.Status.getLocal() + ": " + (this.isActivated(is) ? this.color("green") + LocaleHandler.Active.getLocal() : this.color("red") + LocaleHandler.Inactive.getLocal()));
            if (is.getItemDamage() == 1) {
                list.add(this.color("white") + "  " + LocaleHandler.MagnetActiveDesc1.getLocal());
            } else if (is.getItemDamage() == 2) {
                list.add(this.color("white") + "  " + LocaleHandler.MagnetActiveDesc2.getLocal());
            }
            String white = LocaleHandler.Whitelisting.getLocal();
            String black = LocaleHandler.Blacklisting.getLocal();
            list.add(LocaleHandler.FilterMode.getLocal() + ": " + this.color("white") + (this.getMode(is) ? white : black));
            String not = LocaleHandler.Not.getLocal();
            String ignoring = LocaleHandler.Ignoring.getLocal();
            String nbtData = LocaleHandler.NBTData.getLocal();
            String metaData = LocaleHandler.MetaData.getLocal();
            String usingOreDict = LocaleHandler.Using.getLocal() + " " + LocaleHandler.OreDict.getLocal();
            list.add((!this.doesMagnetUseOreDict() ? " " + not : this.color("green")) + " " + usingOreDict);
            list.add((!this.doesMagnetIgnoreNBT() ? " " + not : this.color("green")) + " " + ignoring + " " + nbtData);
            list.add((!this.doesMagnetIgnoreMeta() ? " " + not : this.color("green")) + " " + ignoring + " " + metaData);
            List<ItemStack> filteredItems = this.getFilteredItems(this.getItemStack());
            if (filteredItems != null) {
                list.add("");
                list.add(this.color("gray") + LocaleHandler.FilteredItems.getLocal() + ":");
                for (int i = 0; i < filteredItems.size(); ++i) {
                    list.add("  " + filteredItems.get(i).getDisplayName());
                }
            }
            list.add("");
            String onlyWorks = LocaleHandler.OnlyWorks.getLocal();
            for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)onlyWorks, (int)27, (String)"\n", (boolean)false))) {
                list.add(this.color("white") + this.color("bold") + this.color("italics") + line.trim());
            }
        } else {
            list.add(shift);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String color(String color) {
        return RandomUtils.color(color);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public ItemStack onItemRightClick(ItemStack item, World world, EntityPlayer player) {
        if (!world.isRemote) {
            if (player.isSneaking()) {
                this.switchMagnetMode(item, player);
            } else {
                if (!RandomUtils.isMagnetInitialized(item)) {
                    NetworkHandler.instance.sendToServer(new PacketMagnetFilter(0, true));
                }
                int x = (int)player.posX;
                int y = (int)player.posY;
                int z = (int)player.posZ;
                WCTGuiHandler.launchGui(Reference.GUI_MAGNET, player, world, x, y, z);
            }
        }
        return item;
    }

    public void switchMagnetMode(ItemStack item, EntityPlayer player) {
        if (item.getItemDamage() == 0) {
            item.setItemDamage(1);
            player.addChatMessage((IChatComponent)new ChatComponentText(LocaleHandler.MagnetMode2.getLocal()));
        } else if (item.getItemDamage() == 1) {
            item.setItemDamage(2);
            player.addChatMessage((IChatComponent)new ChatComponentText(LocaleHandler.MagnetMode3.getLocal()));
        } else {
            item.setItemDamage(0);
            player.addChatMessage((IChatComponent)new ChatComponentText(LocaleHandler.MagnetMode1.getLocal()));
        }
    }

    public void doMagnet(ItemStack item, World world, EntityPlayer player, ItemStack wirelessTerm) {
        if (world.isRemote) {
            return;
        }
        if (this.getItemStack() == null) {
            return;
        }
        if (!this.isActivated(item)) {
            return;
        }
        if (player == null) {
            return;
        }
        List<ItemStack> filteredList = this.getFilteredItems(this.getItemStack());
        for (EntityItem itemToGet : ItemMagnet.getEntitiesInRange(EntityItem.class, world, (int)player.posX, (int)player.posY, (int)player.posZ, this.distanceFromPlayer)) {
            if (itemToGet == null) {
                return;
            }
            itemToGet.delayBeforeCanPickup = 75;
            EntityItemPickupEvent pickupEvent = new EntityItemPickupEvent(player, itemToGet);
            PlayerEvent.ItemPickupEvent itemPickupEvent = new PlayerEvent.ItemPickupEvent(player, itemToGet);
            ItemStack itemStackToGet = itemToGet.getEntityItem();
            if (itemStackToGet == null) {
                return;
            }
            int stackSize = itemStackToGet.stackSize;
            MinecraftForge.EVENT_BUS.post((Event)pickupEvent);
            FMLCommonHandler.instance().bus().post((Event)itemPickupEvent);
            if (this.obj == null) {
                this.obj = this.getGuiObject(wirelessTerm, player, world, (int)player.posX, (int)player.posY, (int)player.posZ);
                this.civ = this.obj;
                this.powerSrc = this.civ;
                this.monitor = this.civ.getItemInventory();
                this.cellInv = this.monitor;
                this.mySrc = new WCTPlayerSource(player, this.obj);
            }
            boolean ignoreRange = this.isBoosterInstalled(wirelessTerm) && Reference.WCT_BOOSTER_ENABLED;
            boolean hasAxxess = this.hasNetworkAccess(SecurityPermissions.INJECT, true, player, wirelessTerm);
            if (ignoreRange && hasAxxess || this.obj.rangeCheck(false) && hasAxxess) {
                IAEItemStack ais = AEApi.instance().storage().createItemStack(itemStackToGet);
                ais.setStackSize((long)stackSize);
                if (itemToGet.isDead) continue;
                if (this.getMode(this.getItemStack())) {
                    if (this.isItemFiltered(itemStackToGet, filteredList) && filteredList != null && filteredList.size() > 0) {
                        itemToGet.setDead();
                        this.doInject(ais, stackSize, player, itemToGet, itemStackToGet, world);
                        continue;
                    }
                    if (item.getItemDamage() == 1) {
                        if (pickupEvent.getResult() != Event.Result.ALLOW && itemPickupEvent.getResult() != Event.Result.ALLOW && stackSize > 0 && !player.inventory.addItemStackToInventory(itemStackToGet)) continue;
                        player.onItemPickup((Entity)itemToGet, stackSize);
                        world.playSoundAtEntity((Entity)player, "random.pop", 0.15f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        continue;
                    }
                    this.doVanillaPickup(itemToGet, player, itemStackToGet, world, stackSize);
                    continue;
                }
                if (!this.isItemFiltered(itemStackToGet, filteredList) || filteredList == null || filteredList.size() <= 0) {
                    itemToGet.setDead();
                    this.doInject(ais, stackSize, player, itemToGet, itemStackToGet, world);
                    continue;
                }
                if (item.getItemDamage() == 1) {
                    if (pickupEvent.getResult() != Event.Result.ALLOW && itemPickupEvent.getResult() != Event.Result.ALLOW && stackSize > 0 && !player.inventory.addItemStackToInventory(itemStackToGet)) continue;
                    player.onItemPickup((Entity)itemToGet, stackSize);
                    world.playSoundAtEntity((Entity)player, "random.pop", 0.15f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    continue;
                }
                this.doVanillaPickup(itemToGet, player, itemStackToGet, world, stackSize);
                continue;
            }
            this.doVanillaPickup(itemToGet, player, itemStackToGet, world, stackSize);
        }
        for (EntityXPOrb xpToGet : ItemMagnet.getEntitiesInRange(EntityXPOrb.class, world, (int)player.posX, (int)player.posY, (int)player.posZ, this.distanceFromPlayer)) {
            if (xpToGet.isDead || xpToGet.isInvisible()) continue;
            int xpAmount = xpToGet.xpValue;
            xpToGet.xpValue = 0;
            player.xpCooldown = 0;
            player.addExperience(xpAmount);
            xpToGet.setDead();
            xpToGet.setInvisible(true);
            world.playSoundAtEntity((Entity)player, "random.orb", 0.08f, 0.5f * ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.8f));
        }
    }

    private void doVanillaPickup(EntityItem itemToGet, EntityPlayer player, ItemStack itemStackToGet, World world, int stackSize) {
        if (this.pickupTimer < 100) {
            ++this.pickupTimer;
            return;
        }
        this.pickupTimer = 0;
        if (itemToGet.getDistanceToEntity((Entity)player) <= 2.0f && player.inventory.addItemStackToInventory(itemStackToGet)) {
            player.onItemPickup((Entity)itemToGet, stackSize);
            world.playSoundAtEntity((Entity)player, "random.pop", 0.15f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    private boolean doesMagnetIgnoreNBT() {
        return RandomUtils.readBoolean(this.getItemStack(), "IgnoreNBT");
    }

    private boolean doesMagnetIgnoreMeta() {
        return RandomUtils.readBoolean(this.getItemStack(), "IgnoreMeta");
    }

    private boolean doesMagnetUseOreDict() {
        return RandomUtils.readBoolean(this.getItemStack(), "UseOreDict");
    }

    private boolean areOresEqual(ItemStack is1, ItemStack is2) {
        int[] list1 = OreDictionary.getOreIDs((ItemStack)is1);
        int[] list2 = OreDictionary.getOreIDs((ItemStack)is2);
        for (int i = 0; i < list1.length; ++i) {
            for (int j = 0; j < list2.length; ++j) {
                if (list1[i] != list2[j]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isItemFiltered(ItemStack is, List<ItemStack> itemList) {
        if (is != null && itemList != null) {
            for (int i = 0; i < itemList.size(); ++i) {
                ItemStack thisStack = itemList.get(i);
                if (this.doesMagnetUseOreDict() && this.areOresEqual(is, thisStack)) {
                    return true;
                }
                if (!(this.doesMagnetIgnoreMeta() && this.doesMagnetIgnoreNBT() ? is.getItem().equals(thisStack.getItem()) : (this.doesMagnetIgnoreMeta() && !this.doesMagnetIgnoreNBT() ? ItemStack.areItemStackTagsEqual((ItemStack)is, (ItemStack)thisStack) && is.getItem() == thisStack.getItem() : (!this.doesMagnetIgnoreMeta() && this.doesMagnetIgnoreNBT() && is.getItem() == thisStack.getItem() ? this.isMetaEqual(is, thisStack) : this.isMetaEqual(is, thisStack) && ItemStack.areItemStackTagsEqual((ItemStack)is, (ItemStack)thisStack) && is.getItem() == thisStack.getItem())))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMetaEqual(ItemStack is1, ItemStack is2) {
        return is1.getItemDamage() == is2.getItemDamage();
    }

    private boolean hasNetworkAccess(SecurityPermissions perm, boolean requirePower, EntityPlayer player, ItemStack wirelessTerm) {
        if (player.capabilities.isCreativeMode) {
            return true;
        }
        IGrid g = this.obj.getTargetGrid();
        if (g != null) {
            IEnergyGrid eg;
            if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                return false;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (sg.hasPermission(player, perm)) {
                return true;
            }
        }
        return false;
    }

    private List<ItemStack> getFilteredItems(ItemStack magnetItem) {
        if (magnetItem == null) {
            return null;
        }
        if (magnetItem.getItem() instanceof ItemMagnet && magnetItem.hasTagCompound()) {
            NBTTagCompound nbtTC = magnetItem.getTagCompound();
            if (!nbtTC.hasKey("MagnetFilter")) {
                return null;
            }
            NBTTagList tagList = nbtTC.getTagList("MagnetFilter", 10);
            if (tagList.tagCount() > 0 && tagList != null) {
                ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
                for (int i = 0; i < tagList.tagCount(); ++i) {
                    itemList.add(ItemStack.loadItemStackFromNBT((NBTTagCompound)tagList.getCompoundTagAt(i)));
                }
                return itemList;
            }
        }
        return null;
    }

    private void doInject(IAEItemStack ais, int stackSize, EntityPlayer player, EntityItem itemToGet, ItemStack itemStackToGet, World world) {
        if ((ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.powerSrc, this.cellInv, (IAEStack)ais, (BaseActionSource)this.mySrc)) != null) {
            player.onItemPickup((Entity)itemToGet, stackSize);
            player.inventory.addItemStackToInventory(itemStackToGet);
            world.playSoundAtEntity((Entity)player, "random.pop", 0.15f, ((world.rand.nextFloat() - world.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    private boolean isBoosterInstalled(ItemStack wirelessTerm) {
        ItemStack boosterCard;
        NBTTagCompound boosterTagCompound;
        NBTTagList boosterNBTList;
        if (wirelessTerm.getItem() instanceof IWirelessCraftingTerminalItem && wirelessTerm.hasTagCompound() && (boosterNBTList = wirelessTerm.getTagCompound().getTagList("BoosterSlot", 10)) != null && (boosterTagCompound = boosterNBTList.getCompoundTagAt(0)) != null && (boosterCard = ItemStack.loadItemStackFromNBT((NBTTagCompound)boosterTagCompound)) != null) {
            return boosterCard.getItem() instanceof ItemInfinityBooster;
        }
        return false;
    }

    private boolean getMode(ItemStack magnetItem) {
        NBTTagCompound nbtTC;
        if (magnetItem.getItem() instanceof ItemMagnet && magnetItem.hasTagCompound() && (nbtTC = magnetItem.getTagCompound()).hasKey("Whitelisting")) {
            return nbtTC.getBoolean("Whitelisting");
        }
        return true;
    }

    private WirelessTerminalGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    public static List getEntitiesInRange(Class entityType, World world, int x, int y, int z, int distance) {
        return world.getEntitiesWithinAABB(entityType, AxisAlignedBB.getBoundingBox((double)(x - distance), (double)(y - distance), (double)(z - distance), (double)(x + distance), (double)(y + distance), (double)(z + distance)));
    }

    public ItemStack getStack() {
        return this.getStack(1);
    }

    public ItemStack getStack(int size) {
        return new ItemStack((Item)this, size);
    }

    protected boolean isActivated(ItemStack item) {
        return item.getItemDamage() != 0;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 1;
    }
}

