/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.proxy;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.Random;
import logisticspipes.blocks.crafting.FakePlayer;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.Achievement;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketConfigSync;
import net.p455w0rd.wirelesscraftingterminal.handlers.AchievementHandler;
import net.p455w0rd.wirelesscraftingterminal.handlers.ConfigHandler;
import net.p455w0rd.wirelesscraftingterminal.handlers.VersionCheckHandler;
import net.p455w0rd.wirelesscraftingterminal.items.ItemEnum;
import net.p455w0rd.wirelesscraftingterminal.items.ItemMagnet;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;

public class CommonProxy {
    Achievement wctAch = AchievementHandler.wctAch;
    Achievement boosterAch = AchievementHandler.boosterAch;
    Achievement magnetAch = AchievementHandler.magnetAch;

    public CommonProxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
    }

    public void registerItems() {
        for (ItemEnum item : ItemEnum.VALUES) {
            GameRegistry.registerItem((Item)item.getItem(), (String)item.getInternalName());
        }
    }

    public void removeItemsFromNEI() {
    }

    public void registerRenderers() {
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.PlayerTickEvent e) {
        ItemStack wirelessTerm = null;
        EntityPlayer player = e.player;
        InventoryPlayer playerInv = player instanceof EntityPlayerMP ? player.inventory.player.inventory : player.inventory;
        int invSize = playerInv.getSizeInventory();
        if (invSize <= 0) {
            return;
        }
        for (int i = 0; i < invSize; ++i) {
            ItemStack magnetItem;
            NBTTagCompound magCompound;
            NBTTagCompound nbtTC;
            NBTTagList tagList;
            ItemStack item = playerInv.getStackInSlot(i);
            if (item == null) continue;
            if (item.getItem() instanceof IWirelessCraftingTerminalItem) {
                wirelessTerm = item;
            }
            if (wirelessTerm == null || !wirelessTerm.hasTagCompound() || (tagList = (nbtTC = wirelessTerm.getTagCompound()).getTagList("MagnetSlot", 10)) == null || (magCompound = tagList.getCompoundTagAt(0)) == null || (magnetItem = ItemStack.loadItemStackFromNBT((NBTTagCompound)magCompound)) == null) continue;
            ((ItemMagnet)magnetItem.getItem()).setItemStack(magnetItem);
            if (!(magnetItem.getItem() instanceof ItemMagnet)) continue;
            ((ItemMagnet)magnetItem.getItem()).doMagnet(magnetItem, e.player.worldObj, e.player, wirelessTerm);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ConfigHandler.removeBooster();
            ConfigHandler.removeBoosterIcon();
            if (ConfigHandler.firstLoad) {
                ConfigHandler.firstLoad = false;
            } else {
                ConfigHandler.reloadRecipes();
            }
            if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                WCTLog.info("Dev environment detected, skipping version check", new Object[0]);
            } else {
                new VersionCheckHandler();
            }
        } else {
            PacketConfigSync p = new PacketConfigSync(Reference.WCT_MAX_POWER, Reference.WCT_EASYMODE_ENABLED, Reference.WCT_BOOSTER_ENABLED, Reference.WCT_BOOSTER_DROPCHANCE, Reference.WCT_MINETWEAKER_OVERRIDE);
            NetworkHandler.instance.sendTo(p, (EntityPlayerMP)e.player);
        }
    }

    @SubscribeEvent
    public void onMobDrop(LivingDropsEvent event) {
        if (!Reference.WCT_EASYMODE_ENABLED && Reference.WCT_BOOSTER_ENABLED && Reference.WCT_BOOSTERDROP_ENABLED) {
            Random rand;
            int n;
            ItemStack stack = new ItemStack(ItemEnum.BOOSTER_CARD.getItem());
            EntityItem drop = new EntityItem(event.entity.worldObj, event.entity.posX, event.entity.posY, event.entity.posZ, stack);
            if (event.entity instanceof EntityDragon) {
                event.drops.add(drop);
            }
            if (event.entity instanceof EntityWither && (n = (rand = new Random()).nextInt()) <= Reference.WCT_BOOSTER_DROPCHANCE) {
                event.drops.add(drop);
            }
        }
    }

    @SubscribeEvent
    public void pickupEvent(PlayerEvent.ItemPickupEvent e) {
        if (Reference.WCT_BOOSTER_ENABLED && !Reference.WCT_EASYMODE_ENABLED && e.pickedUp.getEntityItem().getItem() == ItemEnum.BOOSTER_CARD.getItem()) {
            AchievementHandler.triggerAch(this.boosterAch, e.player);
        }
    }

    @SubscribeEvent
    public void onPlayerCraftingEvent(PlayerEvent.ItemCraftedEvent event) {
        if (event.player == null || event.player.isDead || event.player instanceof net.minecraftforge.common.util.FakePlayer || event.crafting == null) {
            return;
        }
        if (Loader.isModLoaded((String)"LogisticsPipes") && event.player instanceof FakePlayer) {
            return;
        }
        if (event.crafting.getItem() == ItemEnum.WIRELESS_CRAFTING_TERMINAL.getItem()) {
            AchievementHandler.triggerAch(this.wctAch, event.player);
        }
        if (event.crafting.getItem() == ItemEnum.MAGNET_CARD.getItem()) {
            AchievementHandler.triggerAch(this.magnetAch, event.player);
        }
        if (Reference.WCT_BOOSTER_ENABLED && Reference.WCT_EASYMODE_ENABLED && event.crafting.getItem() == ItemEnum.BOOSTER_CARD.getItem()) {
            AchievementHandler.triggerAch(this.boosterAch, event.player);
        }
    }
}

