/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import alkalus.main.core.WitcheryExtras;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class NBTUtils {
    public static NBTTagCompound getNBT(ItemStack aStack) {
        NBTTagCompound rNBT = aStack.getTagCompound();
        return rNBT == null ? new NBTTagCompound() : rNBT;
    }

    public static void setBookTitle(ItemStack aStack, String aTitle) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setString("title", aTitle);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static String getBookTitle(ItemStack aStack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getString("title");
    }

    public static ItemStack[] readItemsFromNBT(ItemStack itemstack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = tNBT.getTagList("Items", 10);
        ItemStack[] inventory = new ItemStack[list.tagCount()];
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound data = list.getCompoundTagAt(i);
            int slot = data.getInteger("Slot");
            if (slot < 0 || slot >= list.tagCount()) continue;
            inventory[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)data) == null ? null : ItemStack.loadItemStackFromNBT((NBTTagCompound)data);
        }
        return inventory;
    }

    public static ItemStack[] readItemsFromNBT(ItemStack itemstack, String customkey) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = tNBT.getTagList(customkey, 10);
        ItemStack[] inventory = new ItemStack[list.tagCount()];
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound data = list.getCompoundTagAt(i);
            int slot = data.getInteger("Slot");
            if (slot < 0 || slot >= list.tagCount()) continue;
            inventory[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)data) == null ? null : ItemStack.loadItemStackFromNBT((NBTTagCompound)data);
        }
        return inventory;
    }

    public static ItemStack writeItemsToNBT(ItemStack itemstack, ItemStack[] stored) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stored.length; ++i) {
            ItemStack stack = stored[i];
            if (stack == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            stack.writeToNBT(data);
            data.setInteger("Slot", i);
            list.appendTag((NBTBase)data);
        }
        tNBT.setTag("Items", (NBTBase)list);
        itemstack.setTagCompound(tNBT);
        return itemstack;
    }

    public static ItemStack writeItemsToNBT(ItemStack itemstack, ItemStack[] stored, String customkey) {
        NBTTagCompound tNBT = NBTUtils.getNBT(itemstack);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stored.length; ++i) {
            ItemStack stack = stored[i];
            if (stack == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            stack.writeToNBT(data);
            data.setInteger("Slot", i);
            list.appendTag((NBTBase)data);
        }
        tNBT.setTag(customkey, (NBTBase)list);
        itemstack.setTagCompound(tNBT);
        return itemstack;
    }

    public static void setBoolean(ItemStack aStack, String aTag, boolean aBoolean) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setBoolean(aTag, aBoolean);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static boolean getBoolean(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getBoolean(aTag);
    }

    public static void setInteger(ItemStack aStack, String aTag, int aInt) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setInteger(aTag, aInt);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static int getInteger(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getInteger(aTag);
    }

    public static void setLong(ItemStack aStack, String aTag, long aInt) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setLong(aTag, aInt);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static long getLong(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getLong(aTag);
    }

    public static void setFloat(ItemStack aStack, String aTag, float aInt) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setFloat(aTag, aInt);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static float getFloat(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getFloat(aTag);
    }

    public static void setString(ItemStack aStack, String aTag, String aString) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setString(aTag, aString);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static String getString(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getString(aTag);
    }

    public static boolean doesStringExist(ItemStack aStack, String aTag) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.hasKey(aTag);
    }

    public static boolean tryIterateNBTData(ItemStack aStack) {
        try {
            NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
            if (aNBT != null && !aNBT.hasNoTags()) {
                Map mInternalMap = (Map)NBTUtils.getField(aNBT, "tagMap");
                if (mInternalMap != null) {
                    for (Map.Entry e : mInternalMap.entrySet()) {
                        WitcheryExtras.log(0, "Key: " + e.getKey().toString() + " | Value: " + e.getValue() + " | Type: " + e.getValue().getClass().getName());
                    }
                    return true;
                }
                WitcheryExtras.log(0, "Data map reflected from NBTTagCompound was not valid.");
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean setBotanicaSoulboundOwner(ItemStack aStack, String aName) {
        String TAG_SOULBIND = "soulbind";
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setString("soulbind", aName);
        NBTUtils.setNBT(aStack, tNBT);
        return NBTUtils.doesStringExist(aStack, "soulbind");
    }

    public static String getBotanicaSoulboundOwner(ItemStack aStack) {
        String TAG_SOULBIND = "soulbind";
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getString("soulbind");
    }

    public static boolean hasKey(ItemStack stack, String key) {
        NBTTagCompound itemData = NBTUtils.getNBT(stack);
        return itemData.hasKey(key);
    }

    public static boolean createIntegerTagCompound(ItemStack rStack, String tagName, String keyName, int keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.setInteger(keyName, keyValue);
        tagMain.setTag(tagName, (NBTBase)tagNBT);
        rStack.setTagCompound(tagMain);
        return true;
    }

    public static boolean createLongTagCompound(ItemStack rStack, String tagName, String keyName, long keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.setLong(keyName, keyValue);
        tagMain.setTag(tagName, (NBTBase)tagNBT);
        rStack.setTagCompound(tagMain);
        return true;
    }

    public static boolean createStringTagCompound(ItemStack rStack, String tagName, String keyName, String keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.setString(keyName, keyValue);
        tagMain.setTag(tagName, (NBTBase)tagNBT);
        rStack.setTagCompound(tagMain);
        return true;
    }

    public static boolean createFloatTagCompound(ItemStack rStack, String tagName, String keyName, float keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.setFloat(keyName, keyValue);
        tagMain.setTag(tagName, (NBTBase)tagNBT);
        rStack.setTagCompound(tagMain);
        return true;
    }

    public static boolean createByteTagCompound(ItemStack rStack, String tagName, String keyName, byte keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.setByte(keyName, keyValue);
        tagMain.setTag(tagName, (NBTBase)tagNBT);
        rStack.setTagCompound(tagMain);
        return true;
    }

    public static boolean createBooleanTagCompound(ItemStack rStack, String tagName, String keyName, boolean keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = new NBTTagCompound();
        tagNBT.setBoolean(keyName, keyValue);
        tagMain.setTag(tagName, (NBTBase)tagNBT);
        rStack.setTagCompound(tagMain);
        return true;
    }

    public static boolean createTagCompound(ItemStack rStack, String tagName, NBTTagCompound keyValue) {
        NBTTagCompound tagMain = NBTUtils.getNBT(rStack);
        NBTTagCompound tagNBT = keyValue;
        tagMain.setTag(tagName, (NBTBase)tagNBT);
        rStack.setTagCompound(tagMain);
        return true;
    }

    public static int getIntegerTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.getCompoundTag(tagName)) != null) {
            return aNBT.getInteger(keyName);
        }
        return 0;
    }

    public static long getLongTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.getCompoundTag(tagName)) != null) {
            return aNBT.getLong(keyName);
        }
        return 0L;
    }

    public static String getStringTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.getCompoundTag(tagName)) != null) {
            return aNBT.getString(keyName);
        }
        return null;
    }

    public static float getFloatTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.getCompoundTag(tagName)) != null) {
            return aNBT.getFloat(keyName);
        }
        return 0.0f;
    }

    public static double getByteTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.getCompoundTag(tagName)) != null) {
            return aNBT.getByte(keyName);
        }
        return 0.0;
    }

    public static boolean getBooleanTagCompound(ItemStack aStack, String tagName, String keyName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && (aNBT = aNBT.getCompoundTag(tagName)) != null) {
            return aNBT.getBoolean(keyName);
        }
        return false;
    }

    public static NBTTagCompound getTagCompound(ItemStack aStack, String tagName) {
        NBTTagCompound aNBT = NBTUtils.getNBT(aStack);
        if (aNBT != null && NBTUtils.hasKey(aStack, tagName) && (aNBT = aNBT.getCompoundTag(tagName)) != null) {
            return aNBT;
        }
        return null;
    }

    public static boolean hasKeyInTagCompound(ItemStack stack, String tag, String key) {
        NBTTagCompound aNBT = stack.getTagCompound();
        return aNBT != null && (aNBT = aNBT.getCompoundTag(tag)).hasKey(key);
    }

    public static void setNBT(ItemStack aStack, NBTTagCompound aNBT) {
        if (aNBT == null) {
            aStack.setTagCompound((NBTTagCompound)null);
            return;
        }
        ArrayList<String> tTagsToRemove = new ArrayList<String>();
        for (Object e : aNBT.func_150296_c()) {
            NBTBase tValue = aNBT.getTag((String)e);
            if (tValue != null && (!(tValue instanceof NBTBase.NBTPrimitive) || ((NBTBase.NBTPrimitive)tValue).func_150291_c() != 0L) && (!(tValue instanceof NBTTagString) || !NBTUtils.isStringInvalid(((NBTTagString)tValue).func_150285_a_()))) continue;
            tTagsToRemove.add((String)e);
        }
        for (Object e : tTagsToRemove) {
            aNBT.removeTag((String)e);
        }
        aStack.setTagCompound(aNBT.hasNoTags() ? null : aNBT);
    }

    public static boolean isStringInvalid(Object aString) {
        return aString == null || aString.toString().isEmpty();
    }

    public static void setPunchCardData(ItemStack aStack, String aPunchCardData) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setString("GT.PunchCardData", aPunchCardData);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static String getPunchCardData(ItemStack aStack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getString("GT.PunchCardData");
    }

    public static void setLighterFuel(ItemStack aStack, long aFuel) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setLong("GT.LighterFuel", aFuel);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static long getLighterFuel(ItemStack aStack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getLong("GT.LighterFuel");
    }

    public static void setMapID(ItemStack aStack, short aMapID) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setShort("map_id", aMapID);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static short getMapID(ItemStack aStack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        if (!tNBT.hasKey("map_id")) {
            return -1;
        }
        return tNBT.getShort("map_id");
    }

    public static void setBookAuthor(ItemStack aStack, String aAuthor) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        tNBT.setString("author", aAuthor);
        NBTUtils.setNBT(aStack, tNBT);
    }

    public static String getBookAuthor(ItemStack aStack) {
        NBTTagCompound tNBT = NBTUtils.getNBT(aStack);
        return tNBT.getString("author");
    }

    public static <V> V getField(Object object, String fieldName) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return (V)field.get(object);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }
}

