/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import alkalus.main.asm.AsmConfig;
import alkalus.main.core.util.ReflectionUtils;
import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockPoppetShelf;
import com.emoniph.witchery.util.Log;
import java.lang.reflect.Field;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class PoppetShelfUtils {
    private static ForgeChunkManager.Ticket getShelfTicket(BlockPoppetShelf.TileEntityPoppetShelf aShelf) {
        Field aChunkTicket = ReflectionUtils.getField(BlockPoppetShelf.TileEntityPoppetShelf.class, "");
        if (aChunkTicket != null) {
            return (ForgeChunkManager.Ticket)ReflectionUtils.getFieldValue(aChunkTicket, aShelf);
        }
        return null;
    }

    public static void initiate(BlockPoppetShelf.TileEntityPoppetShelf aShelf) {
        if (AsmConfig.allowPoppetShelfChunkLoading) {
            ForgeChunkManager.Ticket chunkTicket = PoppetShelfUtils.getShelfTicket(aShelf);
            if (!aShelf.getWorldObj().isRemote && chunkTicket == null) {
                chunkTicket = ForgeChunkManager.requestTicket((Object)Witchery.instance, (World)aShelf.getWorldObj(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (chunkTicket != null) {
                    chunkTicket.getModData().setInteger("poppetX", aShelf.xCoord);
                    chunkTicket.getModData().setInteger("poppetY", aShelf.yCoord);
                    chunkTicket.getModData().setInteger("poppetZ", aShelf.zCoord);
                    aShelf.forceChunkLoading(chunkTicket);
                } else {
                    Log.instance().warning(String.format("The poppet shelf at %d, %d, %d failed to register a chunk loader.", aShelf.xCoord, aShelf.yCoord, aShelf.zCoord));
                }
            }
        }
    }

    public static void invalidate(BlockPoppetShelf.TileEntityPoppetShelf aShelf) {
        if (!aShelf.getWorldObj().isRemote && AsmConfig.allowPoppetShelfChunkLoading) {
            ForgeChunkManager.Ticket chunkTicket = PoppetShelfUtils.getShelfTicket(aShelf);
            if (chunkTicket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)chunkTicket);
            } else {
                Log.instance().warning(String.format("Chunk loader ticket is null for poppet shelf at %d, %d, %d.", aShelf.xCoord, aShelf.yCoord, aShelf.zCoord));
            }
        }
    }
}

