/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class Utils {
    public static final short W = Short.MAX_VALUE;

    public static synchronized ItemStack getSimpleStack(Item x, int i) {
        return Utils.getSimpleStack(new ItemStack(x), i);
    }

    public static synchronized ItemStack getSimpleStack(ItemStack x, int i) {
        try {
            ItemStack r = x.copy();
            r.stackSize = i;
            return r;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static ItemStack[] getAllItemsFromOreDictEntry(String oreDictName) {
        return Utils.getAllItemsFromOreDictEntry(oreDictName, new ItemStack[0]);
    }

    public static ItemStack[] getAllItemsFromOreDictEntry(String oreDictName, ItemStack[] exclusions) {
        HashSet<ItemStack> Q = new HashSet<ItemStack>();
        if (OreDictionary.doesOreNameExist((String)oreDictName)) {
            for (ItemStack i : OreDictionary.getOres((String)oreDictName)) {
                if (i == null) continue;
                if (exclusions.length > 0) {
                    for (int r = 0; r < exclusions.length; ++r) {
                        if (i.equals(exclusions[r]) || ItemStack.areItemStacksEqual((ItemStack)i, (ItemStack)exclusions[r])) continue;
                        Q.add(i);
                    }
                    continue;
                }
                Q.add(i);
            }
        }
        ItemStack[] V = new ItemStack[]{};
        int mSlot = 0;
        if (Q.size() > 0) {
            V = new ItemStack[Q.size()];
            for (ItemStack w : Q) {
                V[mSlot++] = w;
            }
        }
        return V;
    }

    public static synchronized boolean removeAllCraftingRecipesByOutputItem(ItemStack I) {
        if (I == null) {
            return false;
        }
        List recipes = CraftingManager.getInstance().getRecipeList();
        return recipes.removeIf(s -> s != null && s.getRecipeOutput() != null && s.getRecipeOutput().isItemEqual(I));
    }

    public static void registerEvent(Object o) {
        MinecraftForge.EVENT_BUS.register(o);
        FMLCommonHandler.instance().bus().register(o);
    }

    public static boolean hasValidOreDictTag(String validTag, ItemStack hasTag) {
        if (hasTag != null) {
            for (int tag : OreDictionary.getOreIDs((ItemStack)hasTag)) {
                String oreName = OreDictionary.getOreName((int)tag);
                if (!oreName.equalsIgnoreCase(validTag)) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack simpleMetaStack(Item item, int meta, int size) {
        try {
            if (item == null) {
                return null;
            }
            ItemStack metaStack = new ItemStack(item, size, meta);
            return metaStack;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static ItemStack simpleMetaStack(Block block, int meta, int size) {
        return Utils.simpleMetaStack(Item.getItemFromBlock((Block)block), meta, size);
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2) {
        return Utils.areStacksEqual(aStack1, aStack2, false);
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return !(aStack1 == null || aStack2 == null || aStack1.getItem() != aStack2.getItem() || !aIgnoreNBT && (aStack1.getTagCompound() == null != (aStack2.getTagCompound() == null) || aStack1.getTagCompound() != null && !aStack1.getTagCompound().equals((Object)aStack2.getTagCompound())) || Items.feather.getDamage(aStack1) != Items.feather.getDamage(aStack2) && Items.feather.getDamage(aStack1) != Short.MAX_VALUE && Items.feather.getDamage(aStack2) != Short.MAX_VALUE);
    }

    public static boolean isDevEnv() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }
}

