/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util;

import alkalus.main.core.crafting.OvenRecipes;
import alkalus.main.core.util.ReflectionUtils;
import alkalus.main.core.util.Utils;
import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockWitchesOven;
import com.emoniph.witchery.util.Config;
import com.emoniph.witchery.util.Log;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class WitchesOvenUtils {
    private static final int COOK_TIME = 180;
    private static final double FUNNEL_CHANCE = 0.25;
    private static final double FILTERED_FUNNEL_CHANCE = 0.3;
    private static final double DOUBLED_FILTERED_FUNNEL_CHANCE = 0.8;
    private static final int SLOT_TO_COOK = 0;
    private static final int SLOT_FUEL = 1;
    private static final int SLOT_COOKED = 2;
    private static final int SLOT_BY_PRODUCT = 3;
    private static final int SLOT_JARS = 4;
    private static final int[] slots_top = new int[]{0, 4};
    private static final int[] slots_bottom = new int[]{4, 1};
    private static final int[] slots_sides = new int[]{3, 2, 4, 1};

    public static ItemStack[] getFurnaceItemStacks(BlockWitchesOven.TileEntityWitchesOven aTile) {
        return (ItemStack[])ReflectionUtils.getFieldValue(ReflectionUtils.getField(BlockWitchesOven.TileEntityWitchesOven.class, "furnaceItemStacks"), aTile);
    }

    public static int[] getSlotsTop(BlockWitchesOven.TileEntityWitchesOven aTile) {
        return (int[])ReflectionUtils.getFieldValue(ReflectionUtils.getField(BlockWitchesOven.TileEntityWitchesOven.class, "slots_top"), aTile);
    }

    public static int[] getSlotsBottom(BlockWitchesOven.TileEntityWitchesOven aTile) {
        return (int[])ReflectionUtils.getFieldValue(ReflectionUtils.getField(BlockWitchesOven.TileEntityWitchesOven.class, "slots_bottom"), aTile);
    }

    public static int[] getSlotsSides(BlockWitchesOven.TileEntityWitchesOven aTile) {
        return (int[])ReflectionUtils.getFieldValue(ReflectionUtils.getField(BlockWitchesOven.TileEntityWitchesOven.class, "slots_sides"), aTile);
    }

    public static void updateEntity(BlockWitchesOven.TileEntityWitchesOven aTile) {
        boolean flag = aTile.furnaceBurnTime > 0;
        boolean aDoBlockUpdate = false;
        if (aTile.furnaceBurnTime > 0) {
            --aTile.furnaceBurnTime;
        }
        if (!aTile.getWorldObj().isRemote) {
            if (WitchesOvenUtils.canSmelt(aTile)) {
                if (aTile.furnaceBurnTime == 0) {
                    int itemBurnTime;
                    aTile.furnaceBurnTime = itemBurnTime = TileEntityFurnace.getItemBurnTime((ItemStack)WitchesOvenUtils.getFuelSlot(aTile));
                    aTile.currentItemBurnTime = itemBurnTime;
                    if (aTile.furnaceBurnTime > 0) {
                        aDoBlockUpdate = true;
                        if (WitchesOvenUtils.getFuelSlot(aTile) != null) {
                            ItemStack itemStack = WitchesOvenUtils.getFuelSlot(aTile);
                            --itemStack.stackSize;
                            if (WitchesOvenUtils.getFuelSlot((BlockWitchesOven.TileEntityWitchesOven)aTile).stackSize == 0) {
                                WitchesOvenUtils.setFuelSlot(aTile, WitchesOvenUtils.getFuelSlot(aTile).getItem().getContainerItem(WitchesOvenUtils.getFuelSlot(aTile)));
                            }
                        }
                    }
                }
                if (aTile.isBurning()) {
                    ++aTile.furnaceCookTime;
                    if (aTile.furnaceCookTime >= WitchesOvenUtils.getCookTime(aTile)) {
                        aTile.furnaceCookTime = 0;
                        WitchesOvenUtils.smeltItem(aTile);
                        aDoBlockUpdate = true;
                    }
                } else {
                    aTile.furnaceCookTime = 0;
                }
            }
            if (flag != aTile.furnaceBurnTime > 0) {
                aDoBlockUpdate = true;
                BlockWitchesOven.updateWitchesOvenBlockState((aTile.furnaceBurnTime > 0 ? 1 : 0) != 0, (World)aTile.getWorldObj(), (int)aTile.xCoord, (int)aTile.yCoord, (int)aTile.zCoord);
            }
        }
        if (aDoBlockUpdate) {
            aTile.markDirty();
            aTile.getWorldObj().markBlockForUpdate(aTile.xCoord, aTile.yCoord, aTile.zCoord);
        }
    }

    public static int getEmptyJarCount(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getEmptyJarSlot(aTile);
        return aJarStack != null ? aJarStack.stackSize : 0;
    }

    public static ItemStack getInputSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[0];
        return aJarStack != null ? aJarStack : null;
    }

    public static ItemStack getFuelSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[1];
        return aJarStack != null ? aJarStack : null;
    }

    public static ItemStack getOutputSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[2];
        return aJarStack != null ? aJarStack : null;
    }

    public static ItemStack getFumeOutputSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[3];
        return aJarStack != null ? aJarStack : null;
    }

    public static ItemStack getEmptyJarSlot(BlockWitchesOven.TileEntityWitchesOven aTile) {
        ItemStack aJarStack = WitchesOvenUtils.getFurnaceItemStacks(aTile)[4];
        return aJarStack != null ? aJarStack : null;
    }

    public static void setInputSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[0] = aNewVal;
    }

    public static void setFuelSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[1] = aNewVal;
    }

    public static void setOutputSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[2] = aNewVal;
    }

    public static void setFumeOutputSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[3] = aNewVal;
    }

    public static void setEmptyJarSlot(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack aNewVal) {
        WitchesOvenUtils.getFurnaceItemStacks((BlockWitchesOven.TileEntityWitchesOven)aTile)[4] = aNewVal;
    }

    public static boolean canSmelt(BlockWitchesOven.TileEntityWitchesOven aTile) {
        if (WitchesOvenUtils.getInputSlot(aTile) == null) {
            return false;
        }
        OvenRecipes.OvenRecipe aValidRecipe = null;
        int aJarCount = WitchesOvenUtils.getEmptyJarCount(aTile);
        if (aJarCount == 0) {
            for (OvenRecipes.OvenRecipe r : OvenRecipes.getRecipeMap()) {
                if (r.jars > 0 || !Utils.areStacksEqual(r.inputs, WitchesOvenUtils.getInputSlot(aTile))) continue;
                aValidRecipe = r;
                break;
            }
        } else {
            for (OvenRecipes.OvenRecipe r : OvenRecipes.getRecipeMap()) {
                if (r.jars > aJarCount || !Utils.areStacksEqual(r.inputs, WitchesOvenUtils.getInputSlot(aTile))) continue;
                aValidRecipe = r;
                break;
            }
        }
        if (aValidRecipe == null) {
            return false;
        }
        ItemStack itemstack = aValidRecipe.output;
        if (!WitchesOvenUtils.getOutputSlot(aTile).isItemEqual(itemstack)) {
            return false;
        }
        int result = WitchesOvenUtils.getOutputSlot((BlockWitchesOven.TileEntityWitchesOven)aTile).stackSize + itemstack.stackSize;
        return result <= aTile.getInventoryStackLimit() && result <= itemstack.getMaxStackSize();
    }

    public static void smeltItem(BlockWitchesOven.TileEntityWitchesOven aTile) {
        OvenRecipes.OvenRecipe aValidRecipe = null;
        int aJarCount = WitchesOvenUtils.getEmptyJarCount(aTile);
        if (aJarCount == 0) {
            for (OvenRecipes.OvenRecipe r : OvenRecipes.getRecipeMap()) {
                if (r.jars > 0 || !Utils.areStacksEqual(r.inputs, WitchesOvenUtils.getInputSlot(aTile))) continue;
                aValidRecipe = r;
                break;
            }
        } else {
            for (OvenRecipes.OvenRecipe r : OvenRecipes.getRecipeMap()) {
                if (r.jars > aJarCount || !Utils.areStacksEqual(r.inputs, WitchesOvenUtils.getInputSlot(aTile))) continue;
                aValidRecipe = r;
                break;
            }
        }
        if (aValidRecipe == null) {
            return;
        }
    }

    public static int getFumeFunnels(BlockWitchesOven.TileEntityWitchesOven aTile) {
        int funnels = 0;
        int meta = aTile.getWorldObj().getBlockMetadata(aTile.xCoord, aTile.yCoord, aTile.zCoord);
        switch (meta) {
            case 2: 
            case 3: {
                funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.xCoord - 1, aTile.yCoord, aTile.zCoord, meta) ? 1 : 0;
                funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.xCoord + 1, aTile.yCoord, aTile.zCoord, meta) ? 1 : 0;
                break;
            }
            case 4: 
            case 5: {
                funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.xCoord, aTile.yCoord, aTile.zCoord - 1, meta) ? 1 : 0;
                funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.xCoord, aTile.yCoord, aTile.zCoord + 1, meta) ? 1 : 0;
            }
        }
        return funnels += WitchesOvenUtils.isFumeFunnel(aTile, aTile.xCoord, aTile.yCoord + 1, aTile.zCoord, meta) ? 1 : 0;
    }

    public static boolean isFumeFunnel(BlockWitchesOven.TileEntityWitchesOven aTile, int xCoord, int yCoord, int zCoord, int meta) {
        Block block = aTile.getWorldObj().getBlock(xCoord, yCoord, zCoord);
        return (block == Witchery.Blocks.OVEN_FUMEFUNNEL || block == Witchery.Blocks.OVEN_FUMEFUNNEL_FILTERED) && aTile.getWorldObj().getBlockMetadata(xCoord, yCoord, zCoord) == meta;
    }

    public static double getFumeFunnelsChance(BlockWitchesOven.TileEntityWitchesOven aTile) {
        double funnels = 0.0;
        switch (aTile.getWorldObj().getBlockMetadata(aTile.xCoord, aTile.yCoord, aTile.zCoord)) {
            case 2: {
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.xCoord + 1, aTile.yCoord, aTile.zCoord, 2);
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.xCoord - 1, aTile.yCoord, aTile.zCoord, 2);
                break;
            }
            case 3: {
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.xCoord + 1, aTile.yCoord, aTile.zCoord, 3);
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.xCoord - 1, aTile.yCoord, aTile.zCoord, 3);
                break;
            }
            case 4: {
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.xCoord, aTile.yCoord, aTile.zCoord + 1, 4);
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.xCoord, aTile.yCoord, aTile.zCoord - 1, 4);
                break;
            }
            case 5: {
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.xCoord, aTile.yCoord, aTile.zCoord + 1, 5);
                funnels += WitchesOvenUtils.getFumeFunnelChance(aTile, aTile.xCoord, aTile.yCoord, aTile.zCoord - 1, 5);
            }
        }
        return funnels;
    }

    public static double getFumeFunnelChance(BlockWitchesOven.TileEntityWitchesOven aTile, int x, int y, int z, int meta) {
        Block block = aTile.getWorldObj().getBlock(x, y, z);
        if (block == Witchery.Blocks.OVEN_FUMEFUNNEL) {
            if (aTile.getWorldObj().getBlockMetadata(x, y, z) == meta) {
                return 0.25;
            }
        } else if (block == Witchery.Blocks.OVEN_FUMEFUNNEL_FILTERED && aTile.getWorldObj().getBlockMetadata(x, y, z) == meta) {
            return Config.instance().doubleFumeFilterChance ? 0.8 : 0.3;
        }
        return 0.0;
    }

    public static int getCookTime(BlockWitchesOven.TileEntityWitchesOven aTile) {
        int time = 180 - 20 * WitchesOvenUtils.getFumeFunnels(aTile);
        return time;
    }

    public static void generateByProduct(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack itemstack) {
        try {
            double BASE_CHANCE = 0.3;
            double funnels = WitchesOvenUtils.getFumeFunnelsChance(aTile);
            Log.instance().debug("" + WitchesOvenUtils.getInputSlot(aTile) + ": " + WitchesOvenUtils.getInputSlot(aTile).getItem().getUnlocalizedName());
            if (aTile.getWorldObj().rand.nextDouble() <= Math.min(0.3 + funnels, 1.0) && WitchesOvenUtils.getEmptyJarSlot(aTile) != null) {
                if (WitchesOvenUtils.getInputSlot(aTile).getItem() == Item.getItemFromBlock((Block)Blocks.sapling) && WitchesOvenUtils.getInputSlot(aTile).getItemDamage() != 3) {
                    switch (WitchesOvenUtils.getInputSlot(aTile).getItemDamage()) {
                        case 0: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemExhaleOfTheHornedOne.createStack(1));
                            break;
                        }
                        case 1: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemHintOfRebirth.createStack(1));
                            break;
                        }
                        case 2: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemBreathOfTheGoddess.createStack(1));
                        }
                    }
                } else if (WitchesOvenUtils.getInputSlot(aTile).getItem() == Item.getItemFromBlock((Block)Witchery.Blocks.SAPLING)) {
                    switch (WitchesOvenUtils.getInputSlot(aTile).getItemDamage()) {
                        case 0: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemWhiffOfMagic.createStack(1));
                            break;
                        }
                        case 1: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemReekOfMisfortune.createStack(1));
                            break;
                        }
                        case 2: {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemOdourOfPurity.createStack(1));
                        }
                    }
                } else if (WitchesOvenUtils.getInputSlot(aTile).getUnlocalizedName().equals("tile.bop.saplings") && WitchesOvenUtils.getInputSlot(aTile).getItemDamage() == 6) {
                    WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemHintOfRebirth.createStack(1));
                } else if (WitchesOvenUtils.isForestrySapling(WitchesOvenUtils.getInputSlot(aTile))) {
                    String treeType;
                    NBTTagCompound chromosome;
                    NBTTagCompound chromoBase;
                    NBTTagList list;
                    NBTTagCompound compound;
                    NBTBase tag = WitchesOvenUtils.getInputSlot(aTile).getTagCompound().getTag("Genome");
                    if (tag != null && tag instanceof NBTTagCompound && (compound = (NBTTagCompound)tag).hasKey("Chromosomes") && compound.getTag("Chromosomes") instanceof NBTTagList && (list = compound.getTagList("Chromosomes", 10)) != null && list.tagCount() > 0 && (chromoBase = list.getCompoundTagAt(0)) != null && chromoBase instanceof NBTTagCompound && (chromosome = chromoBase).hasKey("UID0") && (treeType = chromosome.getString("UID0")) != null) {
                        Log.instance().debug("Forestry tree: " + treeType);
                        if (treeType.equals("forestry.treeOak")) {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemExhaleOfTheHornedOne.createStack(1));
                        } else if (treeType.equals("forestry.treeSpruce")) {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemHintOfRebirth.createStack(1));
                        } else if (treeType.equals("forestry.treeBirch")) {
                            WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemBreathOfTheGoddess.createStack(1));
                        }
                    }
                } else {
                    WitchesOvenUtils.createByProduct(aTile, Witchery.Items.GENERIC.itemFoulFume.createStack(1));
                }
            }
        }
        catch (Throwable e) {
            Log.instance().warning(e, "Exception occured while generating a by product from a witches oven");
        }
    }

    public static void createByProduct(BlockWitchesOven.TileEntityWitchesOven aTile, ItemStack byProduct) {
        int BY_PRODUCT_INDEX = 3;
        if (WitchesOvenUtils.getFumeOutputSlot(aTile) == null) {
            WitchesOvenUtils.setFumeOutputSlot(aTile, byProduct);
            ItemStack itemStack = WitchesOvenUtils.getEmptyJarSlot(aTile);
            if (--itemStack.stackSize <= 0) {
                WitchesOvenUtils.setEmptyJarSlot(aTile, null);
            }
        } else if (WitchesOvenUtils.getFumeOutputSlot(aTile).isItemEqual(byProduct) && WitchesOvenUtils.getFumeOutputSlot((BlockWitchesOven.TileEntityWitchesOven)aTile).stackSize + byProduct.stackSize < WitchesOvenUtils.getFumeOutputSlot(aTile).getMaxStackSize()) {
            ItemStack itemStack2 = WitchesOvenUtils.getFumeOutputSlot(aTile);
            itemStack2.stackSize += byProduct.stackSize;
            ItemStack itemStack3 = WitchesOvenUtils.getEmptyJarSlot(aTile);
            if (--itemStack3.stackSize <= 0) {
                WitchesOvenUtils.setEmptyJarSlot(aTile, null);
            }
        }
    }

    private static boolean isForestrySapling(ItemStack aSap) {
        return aSap != null && aSap.hasTagCompound() && aSap.getTagCompound().hasKey("Genome");
    }

    public static ItemStack getVanillaEquivForForestrySapling(ItemStack aSap) {
        String treeType;
        NBTTagCompound chromosome;
        NBTTagCompound chromoBase;
        NBTTagList list;
        NBTTagCompound compound;
        NBTBase tag;
        if (WitchesOvenUtils.isForestrySapling(aSap) && (tag = aSap.getTagCompound().getTag("Genome")) != null && tag instanceof NBTTagCompound && (compound = (NBTTagCompound)tag).hasKey("Chromosomes") && compound.getTag("Chromosomes") instanceof NBTTagList && (list = compound.getTagList("Chromosomes", 10)) != null && list.tagCount() > 0 && (chromoBase = list.getCompoundTagAt(0)) != null && chromoBase instanceof NBTTagCompound && (chromosome = chromoBase).hasKey("UID0") && (treeType = chromosome.getString("UID0")) != null) {
            Log.instance().debug("Forestry tree: " + treeType);
            if (treeType.equals("forestry.treeOak")) {
                return new ItemStack(Blocks.sapling, 1, 0);
            }
            if (treeType.equals("forestry.treeSpruce")) {
                return new ItemStack(Blocks.sapling, 1, 1);
            }
            if (treeType.equals("forestry.treeBirch")) {
                return new ItemStack(Blocks.sapling, 1, 2);
            }
        }
        return null;
    }
}

