/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.util.threadly;

import alkalus.main.core.WitcheryExtras;
import java.util.Collections;
import java.util.Iterator;

public class RunnableChain
implements Runnable {
    protected final boolean exceptionStopsChain;
    private final Iterable<? extends Runnable> toRun;

    public RunnableChain(boolean exceptionStopsChain, Iterable<? extends Runnable> toRun) {
        if (toRun == null) {
            toRun = Collections.emptyList();
        }
        this.exceptionStopsChain = exceptionStopsChain;
        this.toRun = toRun;
        WitcheryExtras.log(0, "[Module Loader] Loading Module with " + toRun.spliterator().getExactSizeIfKnown() + " objects.");
    }

    @Override
    public void run() {
        if (this.exceptionStopsChain) {
            this.runExceptionsCascade();
        } else {
            this.runIsolated();
        }
    }

    protected void runExceptionsCascade() {
        Iterator<? extends Runnable> it = this.toRun.iterator();
        while (it.hasNext()) {
            it.next().run();
        }
    }

    protected void runIsolated() {
        Iterator<? extends Runnable> it = this.toRun.iterator();
        while (it.hasNext()) {
            RunnableChain.runRunnable(it.next());
        }
    }

    public static void runRunnable(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            RunnableChain.handleException(t);
        }
    }

    public static void handleException(Throwable t) {
        if (t == null) {
            return;
        }
        try {
            Thread currentThread = Thread.currentThread();
            Thread.UncaughtExceptionHandler ueHandler = currentThread.getUncaughtExceptionHandler();
            ueHandler.uncaughtException(currentThread, t);
        }
        catch (Throwable handlerThrown) {
            try {
                System.err.println("Error handling exception: ");
                t.printStackTrace();
                System.err.println("Error thrown when handling exception: ");
                handlerThrown.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

