/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.nei;

import alkalus.main.core.crafting.OvenRecipes;
import alkalus.main.core.util.Utils;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.emoniph.witchery.Witchery;
import com.emoniph.witchery.blocks.BlockWitchesOvenGUI;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.StatCollector;

public class NEI_Handler_Oven
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static TreeSet<Integer> efuels;

    public Class<? extends GuiContainer> getGuiClass() {
        return BlockWitchesOvenGUI.class;
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"tile.witchery:witchesovenidle.name");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("witchery_cooking") && ((Object)((Object)this)).getClass() == NEI_Handler_Oven.class) {
            ArrayList<OvenRecipes.OvenRecipe> recipes = OvenRecipes.getRecipeMap();
            for (OvenRecipes.OvenRecipe recipe : recipes) {
                if (!recipe.isValid()) continue;
                ItemStack input = recipe.inputs.copy();
                ItemStack output = recipe.output.copy();
                ItemStack outputJar = recipe.outputJar.copy();
                SmeltingPair rec = new SmeltingPair(input, output, outputJar);
                this.arecipes.add(rec);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result == null) {
            return;
        }
        ArrayList<OvenRecipes.OvenRecipe> recipes = OvenRecipes.getRecipeMap();
        for (OvenRecipes.OvenRecipe recipe : recipes) {
            if (!recipe.isValid()) continue;
            ItemStack input = recipe.inputs.copy();
            ItemStack output = recipe.output.copy();
            ItemStack outputJar = recipe.outputJar.copy();
            if (!Utils.areStacksEqual(result, output, true)) continue;
            SmeltingPair rec = new SmeltingPair(input, output, outputJar);
            this.arecipes.add(rec);
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == NEI_Handler_Oven.class) {
            this.loadCraftingRecipes("witchery_cooking", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ArrayList<OvenRecipes.OvenRecipe> recipes = OvenRecipes.getRecipeMap();
        if (ingredient != null) {
            // empty if block
        }
        for (OvenRecipes.OvenRecipe recipe : recipes) {
            if (!recipe.isValid()) continue;
            ItemStack input = recipe.inputs.copy();
            ItemStack output = recipe.output.copy();
            ItemStack outputJar = recipe.outputJar.copy();
            if (!Utils.areStacksEqual(ingredient, input, true)) continue;
            SmeltingPair rec = new SmeltingPair(input, output, outputJar);
            this.arecipes.add(rec);
        }
    }

    public String getGuiTexture() {
        return "witchery:textures/gui/witchesOven.png";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 9, 24, 18), "witchery_cooking", new Object[0]));
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 9, 176, 14, 24, 16, 48, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.getItemFromBlock((Block)Blocks.brown_mushroom));
        efuels.add(Item.getItemFromBlock((Block)Blocks.red_mushroom));
        efuels.add(Item.getItemFromBlock((Block)Blocks.standing_sign));
        efuels.add(Item.getItemFromBlock((Block)Blocks.wall_sign));
        efuels.add(Item.getItemFromBlock((Block)Blocks.wooden_door));
        efuels.add(Item.getItemFromBlock((Block)Blocks.trapped_chest));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = NEI_Handler_Oven.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (item == null || efuels.contains(item.getItem()) || (burnTime = TileEntityFurnace.getItemBurnTime((ItemStack)item)) <= 0) continue;
            afuels.add(new FuelPair(item.copy(), burnTime));
        }
    }

    private static void findFuelsOnce() {
        if (afuels == null) {
            NEI_Handler_Oven.findFuels();
        }
    }

    public String getOverlayIdentifier() {
        return "witchery_cooking";
    }

    public TemplateRecipeHandler newInstance() {
        NEI_Handler_Oven.findFuelsOnce();
        return super.newInstance();
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;
        PositionedStack byproduct;
        PositionedStack jar;

        public SmeltingPair(ItemStack ingred, ItemStack result, ItemStack byproduct) {
            super((TemplateRecipeHandler)NEI_Handler_Oven.this);
            ingred.stackSize = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)result, 113, 10);
            this.byproduct = new PositionedStack((Object)byproduct, 113, 42);
            this.jar = new PositionedStack((Object)Witchery.Items.GENERIC.itemEmptyClayJar.createStack(), 78, 42);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEI_Handler_Oven.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            NEI_Handler_Oven.findFuelsOnce();
            if (afuels != null && afuels.size() > 0) {
                return NEI_Handler_Oven.afuels.get((int)(NEI_Handler_Oven.this.cycleticks / 48 % NEI_Handler_Oven.afuels.size())).stack;
            }
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            stacks.add(this.byproduct);
            stacks.add(this.jar);
            return stacks;
        }
    }
}

