/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.auxiliary;

import eu.usrv.yamcore.auxiliary.IntHelper;
import eu.usrv.yamcore.auxiliary.classes.JSONChatText;
import java.util.ArrayList;
import java.util.Formatter;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class PlayerChatHelper {
    public static void SendPlain(ICommandSender pCommandSender, String pMessage) {
        pCommandSender.addChatMessage((IChatComponent)new ChatComponentText(pMessage));
    }

    public static void SendPlain(ICommandSender pCommandSender, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendPlain(pCommandSender, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendPlain(EntityPlayer pPlayer, String pMessage) {
        pPlayer.addChatMessage((IChatComponent)new ChatComponentText(pMessage));
    }

    public static void SendPlain(EntityPlayer pPlayer, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendPlain(pPlayer, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendInfo(ICommandSender pCommandSender, String pMessage) {
        pCommandSender.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + pMessage));
    }

    public static void SendInfo(ICommandSender pCommandSender, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendInfo(pCommandSender, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendError(ICommandSender pCommandSender, String pMessage) {
        pCommandSender.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + pMessage));
    }

    public static void SendWarn(ICommandSender pCommandSender, String pMessage) {
        pCommandSender.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + pMessage));
    }

    public static void SendError(ICommandSender pCommandSender, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendError(pCommandSender, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendWarn(ICommandSender pCommandSender, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendWarn(pCommandSender, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendInfo(EntityPlayer pPlayer, String pMessage) {
        pPlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.GREEN + pMessage));
    }

    public static void SendError(EntityPlayer pPlayer, String pMessage) {
        pPlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + pMessage));
    }

    public static void SendWarn(EntityPlayer pPlayer, String pMessage) {
        pPlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + pMessage));
    }

    public static void SendInfo(EntityPlayer pPlayer, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendInfo(pPlayer, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendError(EntityPlayer pPlayer, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendError(pPlayer, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendWarn(EntityPlayer pPlayer, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendWarn(pPlayer, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendNotifyPositive(EntityPlayer pPlayer, String pMessage) {
        pPlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_GREEN + pMessage));
    }

    public static void SendNotifyNormal(EntityPlayer pPlayer, String pMessage) {
        pPlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + pMessage));
    }

    public static void SendNotifyWarning(EntityPlayer pPlayer, String pMessage) {
        pPlayer.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + pMessage));
    }

    public static void SendNotifyPositive(EntityPlayer pPlayer, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendNotifyPositive(pPlayer, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendNotifyNormal(EntityPlayer pPlayer, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendNotifyNormal(pPlayer, f.format(pMessage, pArgs).toString());
        }
    }

    public static void SendNotifyWarning(EntityPlayer pPlayer, String pMessage, Object ... pArgs) {
        try (Formatter f = new Formatter();){
            PlayerChatHelper.SendNotifyWarning(pPlayer, f.format(pMessage, pArgs).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void SendJsonFormatted(EntityPlayer pPlayer, String pMessage, JSONChatText ... pChatObjects) throws Exception {
        char[] tMessageArray = pMessage.toCharArray();
        ArrayList<JSONChatText> tMessageParts = new ArrayList<JSONChatText>();
        int tokenLastEnd = 0;
        int tokenStart = -1;
        int tokenEnd = -1;
        for (int i = 0; i < tMessageArray.length; ++i) {
            if (tMessageArray[i] == '{') {
                if (i > 0) {
                    if (tMessageArray[i - 1] != '\\') {
                        if (tokenStart > -1) {
                            throw new Exception(String.format("Unescaped token-start symbol found at position %d", i));
                        }
                        tokenStart = i;
                    }
                } else {
                    tokenStart = i;
                }
            }
            if (tMessageArray[i] == '}') {
                if (i <= 0) throw new Exception(String.format("Unescaped token-start symbol found at position %d", i));
                if (tMessageArray[i - 1] != '\\') {
                    if (tokenStart <= -1) throw new Exception(String.format("Unescaped token-start symbol found at position %d", i));
                    tokenEnd = i;
                }
            }
            if (tokenStart <= -1 || tokenEnd <= -1) continue;
            tMessageParts.add(PlayerChatHelper.extractSubStringToJSON(pMessage, tokenLastEnd, tokenStart));
            String tArgNr = pMessage.substring(tokenStart + 1, tokenEnd);
            if (!IntHelper.tryParse(tArgNr)) {
                throw new IllegalArgumentException(String.format("Token-Element at pos %d is not an integer (%s)", tokenStart + 1, tArgNr));
            }
            int tArg = Integer.parseInt(tArgNr);
            if (pChatObjects.length < tArg) {
                throw new IndexOutOfBoundsException(String.format("Token-ID %d requested, but only given %d !", tArg, pChatObjects.length));
            }
            tMessageParts.add(pChatObjects[tArg]);
            tokenLastEnd = tokenEnd + 1;
            tokenStart = -1;
            tokenEnd = -1;
        }
        if (tokenLastEnd < tMessageArray.length) {
            tMessageParts.add(PlayerChatHelper.extractSubStringToJSON(pMessage, tokenLastEnd, tMessageArray.length - 1));
        }
        JSONChatText[] tJsonMessages = new JSONChatText[tMessageParts.size()];
        tJsonMessages = tMessageParts.toArray(tJsonMessages);
        PlayerChatHelper.SendJsonRaw(pPlayer, tJsonMessages);
    }

    private static JSONChatText extractSubStringToJSON(String pMessage, int pStart, int pEnd) {
        String tMessagePart = pMessage.substring(pStart, pEnd);
        tMessagePart = tMessagePart.replace("\\{", "{");
        tMessagePart = tMessagePart.replace("\\}", "}");
        return JSONChatText.simpleMessage(tMessagePart);
    }

    public static void SendJsonRaw(EntityPlayer pPlayer, JSONChatText ... pChatObjects) {
        MinecraftServer tMCServer = MinecraftServer.getServer();
        ICommandManager tCmdMngr = tMCServer.getCommandManager();
        if (tMCServer != null) {
            String tConstructedJSON = "";
            if (pChatObjects.length > 1) {
                boolean tFirst = true;
                tConstructedJSON = "[";
                for (JSONChatText pChatObject : pChatObjects) {
                    if (tFirst) {
                        tFirst = false;
                    } else {
                        tConstructedJSON = tConstructedJSON + ", ";
                    }
                    tConstructedJSON = tConstructedJSON + pChatObject.getConstructed();
                }
                tConstructedJSON = tConstructedJSON + "]";
            } else {
                tConstructedJSON = pChatObjects[0].getConstructed();
            }
            tCmdMngr.executeCommand((ICommandSender)tMCServer, "tellraw " + pPlayer.getCommandSenderName() + " " + tConstructedJSON);
        }
    }
}

