/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.auxiliary.classes;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import eu.usrv.yamcore.auxiliary.classes.JSONClickEvent;
import eu.usrv.yamcore.auxiliary.classes.JSONHoverEvent;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class JSONChatText {
    public boolean Bold;
    public boolean Italic;
    public boolean Underlined;
    public boolean Strikethrough;
    public boolean Obfuscated;
    public EnumChatFormatting Color = null;
    public JSONHoverEvent HoverEvent = null;
    public JSONClickEvent ClickEvent = null;
    public String Message = "";
    public String Translate = "";
    public ArrayList<String> TranslateArray = null;

    public static JSONChatText simpleMessage(String pMessage) {
        JSONChatText tJ = new JSONChatText();
        tJ.Message = pMessage;
        return tJ;
    }

    public static JSONChatText simpleMessageWToolTip(String pMessage, String pToolTip) {
        JSONChatText tJ = new JSONChatText();
        tJ.Message = pMessage;
        tJ.HoverEvent = JSONHoverEvent.SimpleText(pToolTip);
        return tJ;
    }

    public static JSONChatText simpleMessageWToolTip(String pMessage, ItemDescriptor pItem) {
        JSONChatText tJ = new JSONChatText();
        tJ.Message = pMessage;
        tJ.HoverEvent = JSONHoverEvent.Item(pItem);
        return tJ;
    }

    public static JSONChatText simpleMessageWToolTip(String pMessage, ItemStack pItem) {
        return JSONChatText.simpleMessageWToolTip(pMessage, ItemDescriptor.fromStack(pItem));
    }

    public static JSONChatText simpleMessageWToolTip(String pMessage, Item pItem) {
        return JSONChatText.simpleMessageWToolTip(pMessage, ItemDescriptor.fromItem(pItem));
    }

    public static JSONChatText simpleMessageWCommand(String pMessage, String pCommand) {
        return JSONChatText.simpleMessageWCommand(pMessage, pCommand, false);
    }

    public static JSONChatText simpleMessageWCommand(String pMessage, String pCommand, boolean pSuggestOnly) {
        JSONChatText tJ = new JSONChatText();
        tJ.Message = pMessage;
        tJ.ClickEvent = pSuggestOnly ? JSONClickEvent.suggestCommand(pCommand) : JSONClickEvent.runCommand(pCommand);
        return tJ;
    }

    public String toString() {
        return this.getConstructed();
    }

    public String getConstructed() {
        JsonObject tResultObject = new JsonObject();
        if (this.Message != "") {
            tResultObject.addProperty("text", this.Message);
        }
        if (this.Translate != "") {
            tResultObject.addProperty("translate", this.Translate);
        }
        if (this.TranslateArray != null) {
            tResultObject.add("with", new Gson().toJsonTree(this.TranslateArray));
        }
        if (this.Bold) {
            tResultObject.addProperty("bold", Boolean.valueOf(true));
        }
        if (this.Italic) {
            tResultObject.addProperty("italic", Boolean.valueOf(true));
        }
        if (this.Underlined) {
            tResultObject.addProperty("underlined", Boolean.valueOf(true));
        }
        if (this.Strikethrough) {
            tResultObject.addProperty("strikethrough", Boolean.valueOf(true));
        }
        if (this.Obfuscated) {
            tResultObject.addProperty("obfuscated", Boolean.valueOf(true));
        }
        if (this.Color != null) {
            tResultObject.addProperty("color", this.Color.getFriendlyName());
        }
        if (this.HoverEvent != null) {
            tResultObject.add("hoverEvent", (JsonElement)this.HoverEvent.getJson());
        }
        if (this.ClickEvent != null) {
            tResultObject.add("clickEvent", (JsonElement)this.ClickEvent.getJson());
        }
        return tResultObject.toString();
    }
}

