/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.auxiliary.classes;

import com.google.gson.JsonObject;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import net.minecraft.nbt.NBTTagCompound;

public class JSONHoverEvent {
    public EventTypeEnum EventType;
    public String Text;

    public static JSONHoverEvent SimpleText(String pMessage) {
        return new JSONHoverEvent(EventTypeEnum.SHOW_TEXT, pMessage, null);
    }

    public static JSONHoverEvent Item(ItemDescriptor pItem) {
        return new JSONHoverEvent(EventTypeEnum.SHOW_ITEM, "", pItem);
    }

    public static JSONHoverEvent Achievement(String pStatIdentifier) {
        return new JSONHoverEvent(EventTypeEnum.SHOW_ACHIEVEMENT, pStatIdentifier, null);
    }

    private JSONHoverEvent(EventTypeEnum pEventType, String pText, ItemDescriptor pDescriptor) {
        this.EventType = pEventType;
        if (this.EventType == EventTypeEnum.SHOW_ITEM) {
            NBTTagCompound tItem = new NBTTagCompound();
            pDescriptor.getItemStack(1).writeToNBT(tItem);
            this.Text = tItem.toString();
        } else {
            this.Text = pText;
        }
    }

    public JsonObject getJson() {
        JsonObject tJO = new JsonObject();
        tJO.addProperty("action", this.EventType.toString().toLowerCase());
        tJO.addProperty("value", this.Text);
        return tJO;
    }

    public static enum EventTypeEnum {
        SHOW_TEXT,
        SHOW_ITEM,
        SHOW_ACHIEVEMENT,
        SHOW_ENTITY;

    }
}

