/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.client.dynamicgui.helper;

import eu.usrv.yamcore.client.dynamicgui.helper.IQuadDrawer;
import javax.vecmath.Vector2f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TexturedQuadDrawer
implements IQuadDrawer {
    static final float scale = 0.00390625f;
    public final float u0;
    public final float v0;
    public final float u1;
    public final float v1;
    public final float u2;
    public final float v2;
    public final float u3;
    public final float v3;
    final Tessellator tessellator = Tessellator.instance;
    final TextureManager texMan = Minecraft.getMinecraft().getTextureManager();
    public int width;
    public int height;
    float zLevel = 0.0f;
    ResourceLocation texture;
    private boolean hasWarned = false;

    public TexturedQuadDrawer(ResourceLocation texture, float uMin, float uMax, float vMin, float vMax) {
        this.u3 = this.u0 = uMin * 0.00390625f;
        this.v1 = this.v0 = vMax * 0.00390625f;
        this.u1 = this.u2 = uMax * 0.00390625f;
        this.v2 = this.v3 = vMin * 0.00390625f;
        this.texture = texture;
    }

    public TexturedQuadDrawer(ResourceLocation texture, float uMin, float uMax, float vMin, float vMax, int width, int height) {
        this(texture, uMin, uMax, vMin, vMax);
        this.width = width;
        this.height = height;
    }

    public TexturedQuadDrawer(ResourceLocation texture, Vector2f uv0, Vector2f uv1, Vector2f uv2, Vector2f uv3) {
        this.u0 = uv0.x;
        this.v0 = uv0.y;
        this.u1 = uv1.x;
        this.v1 = uv1.y;
        this.u2 = uv2.x;
        this.v2 = uv2.y;
        this.u3 = uv3.x;
        this.v3 = uv3.y;
        this.texture = texture;
    }

    @Override
    public void draw(int x, int y) {
        this.draw(x, y, this.width, this.height);
    }

    @Override
    public void draw(int x, int y, int drawWidth, int drawHeight) {
        if (this.texture == null && !this.hasWarned) {
            this.hasWarned = true;
        }
        this.texMan.bindTexture(this.texture);
        this.tessellator.startDrawingQuads();
        this.tessellator.addVertexWithUV((double)x, (double)(y + drawHeight), (double)this.zLevel, (double)this.u0, (double)this.v0);
        this.tessellator.addVertexWithUV((double)(x + drawWidth), (double)(y + drawHeight), (double)this.zLevel, (double)this.u1, (double)this.v1);
        this.tessellator.addVertexWithUV((double)(x + drawWidth), (double)y, (double)this.zLevel, (double)this.u2, (double)this.v2);
        this.tessellator.addVertexWithUV((double)x, (double)y, (double)this.zLevel, (double)this.u3, (double)this.v3);
        this.tessellator.draw();
    }

    @Override
    public void draw(int x, int y, int drawWidth, int drawHeight, float rotation) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)rotation, (float)0.0f, (float)0.0f, (float)1.0f);
        this.draw(x, y, drawWidth, drawHeight);
        GL11.glPopMatrix();
    }

    @Override
    public float getZLayer() {
        return this.zLevel;
    }

    @Override
    public TexturedQuadDrawer setWH(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public IQuadDrawer setZLayer(float z) {
        this.zLevel = z;
        return this;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

