/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.world;

import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EzCoords {
    private int _mX;
    private int _mY;
    private int _mZ;

    public EzCoords(int pX, int pY, int pZ) {
        this._mX = pX;
        this._mY = pY;
        this._mZ = pZ;
    }

    public EzCoords(EzCoords pToCopy) {
        this._mX = pToCopy.getX();
        this._mY = pToCopy.getY();
        this._mZ = pToCopy.getZ();
    }

    public EzCoords(Vec3 pPosition) {
        this._mX = (int)pPosition.xCoord;
        this._mY = (int)pPosition.yCoord;
        this._mZ = (int)pPosition.zCoord;
    }

    public int getX() {
        return this._mX;
    }

    public int getY() {
        return this._mY;
    }

    public int getZ() {
        return this._mZ;
    }

    public void add(ForgeDirection pDirection, int pAmount) {
        switch (pDirection) {
            case EAST: {
                this._mX += pAmount;
                return;
            }
            case WEST: {
                this._mX -= pAmount;
                return;
            }
            case UP: {
                this._mY += pAmount;
                return;
            }
            case DOWN: {
                this._mY -= pAmount;
                return;
            }
            case NORTH: {
                this._mZ -= pAmount;
                return;
            }
            case SOUTH: {
                this._mZ += pAmount;
                return;
            }
            case UNKNOWN: {
                break;
            }
        }
    }

    public EzCoords add(EzCoords other) {
        this._mX += other.getX();
        this._mY += other.getY();
        this._mZ += other.getZ();
        return this;
    }

    public EzCoords sub(EzCoords other) {
        this._mX -= other.getX();
        this._mY -= other.getY();
        this._mZ -= other.getZ();
        return this;
    }

    public Vec3 getVec3() {
        return Vec3.createVectorHelper((double)this._mX, (double)this._mY, (double)this._mZ);
    }

    public void add(ForgeDirection pDirection) {
        this.add(pDirection, 1);
    }

    public double distance(EzCoords pOther) {
        double side1 = Math.abs(this.getX() - pOther.getX());
        double side2 = Math.abs(this.getZ() - pOther.getZ());
        return Math.sqrt(side1 * side1 + side2 * side2);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this._mX).append(this._mY).append(this._mZ).toHashCode();
    }

    public String toString() {
        return String.format("X: %d Y: %d Z: %d", this._mX, this._mY, this._mZ);
    }

    public boolean equals(Object pOther) {
        if (pOther == null) {
            return false;
        }
        if (pOther instanceof EzCoords) {
            EzCoords other = (EzCoords)pOther;
            if (this._mX != other.getX()) {
                return false;
            }
            if (this._mY != other.getY()) {
                return false;
            }
            return this._mZ == other.getZ();
        }
        return false;
    }
}

