/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.worlddata;

import appeng.api.util.WorldCoord;
import appeng.core.AEConfig;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNewStorageDimension;
import appeng.core.worlddata.IOnWorldStartable;
import appeng.core.worlddata.IOnWorldStoppable;
import appeng.core.worlddata.IWorldDimensionData;
import appeng.hooks.TickHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

final class DimensionData
implements IWorldDimensionData,
IOnWorldStartable,
IOnWorldStoppable {
    private static final String CONFIG_CATEGORY = "DimensionManager";
    private static final String CONFIG_KEY = "StorageCells";
    private static final int[] STORAGE_CELLS_DEFAULT = new int[0];
    private static final String STORAGE_CELL_CATEGORY = "StorageCell";
    private static final String STORAGE_CELL_SCALE_X_KEY = "scaleX";
    private static final String STORAGE_CELL_SCALE_Y_KEY = "scaleY";
    private static final String STORAGE_CELL_SCALE_Z_KEY = "scaleZ";
    private static final String PACKAGE_DEST_CATEGORY = "DimensionManager";
    private static final String PACKAGE_KEY_CATEGORY = "StorageCells";
    private static final int[] PACKAGE_DEF_CATEGORY = new int[0];
    private final Configuration config;
    private final List<Integer> storageCellDimensionIDs;

    DimensionData(@Nonnull Configuration parentFile) {
        Preconditions.checkNotNull((Object)parentFile);
        this.config = parentFile;
        int[] storageCellIDs = this.storageCellIDsProperty().getIntList();
        this.storageCellDimensionIDs = Lists.newArrayList();
        for (int storageCellID : storageCellIDs) {
            this.storageCellDimensionIDs.add(storageCellID);
        }
    }

    private Property storageCellIDsProperty() {
        return this.config.get("DimensionManager", "StorageCells", STORAGE_CELLS_DEFAULT);
    }

    @Override
    public void onWorldStart() {
        for (Integer storageCellDimID : this.storageCellDimensionIDs) {
            DimensionManager.registerDimension((int)storageCellDimID, (int)AEConfig.instance.storageProviderID);
        }
        this.config.save();
    }

    @Override
    public void onWorldStop() {
        this.config.save();
        for (Integer storageCellDimID : this.storageCellDimensionIDs) {
            DimensionManager.unregisterDimension((int)storageCellDimID);
        }
        this.storageCellDimensionIDs.clear();
    }

    @Override
    public void addStorageCell(int newStorageCellID) {
        this.storageCellDimensionIDs.add(newStorageCellID);
        DimensionManager.registerDimension((int)newStorageCellID, (int)AEConfig.instance.storageProviderID);
        NetworkHandler.instance.sendToAll(new PacketNewStorageDimension(newStorageCellID));
        String[] values = new String[this.storageCellDimensionIDs.size()];
        for (int x = 0; x < values.length; ++x) {
            values[x] = String.valueOf(this.storageCellDimensionIDs.get(x));
        }
        this.storageCellIDsProperty().set(values);
        this.config.save();
    }

    @Override
    public WorldCoord getStoredSize(int dim) {
        String category = STORAGE_CELL_CATEGORY + dim;
        int x = this.config.get(category, STORAGE_CELL_SCALE_X_KEY, 0).getInt();
        int y = this.config.get(category, STORAGE_CELL_SCALE_Y_KEY, 0).getInt();
        int z = this.config.get(category, STORAGE_CELL_SCALE_Z_KEY, 0).getInt();
        return new WorldCoord(x, y, z);
    }

    @Override
    public void setStoredSize(int dim, int targetX, int targetY, int targetZ) {
        String category = STORAGE_CELL_CATEGORY + dim;
        this.config.get(category, STORAGE_CELL_SCALE_X_KEY, 0).set(targetX);
        this.config.get(category, STORAGE_CELL_SCALE_Y_KEY, 0).set(targetY);
        this.config.get(category, STORAGE_CELL_SCALE_Z_KEY, 0).set(targetZ);
        this.config.save();
    }

    @Override
    public void sendToPlayer(@Nullable NetworkManager manager) {
        if (manager != null) {
            for (int newDim : this.config.get("DimensionManager", "StorageCells", PACKAGE_DEF_CATEGORY).getIntList()) {
                manager.scheduleOutboundPacket((Packet)new PacketNewStorageDimension(newDim).getProxy(), new GenericFutureListener[0]);
            }
        } else {
            for (TickHandler.PlayerColor pc : TickHandler.INSTANCE.getPlayerColors().values()) {
                NetworkHandler.instance.sendToAll(pc.getPacket());
            }
        }
    }
}

