/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IPartMonitor;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartCollisionHelper;
import appeng.client.texture.CableBusTextures;
import appeng.me.GridAccessException;
import appeng.parts.AEBasePart;
import appeng.util.Platform;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AbstractPartReporting
extends AEBasePart
implements IPartMonitor,
IPowerChannelState {
    protected static final int POWERED_FLAG = 4;
    protected static final int CHANNEL_FLAG = 16;
    private static final int BOOTING_FLAG = 8;
    private byte spin = 0;
    private int clientFlags = 0;
    private float opacity = -1.0f;

    public AbstractPartReporting(ItemStack is) {
        this(is, false);
    }

    protected AbstractPartReporting(ItemStack is, boolean requireChannel) {
        super(is);
        if (requireChannel) {
            this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
            this.getProxy().setIdlePowerUsage(0.5);
        } else {
            this.getProxy().setIdlePowerUsage(0.0625);
        }
    }

    @MENetworkEventSubscribe
    public final void bootingRender(MENetworkBootingStatusChange c) {
        if (!this.isLightSource()) {
            this.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public final void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    @Override
    public final void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public void onNeighborChanged() {
        this.opacity = -1.0f;
        this.getHost().markForUpdate();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.hasKey("opacity")) {
            this.opacity = data.getFloat("opacity");
        }
        this.spin = data.getByte("spin");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setFloat("opacity", this.opacity);
        data.setByte("spin", this.getSpin());
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        this.clientFlags = this.getSpin() & 3;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.clientFlags = this.getClientFlags() | 4;
            }
            if (this.getProxy().getPath().isNetworkBooting()) {
                this.clientFlags = this.getClientFlags() | 8;
            }
            if (this.getProxy().getNode().meetsChannelRequirements()) {
                this.clientFlags = this.getClientFlags() | 0x10;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        data.writeByte((int)((byte)this.getClientFlags()));
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        int oldFlags = this.getClientFlags();
        this.clientFlags = data.readByte();
        this.spin = (byte)(this.getClientFlags() & 3);
        return this.getClientFlags() != oldFlags;
    }

    @Override
    public final int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.isLightSource() ? 15 : 9) : 0);
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        TileEntity te = this.getTile();
        if (!player.isSneaking() && Platform.isWrench(player, player.inventory.getCurrentItem(), te.xCoord, te.yCoord, te.zCoord)) {
            if (Platform.isServer()) {
                if (this.getSpin() > 3) {
                    this.spin = 0;
                }
                switch (this.getSpin()) {
                    case 0: {
                        this.spin = 1;
                        break;
                    }
                    case 1: {
                        this.spin = (byte)3;
                        break;
                    }
                    case 2: {
                        this.spin = 0;
                        break;
                    }
                    case 3: {
                        this.spin = (byte)2;
                    }
                }
                this.getHost().markForUpdate();
                this.saveChanges();
            }
            return true;
        }
        return super.onPartActivate(player, pos);
    }

    @Override
    public final void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        super.onPlacement(player, held, side);
        byte rotation = (byte)(MathHelper.floor_double((double)((double)(player.rotationYaw * 4.0f / 360.0f) + 2.5)) & 3);
        if (side == ForgeDirection.UP) {
            this.spin = rotation;
        } else if (side == ForgeDirection.DOWN) {
            this.spin = rotation;
        }
    }

    private final int blockLight(int emit) {
        if (this.opacity < 0.0f) {
            TileEntity te = this.getTile();
            this.opacity = 255 - te.getWorldObj().getBlockLightOpacity(te.xCoord + this.getSide().offsetX, te.yCoord + this.getSide().offsetY, te.zCoord + this.getSide().offsetZ);
        }
        return (int)((float)emit * (this.opacity / 255.0f));
    }

    @Override
    public final boolean isPowered() {
        try {
            if (Platform.isServer()) {
                return this.getProxy().getEnergy().isNetworkPowered();
            }
            return (this.getClientFlags() & 4) == 4;
        }
        catch (GridAccessException e) {
            return false;
        }
    }

    @Override
    public final boolean isActive() {
        if (!this.isLightSource()) {
            return (this.getClientFlags() & 0x14) == 20;
        }
        return this.isPowered();
    }

    public final int getClientFlags() {
        return this.clientFlags;
    }

    public final byte getSpin() {
        return this.spin;
    }

    public abstract CableBusTextures getFrontBright();

    public abstract CableBusTextures getFrontColored();

    public abstract CableBusTextures getFrontDark();

    public abstract boolean isLightSource();
}

