/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.handlers;

import appeng.api.exceptions.MissingIngredientError;
import appeng.api.exceptions.RecipeError;
import appeng.api.exceptions.RegistrationError;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.core.AELog;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IMekanism;
import appeng.recipes.RecipeHandler;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.item.ItemStack;

public class MekEnrichment
implements ICraftHandler,
IWebsiteSerializer {
    private IIngredient pro_input;
    private IIngredient[] pro_output;

    @Override
    public void setup(List<List<IIngredient>> input, List<List<IIngredient>> output) throws RecipeError {
        if (input.size() == 1 && output.size() == 1) {
            int outs = output.get(0).size();
            if (input.get(0).size() == 1 && outs == 1) {
                this.pro_input = input.get(0).get(0);
                this.pro_output = output.get(0).toArray(new IIngredient[outs]);
                return;
            }
        }
        throw new RecipeError("MekCrusher must have a single input, and single output.");
    }

    @Override
    public void register() throws RegistrationError, MissingIngredientError {
        if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.Mekanism)) {
            IMekanism rc = (IMekanism)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.Mekanism);
            for (ItemStack is : this.pro_input.getItemStackSet()) {
                try {
                    rc.addEnrichmentChamberRecipe(is, this.pro_output[0].getItemStack());
                }
                catch (RuntimeException err) {
                    AELog.info("Mekanism not happy - " + err.getMessage(), new Object[0]);
                }
            }
        }
    }

    @Override
    public String getPattern(RecipeHandler h) {
        return null;
    }

    @Override
    public boolean canCraft(ItemStack output) throws RegistrationError, MissingIngredientError {
        return Platform.isSameItemPrecise(this.pro_output[0].getItemStack(), output);
    }
}

