/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.block.AEBaseTileBlock;
import appeng.client.render.blocks.RenderBlockAssembler;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.tile.crafting.TileMolecularAssembler;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMolecularAssembler
extends AEBaseTileBlock {
    private static boolean booleanAlphaPass = false;

    public BlockMolecularAssembler() {
        super(Material.iron);
        this.setTileEntity(TileMolecularAssembler.class);
        this.isOpaque = false;
        this.lightOpacity = 1;
        this.setFeature(EnumSet.of(AEFeature.MolecularAssembler));
    }

    public int getRenderBlockPass() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        BlockMolecularAssembler.setBooleanAlphaPass(pass == 1);
        return pass == 0 || pass == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderBlockAssembler getRenderer() {
        return new RenderBlockAssembler();
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side, float hitX, float hitY, float hitZ) {
        TileMolecularAssembler tg = (TileMolecularAssembler)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tg != null && !p.isSneaking()) {
            Platform.openGUI(p, tg, ForgeDirection.getOrientation((int)side), GuiBridge.GUI_MAC);
            return true;
        }
        return super.onBlockActivated(w, x, y, z, p, side, hitX, hitY, hitZ);
    }

    public static boolean isBooleanAlphaPass() {
        return booleanAlphaPass;
    }

    private static void setBooleanAlphaPass(boolean booleanAlphaPass) {
        BlockMolecularAssembler.booleanAlphaPass = booleanAlphaPass;
    }
}

