/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.items;

import appeng.api.implementations.items.IBiometricCard;
import appeng.api.util.AEColor;
import appeng.client.texture.ExtraItemTextures;
import com.mojang.authlib.GameProfile;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ToolBiometricCardRender
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GameProfile gp;
        IIcon par2Icon = item.getIconIndex();
        float f4 = par2Icon.getMinU();
        float f5 = par2Icon.getMaxU();
        float f6 = par2Icon.getMinV();
        float f7 = par2Icon.getMaxV();
        Tessellator tessellator = Tessellator.instance;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)24576);
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)16.0f, (float)16.0f, (float)10.0f);
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glEnable((int)3008);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, (double)f4, (double)f7);
            tessellator.addVertexWithUV(1.0, 0.0, 0.0, (double)f5, (double)f7);
            tessellator.addVertexWithUV(1.0, 1.0, 0.0, (double)f5, (double)f6);
            tessellator.addVertexWithUV(0.0, 1.0, 0.0, (double)f4, (double)f6);
            tessellator.draw();
        } else {
            GL11.glTranslatef((float)-0.5f, (float)-0.3f, (float)0.01f);
            float f12 = 0.0625f;
            ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)f5, (float)f6, (float)f4, (float)f7, (int)par2Icon.getIconWidth(), (int)par2Icon.getIconHeight(), (float)0.0625f);
            GL11.glDisable((int)2884);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.1f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)1.07f, (float)-0.03125f);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float u = ExtraItemTextures.White.getIcon().getInterpolatedU(8.1);
        float v = ExtraItemTextures.White.getIcon().getInterpolatedV(8.1);
        String username = "";
        if (item.getItem() instanceof IBiometricCard && (gp = ((IBiometricCard)item.getItem()).getProfile(item)) != null) {
            username = gp.getName();
        }
        int hash = username.length() > 0 ? username.hashCode() : 0;
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)1.0f);
        GL11.glTranslatef((float)4.0f, (float)6.0f, (float)0.0f);
        GL11.glDisable((int)2896);
        tessellator.startDrawingQuads();
        AEColor col = AEColor.values()[Math.abs(3 + hash) % AEColor.values().length];
        if (hash == 0) {
            col = AEColor.Black;
        }
        float z = 0.0f;
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 6; ++y) {
                boolean isLit = false;
                if (x == 0 || y == 0 || x == 7 || y == 5) {
                    isLit = false;
                } else {
                    boolean bl = isLit = (hash & 1 << x) != 0 || (hash & 1 << y) != 0;
                }
                if (isLit) {
                    tessellator.setColorOpaque_I(col.mediumVariant);
                } else {
                    float scale = 0.0011764707f;
                    tessellator.setColorOpaque_F((float)(col.blackVariant >> 16 & 0xFF) * 0.0011764707f, (float)(col.blackVariant >> 8 & 0xFF) * 0.0011764707f, (float)(col.blackVariant & 0xFF) * 0.0011764707f);
                }
                tessellator.addVertexWithUV((double)x, (double)y, 0.0, (double)u, (double)v);
                tessellator.addVertexWithUV((double)(x + 1), (double)y, 0.0, (double)u, (double)v);
                tessellator.addVertexWithUV((double)(x + 1), (double)(y + 1), 0.0, (double)u, (double)v);
                tessellator.addVertexWithUV((double)x, (double)(y + 1), 0.0, (double)u, (double)v);
            }
        }
        tessellator.draw();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

