/*
 * Decompiled with CFR 0.152.
 */
package appeng.fmp;

import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.facade.FacadeContainer;
import appeng.fmp.CableBusPart;
import appeng.fmp.PartRegistry;
import appeng.parts.CableBusStorage;
import appeng.util.Platform;
import codechicken.lib.vec.BlockCoord;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class FMPPlacementHelper
implements IPartHost {
    private static final CableBusStorage NULL_STORAGE = new NullStorage();
    private boolean hasPart = false;
    private TileMultipart myMP;
    private CableBusPart myPart;

    public FMPPlacementHelper(TileMultipart mp) {
        this.myMP = mp;
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        if (this.myPart == null) {
            return new FacadeContainer(NULL_STORAGE);
        }
        return this.myPart.getFacadeContainer();
    }

    @Override
    public boolean canAddPart(ItemStack part, ForgeDirection side) {
        CableBusPart myPart = this.getPart();
        boolean returnValue = this.hasPart && myPart.canAddPart(part, side);
        this.removePart();
        return returnValue;
    }

    private CableBusPart getPart() {
        for (TMultiPart p : this.myMP.partList()) {
            if (!(p instanceof CableBusPart)) continue;
            this.myPart = (CableBusPart)p;
        }
        if (this.myPart == null) {
            this.myPart = (CableBusPart)PartRegistry.CableBusPart.construct(0);
        }
        BlockCoord loc = new BlockCoord(this.myMP.xCoord, this.myMP.yCoord, this.myMP.zCoord);
        if (this.myMP.canAddPart((TMultiPart)this.myPart) && Platform.isServer()) {
            this.myMP = TileMultipart.addPart((World)this.myMP.getWorldObj(), (BlockCoord)loc, (TMultiPart)this.myPart);
            this.hasPart = true;
        }
        return this.myPart;
    }

    private void removePart() {
        if (this.myPart.isEmpty()) {
            for (TMultiPart p : this.myMP.partList()) {
                if (p != this.myPart) continue;
                this.myMP = this.myMP.remPart((TMultiPart)this.myPart);
                break;
            }
            this.hasPart = false;
            this.myPart = null;
        }
    }

    @Override
    public ForgeDirection addPart(ItemStack is, ForgeDirection side, EntityPlayer owner) {
        CableBusPart myPart = this.getPart();
        ForgeDirection returnValue = this.hasPart ? myPart.addPart(is, side, owner) : null;
        this.removePart();
        return returnValue;
    }

    @Override
    public IPart getPart(ForgeDirection side) {
        if (this.myPart == null) {
            return null;
        }
        return this.myPart.getPart(side);
    }

    @Override
    public void removePart(ForgeDirection side, boolean suppressUpdate) {
        if (this.myPart == null) {
            return;
        }
        this.myPart.removePart(side, suppressUpdate);
    }

    @Override
    public void markForUpdate() {
        if (this.myPart == null) {
            return;
        }
        this.myPart.markForUpdate();
    }

    @Override
    public DimensionalCoord getLocation() {
        if (this.myPart == null) {
            return new DimensionalCoord((TileEntity)this.myMP);
        }
        return this.myPart.getLocation();
    }

    @Override
    public TileEntity getTile() {
        return this.myMP;
    }

    @Override
    public AEColor getColor() {
        if (this.myPart == null) {
            return AEColor.Transparent;
        }
        return this.myPart.getColor();
    }

    @Override
    public void clearContainer() {
        if (this.myPart == null) {
            return;
        }
        this.myPart.clearContainer();
    }

    @Override
    public boolean isBlocked(ForgeDirection side) {
        this.getPart();
        boolean returnValue = this.myPart.isBlocked(side);
        this.removePart();
        return returnValue;
    }

    @Override
    public SelectedPart selectPart(Vec3 pos) {
        if (this.myPart == null) {
            return new SelectedPart();
        }
        return this.myPart.selectPart(pos);
    }

    @Override
    public void markForSave() {
        if (this.myPart == null) {
            return;
        }
        this.myPart.markForSave();
    }

    @Override
    public void partChanged() {
        if (this.myPart == null) {
            return;
        }
        this.myPart.partChanged();
    }

    @Override
    public boolean hasRedstone(ForgeDirection side) {
        if (this.myPart == null) {
            return false;
        }
        return this.myPart.hasRedstone(side);
    }

    @Override
    public boolean isEmpty() {
        if (this.myPart == null) {
            return true;
        }
        return this.myPart.isEmpty();
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        if (this.myPart == null) {
            return EnumSet.noneOf(LayerFlags.class);
        }
        return this.myPart.getLayerFlags();
    }

    @Override
    public void cleanup() {
        if (this.myPart == null) {
            return;
        }
        this.myPart.cleanup();
    }

    @Override
    public void notifyNeighbors() {
        if (this.myPart == null) {
            return;
        }
        this.myPart.notifyNeighbors();
    }

    @Override
    public boolean isInWorld() {
        if (this.myPart == null) {
            return this.myMP.getWorldObj() != null;
        }
        return this.myPart.isInWorld();
    }

    private static class NullStorage
    extends CableBusStorage {
        private NullStorage() {
        }

        @Override
        public IFacadePart getFacade(int x) {
            return null;
        }

        @Override
        public void setFacade(int x, IFacadePart facade) {
        }
    }
}

