/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItems;
import appeng.api.exceptions.RecipeError;
import appeng.api.features.IRecipeHandlerRegistry;
import appeng.api.recipes.ICraftHandler;
import appeng.api.recipes.IIngredient;
import appeng.api.recipes.IRecipeHandler;
import appeng.api.recipes.IRecipeLoader;
import appeng.core.AELog;
import appeng.items.materials.ItemMultiMaterial;
import appeng.items.parts.ItemMultiPart;
import appeng.recipes.GroupIngredient;
import appeng.recipes.Ingredient;
import appeng.recipes.IngredientSet;
import appeng.recipes.MissedIngredientSet;
import appeng.recipes.RecipeData;
import appeng.recipes.handlers.IWebsiteSerializer;
import appeng.recipes.handlers.OreRegistration;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeHandler
implements IRecipeHandler {
    private final RecipeData data;
    private final List<String> tokens = new LinkedList<String>();

    public RecipeHandler() {
        this.data = new RecipeData();
    }

    private RecipeHandler(RecipeHandler parent) {
        Preconditions.checkNotNull((Object)parent);
        this.data = parent.data;
    }

    private void addCrafting(ICraftHandler ch) {
        this.data.handlers.add(ch);
    }

    public String getName(@Nonnull IIngredient i) {
        try {
            ItemStack[] itemStackArray = i.getItemStackSet();
            int n = itemStackArray.length;
            int n2 = 0;
            if (n2 < n) {
                ItemStack is = itemStackArray[n2];
                return this.getName(is);
            }
        }
        catch (RecipeError recipeError) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return i.getNameSpace() + ':' + i.getItemName();
    }

    private String getName(ItemStack is) throws RecipeError {
        Preconditions.checkNotNull((Object)is);
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)is.getItem());
        String realName = id.modId + ':' + id.name;
        if (!id.modId.equals("appliedenergistics2") && !id.modId.equals("minecraft")) {
            throw new RecipeError("Not applicable for website");
        }
        IDefinitions definitions = AEApi.instance().definitions();
        IItems items = definitions.items();
        IBlocks blocks = definitions.blocks();
        Optional<Item> maybeCrystalSeedItem = items.crystalSeed().maybeItem();
        Optional<Item> maybeSkyStoneItem = blocks.skyStone().maybeItem();
        Optional<Item> maybeCStorageItem = blocks.craftingStorage1k().maybeItem();
        Optional<Item> maybeCUnitItem = blocks.craftingUnit().maybeItem();
        Optional<Item> maybeSkyChestItem = blocks.skyChest().maybeItem();
        if (maybeCrystalSeedItem.isPresent() && is.getItem() == maybeCrystalSeedItem.get()) {
            int dmg = is.getItemDamage();
            if (dmg < 600) {
                realName = realName + ".Certus";
            } else if (dmg < 1200) {
                realName = realName + ".Nether";
            } else if (dmg < 1800) {
                realName = realName + ".Fluix";
            }
        } else if (maybeSkyStoneItem.isPresent() && is.getItem() == maybeSkyStoneItem.get()) {
            switch (is.getItemDamage()) {
                case 1: {
                    realName = realName + ".Block";
                    break;
                }
                case 2: {
                    realName = realName + ".Brick";
                    break;
                }
                case 3: {
                    realName = realName + ".SmallBrick";
                    break;
                }
            }
        } else if (maybeCStorageItem.isPresent() && is.getItem() == maybeCStorageItem.get()) {
            switch (is.getItemDamage()) {
                case 1: {
                    realName = realName + "4k";
                    break;
                }
                case 2: {
                    realName = realName + "16k";
                    break;
                }
                case 3: {
                    realName = realName + "64k";
                    break;
                }
            }
        } else if (maybeCUnitItem.isPresent() && is.getItem() == maybeCUnitItem.get()) {
            switch (is.getItemDamage()) {
                case 1: {
                    realName = realName.replace("Unit", "Accelerator");
                    break;
                }
            }
        } else if (maybeSkyChestItem.isPresent() && is.getItem() == maybeSkyChestItem.get()) {
            switch (is.getItemDamage()) {
                case 1: {
                    realName = realName + ".Block";
                    break;
                }
            }
        } else if (is.getItem() instanceof ItemMultiMaterial) {
            realName = realName.replace("ItemMultiMaterial", "ItemMaterial");
            realName = realName + '.' + ((ItemMultiMaterial)is.getItem()).getTypeByStack(is).name();
        } else if (is.getItem() instanceof ItemMultiPart) {
            realName = realName.replace("ItemMultiPart", "ItemPart");
            realName = realName + '.' + ((ItemMultiPart)is.getItem()).getTypeByStack(is).name();
        } else if (is.getItemDamage() > 0) {
            realName = realName + "." + is.getItemDamage();
        }
        return realName;
    }

    String alias(String in) {
        Preconditions.checkNotNull((Object)in);
        String out = this.data.aliases.get(in);
        if (out != null) {
            return out;
        }
        return in;
    }

    @Override
    public void parseRecipes(IRecipeLoader loader, String path) {
        block23: {
            Preconditions.checkNotNull((Object)loader);
            Preconditions.checkNotNull((Object)path);
            try {
                BufferedReader reader = null;
                try {
                    reader = loader.getFile(path);
                }
                catch (Exception err) {
                    AELog.warn("Error Loading Recipe File:" + path, new Object[0]);
                    if (this.data.exceptions) {
                        AELog.debug(err);
                    }
                    return;
                }
                boolean inQuote = false;
                boolean inComment = false;
                String token = "";
                int line = 0;
                int val = -1;
                block14: while ((val = reader.read()) != -1) {
                    char c = (char)val;
                    if (c == '\n') {
                        ++line;
                    }
                    if (inComment) {
                        if (c != '\n' && c != '\r') continue;
                        inComment = false;
                        continue;
                    }
                    if (inQuote) {
                        switch (c) {
                            case '\"': {
                                inQuote = !inQuote;
                                continue block14;
                            }
                        }
                        token = token + c;
                        continue;
                    }
                    switch (c) {
                        case '\"': {
                            inQuote = !inQuote;
                            continue block14;
                        }
                        case ',': {
                            if (token.length() > 0) {
                                this.tokens.add(token);
                                this.tokens.add(",");
                            }
                            token = "";
                            continue block14;
                        }
                        case '=': {
                            this.processTokens(loader, path, line);
                            if (token.length() > 0) {
                                this.tokens.add(token);
                            }
                            token = "";
                            continue block14;
                        }
                        case '#': {
                            inComment = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (token.length() > 0) {
                                this.tokens.add(token);
                            }
                            token = "";
                            continue block14;
                        }
                    }
                    token = token + c;
                }
                if (token.length() > 0) {
                    this.tokens.add(token);
                }
                reader.close();
                this.processTokens(loader, path, line);
            }
            catch (Throwable e) {
                AELog.debug(e);
                if (!this.data.crash) break block23;
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void injectRecipes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<IWebsiteSerializer> findRecipe(ItemStack output) {
        LinkedList<IWebsiteSerializer> out = new LinkedList<IWebsiteSerializer>();
        for (ICraftHandler ch : this.data.handlers) {
            try {
                if (!(ch instanceof IWebsiteSerializer) || !((IWebsiteSerializer)((Object)ch)).canCraft(output)) continue;
                out.add((IWebsiteSerializer)((Object)ch));
            }
            catch (Throwable t) {
                AELog.debug(t);
            }
        }
        return out;
    }

    RecipeData getData() {
        return this.data;
    }

    private void processTokens(IRecipeLoader loader, String file, int line) throws RecipeError {
        block20: {
            try {
                IRecipeHandlerRegistry cr = AEApi.instance().registries().recipes();
                if (this.tokens.isEmpty()) {
                    return;
                }
                int split = this.tokens.indexOf("->");
                if (split != -1) {
                    String operation = this.tokens.remove(0).toLowerCase(Locale.ENGLISH);
                    if (operation.equals("alias")) {
                        if (this.tokens.size() == 3 && this.tokens.indexOf("->") == 1) {
                            this.data.aliases.put(this.tokens.get(0), this.tokens.get(2));
                            break block20;
                        }
                        throw new RecipeError("Alias must have exactly 1 input and 1 output.");
                    }
                    if (operation.equals("group")) {
                        List<String> pre = this.tokens.subList(0, split - 1);
                        List<String> post = this.tokens.subList(split, this.tokens.size());
                        List<List<IIngredient>> inputs = this.parseLines(pre);
                        if (inputs.size() == 1 && inputs.get(0).size() > 0 && post.size() == 1) {
                            this.data.groups.put(post.get(0), new GroupIngredient(post.get(0), inputs.get(0), 1));
                            break block20;
                        }
                        throw new RecipeError("Group must have exactly 1 output, and 1 or more inputs.");
                    }
                    if (operation.equals("ore")) {
                        List<String> pre = this.tokens.subList(0, split - 1);
                        List<String> post = this.tokens.subList(split, this.tokens.size());
                        List<List<IIngredient>> inputs = this.parseLines(pre);
                        if (inputs.size() == 1 && inputs.get(0).size() > 0 && post.size() == 1) {
                            OreRegistration ch = new OreRegistration(inputs.get(0), post.get(0));
                            this.addCrafting(ch);
                            break block20;
                        }
                        throw new RecipeError("Group must have exactly 1 output, and 1 or more inputs in a single row.");
                    }
                    List<String> pre = this.tokens.subList(0, split - 1);
                    List<String> post = this.tokens.subList(split, this.tokens.size());
                    List<List<IIngredient>> inputs = this.parseLines(pre);
                    List<List<IIngredient>> outputs = this.parseLines(post);
                    ICraftHandler ch = cr.getCraftHandlerFor(operation);
                    if (ch != null) {
                        ch.setup(inputs, outputs);
                        this.addCrafting(ch);
                        break block20;
                    }
                    throw new RecipeError("Invalid crafting type: " + operation);
                }
                String operation = this.tokens.remove(0).toLowerCase();
                if (operation.equals("exceptions") && (this.tokens.get(0).equals("true") || this.tokens.get(0).equals("false"))) {
                    if (this.tokens.size() == 1) {
                        this.data.exceptions = this.tokens.get(0).equals("true");
                        break block20;
                    }
                    throw new RecipeError("exceptions must be true or false explicitly.");
                }
                if (operation.equals("crash") && (this.tokens.get(0).equals("true") || this.tokens.get(0).equals("false"))) {
                    if (this.tokens.size() == 1) {
                        this.data.crash = this.tokens.get(0).equals("true");
                        break block20;
                    }
                    throw new RecipeError("crash must be true or false explicitly.");
                }
                if (operation.equals("erroronmissing")) {
                    if (this.tokens.size() == 1 && (this.tokens.get(0).equals("true") || this.tokens.get(0).equals("false"))) {
                        this.data.errorOnMissing = this.tokens.get(0).equals("true");
                        break block20;
                    }
                    throw new RecipeError("erroronmissing must be true or false explicitly.");
                }
                if (operation.equals("import")) {
                    if (this.tokens.size() == 1) {
                        new RecipeHandler(this).parseRecipes(loader, this.tokens.get(0));
                        break block20;
                    }
                    throw new RecipeError("Import must have exactly 1 input.");
                }
                throw new RecipeError(operation + ": " + this.tokens.toString() + "; recipe without an output.");
            }
            catch (RecipeError e) {
                AELog.warn("Recipe Error '" + e.getMessage() + "' near line:" + line + " in " + file + " with: " + this.tokens.toString(), new Object[0]);
                if (this.data.exceptions) {
                    AELog.debug(e);
                }
                if (!this.data.crash) break block20;
                throw e;
            }
        }
        this.tokens.clear();
    }

    private List<List<IIngredient>> parseLines(Iterable<String> subList) throws RecipeError {
        LinkedList<List<IIngredient>> out = new LinkedList<List<IIngredient>>();
        LinkedList<IIngredient> cList = new LinkedList<IIngredient>();
        boolean hasQty = false;
        int qty = 1;
        for (String v : subList) {
            if (v.equals(",")) {
                if (hasQty) {
                    throw new RecipeError("Qty found with no item.");
                }
                if (!cList.isEmpty()) {
                    out.add(cList);
                }
                cList = new LinkedList();
                continue;
            }
            if (this.isNumber(v)) {
                if (hasQty) {
                    throw new RecipeError("Qty found with no item.");
                }
                hasQty = true;
                qty = Integer.parseInt(v);
                continue;
            }
            if (hasQty) {
                cList.add(this.findIngredient(v, qty));
                hasQty = false;
                continue;
            }
            cList.add(this.findIngredient(v, 1));
        }
        if (!cList.isEmpty()) {
            out.add(cList);
        }
        return out;
    }

    private IIngredient findIngredient(String v, int qty) throws RecipeError {
        GroupIngredient gi = this.data.groups.get(v);
        if (gi != null) {
            return gi.copy(qty);
        }
        try {
            return new Ingredient(this, v, qty);
        }
        catch (MissedIngredientSet grp) {
            return new IngredientSet(grp.getResolverResultSet(), qty);
        }
    }

    private boolean isNumber(CharSequence v) {
        if (v.length() <= 0) {
            return false;
        }
        int l = v.length();
        for (int x = 0; x < l; ++x) {
            if (Character.isDigit(v.charAt(x))) continue;
            return false;
        }
        return true;
    }
}

