/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.api.config.CopyMode;
import appeng.api.config.FuzzyMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.implementations.items.IUpgradeModule;
import appeng.client.gui.implementations.GuiUpgradeable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiToggleButton;
import appeng.container.implementations.ContainerCellWorkbench;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.tile.misc.TileCellWorkbench;
import appeng.util.Platform;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;

public class GuiCellWorkbench
extends GuiUpgradeable {
    private final ContainerCellWorkbench workbench;
    private GuiImgButton clear;
    private GuiImgButton partition;
    private GuiToggleButton copyMode;

    public GuiCellWorkbench(InventoryPlayer inventoryPlayer, TileCellWorkbench te) {
        super(new ContainerCellWorkbench(inventoryPlayer, te));
        this.workbench = (ContainerCellWorkbench)this.field_147002_h;
        this.field_147000_g = 251;
    }

    @Override
    protected void addButtons() {
        this.clear = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, Settings.ACTIONS, ActionItems.CLOSE);
        this.partition = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, Settings.ACTIONS, ActionItems.WRENCH);
        this.copyMode = new GuiToggleButton(this.field_147003_i - 18, this.field_147009_r + 48, 181, 197, GuiText.CopyMode.getLocal(), GuiText.CopyModeDesc.getLocal());
        this.fuzzyMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 68, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.field_146292_n.add(this.fuzzyMode);
        this.field_146292_n.add(this.partition);
        this.field_146292_n.add(this.clear);
        this.field_146292_n.add(this.copyMode);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.handleButtonVisibility();
        this.bindTexture(this.getBackground());
        this.func_73729_b(offsetX, offsetY, 0, 0, 177, this.field_147000_g);
        if (this.drawUpgrades()) {
            if (this.workbench.availableUpgrades() <= 8) {
                this.func_73729_b(offsetX + 177, offsetY, 177, 0, 35, 7 + this.workbench.availableUpgrades() * 18);
                this.func_73729_b(offsetX + 177, offsetY + (7 + this.workbench.availableUpgrades() * 18), 177, 151, 35, 7);
            } else if (this.workbench.availableUpgrades() <= 16) {
                this.func_73729_b(offsetX + 177, offsetY, 177, 0, 35, 151);
                this.func_73729_b(offsetX + 177, offsetY + 151, 177, 151, 35, 7);
                int dx = this.workbench.availableUpgrades() - 8;
                this.func_73729_b(offsetX + 177 + 27, offsetY, 186, 0, 27, 7 + dx * 18);
                if (dx == 8) {
                    this.func_73729_b(offsetX + 177 + 27, offsetY + (7 + dx * 18), 186, 151, 27, 7);
                } else {
                    this.func_73729_b(offsetX + 177 + 27 + 4, offsetY + (7 + dx * 18), 190, 151, 27, 7);
                }
            } else {
                this.func_73729_b(offsetX + 177, offsetY, 177, 0, 35, 151);
                this.func_73729_b(offsetX + 177, offsetY + 151, 177, 151, 35, 7);
                this.func_73729_b(offsetX + 177 + 27, offsetY, 186, 0, 27, 151);
                this.func_73729_b(offsetX + 177 + 27, offsetY + 151, 186, 151, 27, 7);
                int dx = this.workbench.availableUpgrades() - 16;
                this.func_73729_b(offsetX + 177 + 27 + 18, offsetY, 186, 0, 27, 7 + dx * 18);
                if (dx == 8) {
                    this.func_73729_b(offsetX + 177 + 27 + 18, offsetY + (7 + dx * 18), 186, 151, 27, 7);
                } else {
                    this.func_73729_b(offsetX + 177 + 27 + 18 + 4, offsetY + (7 + dx * 18), 190, 151, 27, 7);
                }
            }
        }
        if (this.hasToolbox()) {
            this.func_73729_b(offsetX + 178, offsetY + this.field_147000_g - 90, 178, 161, 68, 68);
        }
    }

    @Override
    protected void handleButtonVisibility() {
        this.copyMode.setState(this.workbench.getCopyMode() == CopyMode.CLEAR_ON_REMOVE);
        boolean hasFuzzy = false;
        IInventory inv = this.workbench.getCellUpgradeInventory();
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (is == null || !(is.func_77973_b() instanceof IUpgradeModule) || ((IUpgradeModule)is.func_77973_b()).getType(is) != Upgrades.FUZZY) continue;
            hasFuzzy = true;
        }
        this.fuzzyMode.setVisibility(hasFuzzy);
    }

    @Override
    protected String getBackground() {
        return "guis/cellworkbench.png";
    }

    @Override
    protected boolean drawUpgrades() {
        return this.workbench.availableUpgrades() > 0;
    }

    @Override
    protected GuiText getName() {
        return GuiText.CellWorkbench;
    }

    @Override
    protected void func_146284_a(GuiButton btn) {
        try {
            if (btn == this.copyMode) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("CellWorkbench.Action", "CopyMode"));
            } else if (btn == this.partition) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("CellWorkbench.Action", "Partition"));
            } else if (btn == this.clear) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("CellWorkbench.Action", "Clear"));
            } else if (btn == this.fuzzyMode) {
                boolean backwards = Mouse.isButtonDown((int)1);
                FuzzyMode fz = (FuzzyMode)this.fuzzyMode.getCurrentValue();
                fz = Platform.rotateEnum(fz, backwards, Settings.FUZZY_MODE.getPossibleValues());
                NetworkHandler.instance.sendToServer(new PacketValueConfig("CellWorkbench.Fuzzy", fz.name()));
            } else {
                super.func_146284_a(btn);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

