/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered.powersink;

import appeng.api.config.AccessRestriction;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import com.google.common.base.Optional;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AERootPoweredItem
extends AEBaseItem
implements IAEItemPowerStorage {
    private static final String POWER_NBT_KEY = "internalCurrentPower";
    private final double powerCapacity;

    public AERootPoweredItem(double powerCapacity, Optional<String> subName) {
        super(subName);
        this.setMaxDamage(32);
        this.hasSubtypes = false;
        this.setFull3D();
        this.powerCapacity = powerCapacity;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        NBTTagCompound tag = stack.getTagCompound();
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getAEMaxPower(stack);
        if (tag != null) {
            internalCurrentPower = tag.getDouble(POWER_NBT_KEY);
        }
        double percent = internalCurrentPower / internalMaxPower;
        lines.add(GuiText.StoredEnergy.getLocal() + ':' + MessageFormat.format(" {0,number,#} ", internalCurrentPower) + Platform.gui_localize(PowerUnits.AE.unlocalizedName) + " - " + MessageFormat.format(" {0,number,#.##%} ", percent));
    }

    public boolean isDamageable() {
        return true;
    }

    @Override
    protected void getCheckedSubItems(Item sameItem, CreativeTabs creativeTab, List<ItemStack> itemStacks) {
        super.getCheckedSubItems(sameItem, creativeTab, itemStacks);
        ItemStack charged = new ItemStack((Item)this, 1);
        NBTTagCompound tag = Platform.openNbtData(charged);
        tag.setDouble(POWER_NBT_KEY, this.getAEMaxPower(charged));
        tag.setDouble("internalMaxPower", this.getAEMaxPower(charged));
        itemStacks.add(charged);
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack is) {
        return 1.0 - this.getAECurrentPower(is) / this.getAEMaxPower(is);
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    private double getInternalBattery(ItemStack is, batteryOperation op, double adjustment) {
        NBTTagCompound data = Platform.openNbtData(is);
        double currentStorage = data.getDouble(POWER_NBT_KEY);
        double maxStorage = this.getAEMaxPower(is);
        switch (op) {
            case INJECT: {
                currentStorage += adjustment;
                if (currentStorage > maxStorage) {
                    double diff = currentStorage - maxStorage;
                    data.setDouble(POWER_NBT_KEY, maxStorage);
                    return diff;
                }
                data.setDouble(POWER_NBT_KEY, currentStorage);
                return 0.0;
            }
            case EXTRACT: {
                if (currentStorage > adjustment) {
                    data.setDouble(POWER_NBT_KEY, currentStorage -= adjustment);
                    return adjustment;
                }
                data.setDouble(POWER_NBT_KEY, 0.0);
                return currentStorage;
            }
        }
        return currentStorage;
    }

    double injectExternalPower(PowerUnits input, ItemStack is, double amount, boolean simulate) {
        if (simulate) {
            int requiredEU = (int)PowerUnits.AE.convertTo(PowerUnits.EU, this.getAEMaxPower(is) - this.getAECurrentPower(is));
            if (amount < (double)requiredEU) {
                return 0.0;
            }
            return amount - (double)requiredEU;
        }
        double powerRemainder = this.injectAEPower(is, PowerUnits.EU.convertTo(PowerUnits.AE, amount));
        return PowerUnits.AE.convertTo(PowerUnits.EU, powerRemainder);
    }

    @Override
    public double injectAEPower(ItemStack is, double amt) {
        return this.getInternalBattery(is, batteryOperation.INJECT, amt);
    }

    @Override
    public double extractAEPower(ItemStack is, double amt) {
        return this.getInternalBattery(is, batteryOperation.EXTRACT, amt);
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        return this.powerCapacity;
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        return this.getInternalBattery(is, batteryOperation.STORAGE, 0.0);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    private static enum batteryOperation {
        STORAGE,
        INJECT,
        EXTRACT;

    }
}

