/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.ActionItems;
import appeng.api.config.ItemSubstitution;
import appeng.api.config.PatternSlotConfig;
import appeng.api.config.Settings;
import appeng.api.storage.ITerminalHost;
import appeng.client.gui.implementations.GuiMEMonitorable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.container.implementations.ContainerPatternTermEx;
import appeng.container.slot.AppEngSlot;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Keyboard;

public class GuiPatternTermEx
extends GuiMEMonitorable {
    private static final String SUBSITUTION_DISABLE = "0";
    private static final String SUBSITUTION_ENABLE = "1";
    private final ContainerPatternTermEx container = (ContainerPatternTermEx)this.inventorySlots;
    private GuiImgButton substitutionsEnabledBtn;
    private GuiImgButton substitutionsDisabledBtn;
    private GuiImgButton encodeBtn;
    private GuiImgButton clearBtn;
    private GuiImgButton invertBtn;
    private GuiImgButton doubleBtn;
    private boolean containerSynchronized = false;

    public GuiPatternTermEx(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(inventoryPlayer, te, new ContainerPatternTermEx(inventoryPlayer, te));
        this.setReservedSpace(81);
    }

    @Override
    protected void actionPerformed(GuiButton btn) {
        super.actionPerformed(btn);
        try {
            if (this.encodeBtn == btn) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("PatternTerminalEx.Encode", SUBSITUTION_ENABLE));
            } else if (this.clearBtn == btn) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("PatternTerminalEx.Clear", SUBSITUTION_ENABLE));
            } else if (this.invertBtn == btn) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("PatternTerminalEx.Invert", this.container.inverted ? SUBSITUTION_DISABLE : SUBSITUTION_ENABLE));
                this.updateButtons(!this.container.inverted);
            } else if (this.substitutionsEnabledBtn == btn || this.substitutionsDisabledBtn == btn) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("PatternTerminalEx.Substitute", this.substitutionsEnabledBtn == btn ? SUBSITUTION_DISABLE : SUBSITUTION_ENABLE));
            } else if (this.doubleBtn == btn) {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("PatternTerminalEx.Double", Keyboard.isKeyDown((int)42) ? SUBSITUTION_ENABLE : SUBSITUTION_DISABLE));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.substitutionsEnabledBtn = new GuiImgButton(this.guiLeft + 97, this.guiTop + this.ySize - 163, Settings.ACTIONS, ItemSubstitution.ENABLED);
        this.substitutionsEnabledBtn.setHalfSize(true);
        this.buttonList.add(this.substitutionsEnabledBtn);
        this.substitutionsDisabledBtn = new GuiImgButton(this.guiLeft + 97, this.guiTop + this.ySize - 163, Settings.ACTIONS, ItemSubstitution.DISABLED);
        this.substitutionsDisabledBtn.setHalfSize(true);
        this.buttonList.add(this.substitutionsDisabledBtn);
        this.clearBtn = new GuiImgButton(this.guiLeft + 87, this.guiTop + this.ySize - 163, Settings.ACTIONS, ActionItems.CLOSE);
        this.clearBtn.setHalfSize(true);
        this.buttonList.add(this.clearBtn);
        this.encodeBtn = new GuiImgButton(this.guiLeft + 147, this.guiTop + this.ySize - 142, Settings.ACTIONS, ActionItems.ENCODE);
        this.buttonList.add(this.encodeBtn);
        this.invertBtn = new GuiImgButton(this.guiLeft + 87, this.guiTop + this.ySize - 153, Settings.ACTIONS, this.container.inverted ? PatternSlotConfig.C_4_16 : PatternSlotConfig.C_16_4);
        this.invertBtn.setHalfSize(true);
        this.buttonList.add(this.invertBtn);
        this.doubleBtn = new GuiImgButton(this.guiLeft + 97, this.guiTop + this.ySize - 153, Settings.ACTIONS, ActionItems.DOUBLE);
        this.doubleBtn.setHalfSize(true);
        this.buttonList.add(this.doubleBtn);
    }

    private void updateButtons(boolean val) {
        int offset = val ? -54 : 54;
        this.substitutionsEnabledBtn.xPosition += offset;
        this.substitutionsDisabledBtn.xPosition += offset;
        this.clearBtn.xPosition += offset;
        this.invertBtn.xPosition += offset;
        this.doubleBtn.xPosition += offset;
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        if (this.container.substitute) {
            this.substitutionsEnabledBtn.visible = true;
            this.substitutionsDisabledBtn.visible = false;
        } else {
            this.substitutionsEnabledBtn.visible = false;
            this.substitutionsDisabledBtn.visible = true;
        }
        if (!this.containerSynchronized) {
            this.containerSynchronized = true;
            if (this.container.inverted) {
                this.updateButtons(true);
            }
        }
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        this.fontRendererObj.drawString(GuiText.PatternTerminalEx.getLocal(), 8, this.ySize - 96 + 2 - this.getReservedSpace(), 0x404040);
    }

    @Override
    protected String getBackground() {
        return this.container.inverted ? "guis/pattern4.png" : "guis/pattern3.png";
    }

    @Override
    protected void repositionSlot(AppEngSlot s) {
        s.yDisplayPosition = s.isPlayerSide() ? s.getY() + this.ySize - 78 - 5 : s.getY() + this.ySize - 78 - 3;
    }
}

