/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.gui.widgets.ITooltip;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class MEGuiTextField
extends GuiTextField {
    private static final int PADDING = 2;
    private String tooltip;
    private final int _xPos;
    private final int _yPos;
    private final int _width;
    private final int _height;

    public MEGuiTextField(FontRenderer fontRenderer, int xPos, int yPos, int width, int height) {
        super(fontRenderer, xPos + 2, yPos + 2, width - 4 - fontRenderer.getCharWidth('_'), height - 4);
        this._xPos = xPos;
        this._yPos = yPos;
        this._width = width;
        this._height = height;
    }

    public void mouseClicked(int xPos, int yPos, int button) {
        super.mouseClicked(xPos, yPos, button);
        boolean requiresFocus = this.isMouseIn(xPos, yPos);
        this.setFocused(requiresFocus);
    }

    public boolean isMouseIn(int xCoord, int yCoord) {
        boolean withinXRange = this._xPos <= xCoord && xCoord < this._xPos + this._width;
        boolean withinYRange = this._yPos <= yCoord && yCoord < this._yPos + this._height;
        return withinXRange && withinYRange;
    }

    public void setMessage(String t) {
        this.tooltip = t;
    }

    public class TooltipProvider
    implements ITooltip {
        @Override
        public String getMessage() {
            return MEGuiTextField.this.tooltip;
        }

        @Override
        public int xPos() {
            return MEGuiTextField.this._xPos;
        }

        @Override
        public int yPos() {
            return MEGuiTextField.this._yPos;
        }

        @Override
        public int getHeight() {
            return MEGuiTextField.this._height;
        }

        @Override
        public int getWidth() {
            return MEGuiTextField.this._width;
        }

        @Override
        public boolean isVisible() {
            return MEGuiTextField.this.getVisible();
        }
    }
}

