/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.util.IOrientable;
import appeng.block.misc.BlockCharger;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.core.AELog;
import appeng.tile.misc.TileCharger;
import appeng.util.Platform;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderBlockCharger
extends BaseBlockRender<BlockCharger, TileCharger> {
    public RenderBlockCharger() {
        super(true, 30.0);
    }

    @Override
    public void renderInventory(BlockCharger blk, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        Tessellator tess = Tessellator.instance;
        renderer.renderAllFaces = true;
        this.setInvRenderBounds(renderer, 6, 1, 0, 10, 15, 2);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        blk.getRendererInstance().setTemporaryRenderIcons(ExtraBlockTextures.BlockChargerInside.getIcon(), null, null, null, null, null);
        this.setInvRenderBounds(renderer, 2, 0, 2, 14, 3, 14);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 3, 3, 3, 13, 4, 13);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        blk.getRendererInstance().setTemporaryRenderIcon(null);
        blk.getRendererInstance().setTemporaryRenderIcons(null, ExtraBlockTextures.BlockChargerInside.getIcon(), null, null, null, null);
        this.setInvRenderBounds(renderer, 2, 13, 2, 14, 16, 14);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 3, 12, 3, 13, 13, 13);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, tess, 0xFFFFFF, renderer);
        renderer.renderAllFaces = false;
        blk.getRendererInstance().setTemporaryRenderIcon(null);
    }

    @Override
    public boolean renderInWorld(BlockCharger block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        this.preRenderInWorld(block, world, x, y, z, renderer);
        IOrientable te = this.getOrientable(block, world, x, y, z);
        ForgeDirection fdy = te.getUp();
        ForgeDirection fdz = te.getForward();
        ForgeDirection fdx = Platform.crossProduct(fdz, fdy).getOpposite();
        renderer.renderAllFaces = true;
        this.renderBlockBounds(renderer, 6.0, 1.0, 0.0, 10.0, 15.0, 2.0, fdx, fdy, fdz);
        boolean out = renderer.renderStandardBlock((Block)block, x, y, z);
        block.getRendererInstance().setTemporaryRenderIcons(ExtraBlockTextures.BlockChargerInside.getIcon(), null, null, null, null, null);
        this.renderBlockBounds(renderer, 2.0, 0.0, 2.0, 14.0, 3.0, 14.0, fdx, fdy, fdz);
        out = renderer.renderStandardBlock((Block)block, x, y, z);
        this.renderBlockBounds(renderer, 3.0, 3.0, 3.0, 13.0, 4.0, 13.0, fdx, fdy, fdz);
        out = renderer.renderStandardBlock((Block)block, x, y, z);
        block.getRendererInstance().setTemporaryRenderIcon(null);
        block.getRendererInstance().setTemporaryRenderIcons(null, ExtraBlockTextures.BlockChargerInside.getIcon(), null, null, null, null);
        this.renderBlockBounds(renderer, 2.0, 13.0, 2.0, 14.0, 16.0, 14.0, fdx, fdy, fdz);
        out = renderer.renderStandardBlock((Block)block, x, y, z);
        this.renderBlockBounds(renderer, 3.0, 12.0, 3.0, 13.0, 13.0, 13.0, fdx, fdy, fdz);
        out = renderer.renderStandardBlock((Block)block, x, y, z);
        renderer.renderAllFaces = false;
        block.getRendererInstance().setTemporaryRenderIcon(null);
        this.postRenderInWorld(renderer);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTile(BlockCharger block, TileCharger tile, Tessellator tess, double x, double y, double z, float f, RenderBlocks renderer) {
        if (tile == null) {
            return;
        }
        ItemStack sis = tile.getStackInSlot(0);
        if (sis == null) {
            return;
        }
        GL11.glPushMatrix();
        this.applyTESRRotation(x, y, z, tile.getForward(), tile.getUp());
        try {
            GL11.glTranslatef((float)0.5f, (float)0.45f, (float)0.5f);
            GL11.glScalef((float)0.9090909f, (float)0.9090909f, (float)0.9090909f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            Block blk = Block.getBlockFromItem((Item)sis.getItem());
            if (sis.getItemSpriteNumber() == 0 && block != null && RenderBlocks.renderItemIn3d((int)blk.getRenderType())) {
                GL11.glRotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)15.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            int br = tile.getWorldObj().getLightBrightnessForSkyBlocks(tile.xCoord, tile.yCoord, tile.zCoord, 0);
            int var11 = br % 65536;
            int var12 = br / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)var11, (float)var12);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)32826);
            tess.setColorOpaque_F(1.0f, 1.0f, 1.0f);
            this.doRenderItem(sis, tile);
        }
        catch (Exception err) {
            AELog.debug(err);
        }
        finally {
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2896);
        }
        GL11.glPopMatrix();
    }
}

