/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.client.texture.CableBusTextures;
import appeng.core.AEConfig;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.automation.PartUpgradeable;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.prioitylist.FuzzyPriorityList;
import appeng.util.prioitylist.PrecisePriorityList;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFirework;
import net.minecraft.item.ItemReed;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;

public class PartFormationPlane
extends PartUpgradeable
implements ICellContainer,
IPriorityHost,
IMEInventory<IAEItemStack> {
    private final MEInventoryHandler myHandler = new MEInventoryHandler<IAEItemStack>(this, StorageChannel.ITEMS);
    private final AppEngInternalAEInventory Config = new AppEngInternalAEInventory(this, 63);
    private EntityPlayer owner = null;
    private int priority = 0;
    private boolean wasActive = false;
    private boolean blocked = false;

    public PartFormationPlane(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.PLACE_BLOCK, YesNo.YES);
        this.updateHandler();
    }

    @Override
    public void onPlacement(EntityPlayer player, ItemStack held, ForgeDirection side) {
        super.onPlacement(player, held, side);
        this.owner = player;
    }

    private void updateHandler() {
        this.myHandler.setBaseAccess(AccessRestriction.WRITE);
        this.myHandler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.myHandler.setPriority(this.priority);
        IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
        int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
        for (int x = 0; x < this.Config.getSizeInventory() && x < slotsToUse; ++x) {
            IAEItemStack is = this.Config.getAEStackInSlot(x);
            if (is == null) continue;
            priorityList.add(is);
        }
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.myHandler.setPartitionList(new FuzzyPriorityList<IAEItemStack>(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
        } else {
            this.myHandler.setPartitionList(new PrecisePriorityList<IAEItemStack>(priorityList));
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    protected int getUpgradeSlots() {
        return 5;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.updateHandler();
        this.getHost().markForSave();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.Config) {
            this.updateHandler();
        }
    }

    @Override
    public void upgradesChanged() {
        this.updateHandler();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.Config.readFromNBT(data, "config");
        this.priority = data.getInteger("priority");
        this.updateHandler();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.Config.writeToNBT(data, "config");
        data.setInteger("priority", this.priority);
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.Config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.updateHandler();
            this.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.updateHandler();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            int x = te.xCoord;
            int y = te.yCoord;
            int z = te.zCoord;
            ForgeDirection e = bch.getWorldX();
            ForgeDirection u = bch.getWorldY();
            if (this.isTransitionPlane(te.getWorldObj().getTileEntity(x - e.offsetX, y - e.offsetY, z - e.offsetZ), this.getSide())) {
                minX = false;
            }
            if (this.isTransitionPlane(te.getWorldObj().getTileEntity(x + e.offsetX, y + e.offsetY, z + e.offsetZ), this.getSide())) {
                maxX = 16;
            }
            if (this.isTransitionPlane(te.getWorldObj().getTileEntity(x - u.offsetX, y - u.offsetY, z - u.offsetZ), this.getSide())) {
                minY = false;
            }
            if (this.isTransitionPlane(te.getWorldObj().getTileEntity(x + u.offsetX, y + u.offsetY, z + u.offsetZ), this.getSide())) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartTransitionPlaneBack.getIcon(), this.getItemStack().getIconIndex(), CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartPlaneSides.getIcon());
        rh.setBounds(1.0f, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        boolean minX = true;
        ForgeDirection e = rh.getWorldX();
        ForgeDirection u = rh.getWorldY();
        TileEntity te = this.getHost().getTile();
        if (this.isTransitionPlane(te.getWorldObj().getTileEntity(x - e.offsetX, y - e.offsetY, z - e.offsetZ), this.getSide())) {
            minX = false;
        }
        int maxX = 15;
        if (this.isTransitionPlane(te.getWorldObj().getTileEntity(x + e.offsetX, y + e.offsetY, z + e.offsetZ), this.getSide())) {
            maxX = 16;
        }
        boolean minY = true;
        if (this.isTransitionPlane(te.getWorldObj().getTileEntity(x - u.offsetX, y - u.offsetY, z - u.offsetZ), this.getSide())) {
            minY = false;
        }
        int maxY = 15;
        if (this.isTransitionPlane(te.getWorldObj().getTileEntity(x + u.offsetX, y + u.offsetY, z + u.offsetZ), this.getSide())) {
            maxY = 16;
        }
        boolean isActive = (this.getClientFlags() & 3) == 3;
        this.setRenderCache(rh.useSimplifiedRendering(x, y, z, this, this.getRenderCache()));
        rh.setTexture(CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartTransitionPlaneBack.getIcon(), isActive ? CableBusTextures.BlockFormPlaneOn.getIcon() : this.getItemStack().getIconIndex(), CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartPlaneSides.getIcon());
        rh.setBounds((float)minX, (float)minY, 15.0f, maxX, maxY, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartTransitionPlaneBack.getIcon(), isActive ? CableBusTextures.BlockFormPlaneOn.getIcon() : this.getItemStack().getIconIndex(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public void onNeighborChanged() {
        TileEntity te = this.getHost().getTile();
        World w = te.getWorldObj();
        ForgeDirection side = this.getSide();
        int x = te.xCoord + side.offsetX;
        int y = te.yCoord + side.offsetY;
        int z = te.zCoord + side.offsetZ;
        this.blocked = !w.getBlock(x, y, z).isReplaceable((IBlockAccess)w, x, y, z);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, Vec3 pos) {
        if (!player.isSneaking()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_FORMATION_PLANE);
            return true;
        }
        return false;
    }

    private boolean isTransitionPlane(TileEntity blockTileEntity, ForgeDirection side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p instanceof PartFormationPlane;
        }
        return false;
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive() && channel == StorageChannel.ITEMS) {
            ArrayList<IMEInventoryHandler> Handler = new ArrayList<IMEInventoryHandler>(1);
            Handler.add(this.myHandler);
            return Handler;
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.updateHandler();
    }

    @Override
    public void blinkCell(int slot) {
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        if (this.blocked || input == null || input.getStackSize() <= 0L) {
            return input;
        }
        YesNo placeBlock = (YesNo)this.getConfigManager().getSetting(Settings.PLACE_BLOCK);
        ItemStack is = input.getItemStack();
        Item i = is.getItem();
        long maxStorage = Math.min(input.getStackSize(), (long)is.getMaxStackSize());
        boolean worked = false;
        TileEntity te = this.getHost().getTile();
        World w = te.getWorldObj();
        ForgeDirection side = this.getSide();
        int x = te.xCoord + side.offsetX;
        int y = te.yCoord + side.offsetY;
        int z = te.zCoord + side.offsetZ;
        if (w.getBlock(x, y, z).isReplaceable((IBlockAccess)w, x, y, z)) {
            if (placeBlock == YesNo.YES && (i instanceof ItemBlock || i instanceof IPlantable || i instanceof ItemSkull || i instanceof ItemFirework || i instanceof ItemReed)) {
                EntityPlayer player = Platform.getPlayer((WorldServer)w);
                Platform.configurePlayer(player, side, this.getTile());
                if (i instanceof ItemFirework) {
                    Chunk c = w.getChunkFromBlockCoords(x, z);
                    int sum = 0;
                    for (List Z : c.entityLists) {
                        sum += Z.size();
                    }
                    if (sum > 32) {
                        return input;
                    }
                }
                maxStorage = is.stackSize;
                worked = true;
                if (type == Actionable.MODULATE) {
                    if (i instanceof IPlantable || i instanceof ItemSkull || i instanceof ItemReed) {
                        boolean Worked = false;
                        if (side.offsetX == 0 && side.offsetZ == 0) {
                            Worked = i.onItemUse(is, player, w, x + side.offsetX, y + side.offsetY, z + side.offsetZ, side.getOpposite().ordinal(), (float)side.offsetX, (float)side.offsetY, (float)side.offsetZ);
                        }
                        if (!Worked && side.offsetX == 0 && side.offsetZ == 0) {
                            Worked = i.onItemUse(is, player, w, x - side.offsetX, y - side.offsetY, z - side.offsetZ, side.ordinal(), (float)side.offsetX, (float)side.offsetY, (float)side.offsetZ);
                        }
                        if (!Worked && side.offsetY == 0) {
                            Worked = i.onItemUse(is, player, w, x, y - 1, z, ForgeDirection.UP.ordinal(), (float)side.offsetX, (float)side.offsetY, (float)side.offsetZ);
                        }
                        if (!Worked) {
                            i.onItemUse(is, player, w, x, y, z, side.getOpposite().ordinal(), (float)side.offsetX, (float)side.offsetY, (float)side.offsetZ);
                        }
                        maxStorage -= (long)is.stackSize;
                    } else if (i instanceof ItemFirework) {
                        i.onItemUse(is, player, w, x, y, z, side.getOpposite().ordinal(), (float)side.offsetX, (float)side.offsetY, (float)side.offsetZ);
                        maxStorage -= (long)is.stackSize;
                    } else {
                        player.setCurrentItemOrArmor(0, is.copy());
                        BlockSnapshot blockSnapshot = new BlockSnapshot(w, x, y, z, ((ItemBlock)i).field_150939_a, i.getMetadata(is.getItemDamage()));
                        BlockEvent.PlaceEvent event = new BlockEvent.PlaceEvent(blockSnapshot, w.getBlock(x, y, z), this.owner == null ? player : this.owner);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.isCanceled()) {
                            i.onItemUse(is, player, w, x, y, z, side.getOpposite().ordinal(), (float)side.offsetX, (float)side.offsetY, (float)side.offsetZ);
                            maxStorage -= (long)is.stackSize;
                        }
                    }
                } else {
                    maxStorage = 1L;
                }
            } else {
                worked = true;
                Chunk c = w.getChunkFromBlockCoords(x, z);
                int sum = 0;
                for (List Z : c.entityLists) {
                    sum += Z.size();
                }
                if (sum < AEConfig.instance.formationPlaneEntityLimit) {
                    if (type == Actionable.MODULATE) {
                        EntityItem ei;
                        is.stackSize = (int)maxStorage;
                        EntityItem result = ei = new EntityItem(w, (side.offsetX != 0 ? 0.0 : 0.7) * (double)(Platform.getRandomFloat() - 0.5f) + 0.5 + (double)side.offsetX * -0.3 + (double)x, (side.offsetY != 0 ? 0.0 : 0.7) * (double)(Platform.getRandomFloat() - 0.5f) + 0.5 + (double)side.offsetY * -0.3 + (double)y, (side.offsetZ != 0 ? 0.0 : 0.7) * (double)(Platform.getRandomFloat() - 0.5f) + 0.5 + (double)side.offsetZ * -0.3 + (double)z, is.copy());
                        ei.motionX = (double)side.offsetX * 0.2;
                        ei.motionY = (double)side.offsetY * 0.2;
                        ei.motionZ = (double)side.offsetZ * 0.2;
                        if (is.getItem().hasCustomEntity(is)) {
                            result = is.getItem().createEntity(w, (Entity)ei, is);
                            if (result != null) {
                                ei.setDead();
                            } else {
                                result = ei;
                            }
                        }
                        if (!w.spawnEntityInWorld((Entity)result)) {
                            if (result.getEntityItem().getItem() == Item.getItemFromBlock((Block)Blocks.dragon_egg)) {
                                worked = true;
                            } else {
                                worked = result.isDead;
                                result.setDead();
                            }
                        }
                    }
                } else {
                    worked = false;
                }
            }
        }
        boolean bl = this.blocked = !w.getBlock(x, y, z).isReplaceable((IBlockAccess)w, x, y, z);
        if (worked) {
            IAEItemStack out = input.copy();
            out.decStackSize(maxStorage);
            if (out.getStackSize() == 0L) {
                return null;
            }
            return out;
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public void saveChanges(IMEInventory cellInventory) {
    }
}

