/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.me.GridAccessException;
import appeng.parts.p2p.PartP2PTunnel;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PartP2PRedstone
extends PartP2PTunnel<PartP2PRedstone> {
    private int power;
    private boolean recursive = false;

    public PartP2PRedstone(ItemStack is) {
        super(is);
    }

    @MENetworkEventSubscribe
    public void changeStateA(MENetworkBootingStatusChange bs) {
        this.setNetworkReady();
    }

    private void setNetworkReady() {
        PartP2PRedstone in;
        if (this.isOutput() && (in = (PartP2PRedstone)this.getInput()) != null) {
            this.putInput(in.power);
        }
    }

    private void putInput(Object o) {
        int newPower;
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        if (this.isOutput() && this.getProxy().isActive() && this.power != (newPower = ((Integer)o).intValue())) {
            this.power = newPower;
            this.notifyNeighbors();
        }
        this.recursive = false;
    }

    private void notifyNeighbors() {
        World worldObj = this.getTile().getWorldObj();
        int xCoord = this.getTile().xCoord;
        int yCoord = this.getTile().yCoord;
        int zCoord = this.getTile().zCoord;
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord, zCoord);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord - 1, yCoord, zCoord);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord - 1, zCoord);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord, zCoord - 1);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord, zCoord + 1);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord, yCoord + 1, zCoord);
        Platform.notifyBlocksOfNeighbors(worldObj, xCoord + 1, yCoord, zCoord);
    }

    @MENetworkEventSubscribe
    public void changeStateB(MENetworkChannelsChanged bs) {
        this.setNetworkReady();
    }

    @MENetworkEventSubscribe
    public void changeStateC(MENetworkPowerStatusChange bs) {
        this.setNetworkReady();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getTypeTexture() {
        return Blocks.redstone_block.getBlockTextureFromSide(0);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.getInteger("power");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.setInteger("power", this.power);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.setNetworkReady();
    }

    public float getPowerDrainPerTick() {
        return 0.5f;
    }

    @Override
    public void onNeighborChanged() {
        if (!this.isOutput()) {
            int x = this.getTile().xCoord + this.getSide().offsetX;
            int y = this.getTile().yCoord + this.getSide().offsetY;
            int z = this.getTile().zCoord + this.getSide().offsetZ;
            Block b = this.getTile().getWorldObj().getBlock(x, y, z);
            if (b != null && !this.isOutput()) {
                int srcSide = this.getSide().ordinal();
                if (b instanceof BlockRedstoneWire) {
                    srcSide = 1;
                }
                this.power = b.isProvidingStrongPower((IBlockAccess)this.getTile().getWorldObj(), x, y, z, srcSide);
                this.power = Math.max(this.power, b.isProvidingWeakPower((IBlockAccess)this.getTile().getWorldObj(), x, y, z, srcSide));
                this.sendToOutput(this.power);
            } else {
                this.sendToOutput(0);
            }
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isOutput() ? this.power : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isOutput() ? this.power : 0;
    }

    private void sendToOutput(int power) {
        try {
            for (PartP2PRedstone rs : this.getOutputs()) {
                rs.putInput(power);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }
}

