/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.AEApi;
import appeng.api.util.WorldCoord;
import appeng.core.stats.Achievements;
import appeng.spatial.CachedPlane;
import appeng.spatial.ISpatialVisitor;
import appeng.spatial.StorageWorldProvider;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class StorageHelper {
    private static StorageHelper instance;

    public static StorageHelper getInstance() {
        if (instance == null) {
            instance = new StorageHelper();
        }
        return instance;
    }

    private Entity teleportEntity(Entity entity, TelDestination link) {
        boolean diffDestination;
        EntityPlayerMP player;
        WorldServer newWorld;
        WorldServer oldWorld;
        try {
            oldWorld = (WorldServer)entity.worldObj;
            newWorld = (WorldServer)link.dim;
            player = entity instanceof EntityPlayerMP ? (EntityPlayerMP)entity : null;
        }
        catch (Throwable e) {
            return entity;
        }
        if (oldWorld == null) {
            return entity;
        }
        if (newWorld == null) {
            return entity;
        }
        if (entity.riddenByEntity != null) {
            return this.teleportEntity(entity.riddenByEntity, link);
        }
        Entity cart = entity.ridingEntity;
        if (cart != null) {
            entity.mountEntity(null);
            cart = this.teleportEntity(cart, link);
        }
        ((WorldServer)WorldServer.class.cast(newWorld)).getChunkProvider().loadChunk(MathHelper.floor_double((double)link.x) >> 4, MathHelper.floor_double((double)link.z) >> 4);
        boolean bl = diffDestination = newWorld != oldWorld;
        if (diffDestination) {
            if (player != null) {
                if (((TelDestination)link).dim.provider instanceof StorageWorldProvider) {
                    Achievements.SpatialIOExplorer.addToPlayer((EntityPlayer)player);
                }
                player.mcServer.getConfigurationManager().transferPlayerToDimension(player, ((TelDestination)link).dim.provider.dimensionId, (Teleporter)new METeleporter(newWorld, link));
            } else {
                Entity newEntity;
                int entX = entity.chunkCoordX;
                int entZ = entity.chunkCoordZ;
                if (entity.addedToChunk && oldWorld.getChunkProvider().chunkExists(entX, entZ)) {
                    oldWorld.getChunkFromChunkCoords(entX, entZ).removeEntity(entity);
                    oldWorld.getChunkFromChunkCoords((int)entX, (int)entZ).isModified = true;
                }
                if ((newEntity = EntityList.createEntityByName((String)EntityList.getEntityString((Entity)entity), (World)newWorld)) != null) {
                    entity.prevPosX = entity.posX = link.x;
                    entity.lastTickPosX = entity.posX;
                    entity.prevPosY = entity.posY = link.y;
                    entity.lastTickPosY = entity.posY;
                    entity.prevPosZ = entity.posZ = link.z;
                    entity.lastTickPosZ = entity.posZ;
                    if (entity instanceof EntityHanging) {
                        EntityHanging h = (EntityHanging)entity;
                        h.field_146063_b += link.xOff;
                        h.field_146064_c += link.yOff;
                        h.field_146062_d += link.zOff;
                    }
                } else {
                    return null;
                }
                newEntity.copyDataFrom(entity, true);
                newEntity.dimension = newWorld.provider.dimensionId;
                newEntity.forceSpawn = true;
                entity.isDead = true;
                entity = newEntity;
                newWorld.spawnEntityInWorld(entity);
            }
        }
        entity.worldObj.updateEntityWithOptionalForce(entity, false);
        if (cart != null) {
            if (player != null) {
                entity.worldObj.updateEntityWithOptionalForce(entity, true);
            }
            entity.mountEntity(cart);
        }
        return entity;
    }

    private void transverseEdges(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, ISpatialVisitor visitor) {
        int x;
        int z;
        for (int y = minY; y < maxY; ++y) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(minX, y, z);
                visitor.visit(maxX, y, z);
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (z = minZ; z < maxZ; ++z) {
                visitor.visit(x, minY, z);
                visitor.visit(x, maxY, z);
            }
        }
        for (x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                visitor.visit(x, y, minZ);
                visitor.visit(x, y, maxZ);
            }
        }
    }

    public void swapRegions(World src, World dst, int x, int y, int z, int i, int j, int k, int scaleX, int scaleY, int scaleZ) {
        for (Block matrixFrameBlock : AEApi.instance().definitions().blocks().matrixFrame().maybeBlock().asSet()) {
            this.transverseEdges(i - 1, j - 1, k - 1, i + scaleX + 1, j + scaleY + 1, k + scaleZ + 1, new WrapInMatrixFrame(matrixFrameBlock, 0, dst));
        }
        AxisAlignedBB srcBox = AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + scaleX + 1), (double)(y + scaleY + 1), (double)(z + scaleZ + 1));
        AxisAlignedBB dstBox = AxisAlignedBB.getBoundingBox((double)i, (double)j, (double)k, (double)(i + scaleX + 1), (double)(j + scaleY + 1), (double)(k + scaleZ + 1));
        CachedPlane cDst = new CachedPlane(dst, i, j, k, i + scaleX, j + scaleY, k + scaleZ);
        CachedPlane cSrc = new CachedPlane(src, x, y, z, x + scaleX, y + scaleY, z + scaleZ);
        cSrc.swap(cDst);
        List srcE = src.getEntitiesWithinAABB(Entity.class, srcBox);
        List dstE = dst.getEntitiesWithinAABB(Entity.class, dstBox);
        for (Entity e : dstE) {
            this.teleportEntity(e, new TelDestination(src, srcBox, e.posX, e.posY, e.posZ, -i + x, -j + y, -k + z));
        }
        for (Entity e : srcE) {
            this.teleportEntity(e, new TelDestination(dst, dstBox, e.posX, e.posY, e.posZ, -x + i, -y + j, -z + k));
        }
        for (WorldCoord wc : cDst.getUpdates()) {
            cDst.getWorld().notifyBlockOfNeighborChange(wc.x, wc.y, wc.z, Platform.AIR_BLOCK);
        }
        for (WorldCoord wc : cSrc.getUpdates()) {
            cSrc.getWorld().notifyBlockOfNeighborChange(wc.x, wc.y, wc.z, Platform.AIR_BLOCK);
        }
        this.transverseEdges(x - 1, y - 1, z - 1, x + scaleX + 1, y + scaleY + 1, z + scaleZ + 1, new TriggerUpdates(src));
        this.transverseEdges(i - 1, j - 1, k - 1, i + scaleX + 1, j + scaleY + 1, k + scaleZ + 1, new TriggerUpdates(dst));
        this.transverseEdges(x, y, z, x + scaleX, y + scaleY, z + scaleZ, new TriggerUpdates(src));
        this.transverseEdges(i, j, k, i + scaleX, j + scaleY, k + scaleZ, new TriggerUpdates(dst));
    }

    private static class METeleporter
    extends Teleporter {
        private final TelDestination destination;

        public METeleporter(WorldServer par1WorldServer, TelDestination d) {
            super(par1WorldServer);
            this.destination = d;
        }

        public void placeInPortal(Entity par1Entity, double par2, double par4, double par6, float par8) {
            par1Entity.setLocationAndAngles(this.destination.x, this.destination.y, this.destination.z, par1Entity.rotationYaw, 0.0f);
            par1Entity.motionZ = 0.0;
            par1Entity.motionY = 0.0;
            par1Entity.motionX = 0.0;
        }

        public boolean placeInExistingPortal(Entity par1Entity, double par2, double par4, double par6, float par8) {
            return false;
        }

        public boolean makePortal(Entity par1Entity) {
            return false;
        }

        public void removeStalePortalLocations(long par1) {
        }
    }

    private static class TelDestination {
        private final World dim;
        private final double x;
        private final double y;
        private final double z;
        private final int xOff;
        private final int yOff;
        private final int zOff;

        TelDestination(World dimension, AxisAlignedBB srcBox, double x, double y, double z, int tileX, int tileY, int tileZ) {
            this.dim = dimension;
            this.x = Math.min(srcBox.maxX - 0.5, Math.max(srcBox.minX + 0.5, x + (double)tileX));
            this.y = Math.min(srcBox.maxY - 0.5, Math.max(srcBox.minY + 0.5, y + (double)tileY));
            this.z = Math.min(srcBox.maxZ - 0.5, Math.max(srcBox.minZ + 0.5, z + (double)tileZ));
            this.xOff = tileX;
            this.yOff = tileY;
            this.zOff = tileZ;
        }
    }

    private static class WrapInMatrixFrame
    implements ISpatialVisitor {
        private final World dst;
        private final Block blkID;
        private final int Meta;

        public WrapInMatrixFrame(Block blockID, int metaData, World dst2) {
            this.dst = dst2;
            this.blkID = blockID;
            this.Meta = metaData;
        }

        @Override
        public void visit(int x, int y, int z) {
            this.dst.setBlock(x, y, z, this.blkID, this.Meta, 3);
        }
    }

    private static class TriggerUpdates
    implements ISpatialVisitor {
        private final World dst;

        public TriggerUpdates(World dst2) {
            this.dst = dst2;
        }

        @Override
        public void visit(int x, int y, int z) {
            Block blk = this.dst.getBlock(x, y, z);
            blk.onNeighborBlockChange(this.dst, x, y, z, Platform.AIR_BLOCK);
        }
    }
}

