/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.networking;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.tile.grid.AENetworkPowerTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.InvOperation;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyAcceptor
extends AENetworkPowerTile {
    private static final AppEngInternalInventory INTERNAL_INVENTORY = new AppEngInternalInventory(null, 0);
    private final int[] sides = new int[0];

    public TileEnergyAcceptor() {
        this.getProxy().setIdlePowerUsage(0.0);
        this.setInternalMaxPower(8000.0);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.READ_WRITE);
    }

    @Override
    public void readFromNBT_AENetwork(NBTTagCompound data) {
        this.setInternalCurrentPower(data.getDouble("internalCurrentPower"));
    }

    @Override
    public void writeToNBT_AENetwork(NBTTagCompound data) {
        data.setDouble("internalCurrentPower", this.getInternalCurrentPower());
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    @Override
    protected double getFunnelPowerDemand(double maxRequired) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            return grid.getEnergyDemand(maxRequired);
        }
        catch (GridAccessException e) {
            return this.getInternalMaxPower();
        }
    }

    @Override
    protected double funnelPowerIntoStorage(double power, Actionable mode) {
        try {
            IEnergyGrid grid = this.getProxy().getEnergy();
            double leftOver = grid.injectPower(power, mode);
            if (mode == Actionable.SIMULATE) {
                return leftOver;
            }
            return 0.0;
        }
        catch (GridAccessException e) {
            return super.funnelPowerIntoStorage(power, mode);
        }
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        double res = super.extractAEPower(amt, mode);
        try {
            if (this.getInternalCurrentPower() < this.getInternalMaxPower()) {
                this.getProxy().getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public IInventory getInternalInventory() {
        return INTERNAL_INVENTORY;
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    @Override
    public int[] getAccessibleSlotsBySide(ForgeDirection side) {
        return this.sides;
    }
}

