/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import com.google.common.base.Optional;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;

public class AETrading
implements VillagerRegistry.IVillageTradeHandler {
    public void manipulateTradesForVillager(EntityVillager villager, MerchantRecipeList recipeList, Random random) {
        IMaterials materials = AEApi.instance().definitions().materials();
        this.addMerchant(recipeList, materials.silicon(), 1, random, 2);
        this.addMerchant(recipeList, materials.certusQuartzCrystal(), 2, random, 4);
        this.addMerchant(recipeList, materials.certusQuartzDust(), 1, random, 3);
        this.addTrade(recipeList, materials.certusQuartzDust(), materials.certusQuartzCrystal(), random, 2);
    }

    private void addMerchant(MerchantRecipeList list, IItemDefinition item, int emera, Random rand, int greed) {
        for (ItemStack itemStack : item.maybeStack(1).asSet()) {
            ItemStack from = itemStack.func_77946_l();
            ItemStack to = new ItemStack(Items.field_151166_bC);
            int multiplier = Math.abs(rand.nextInt()) % 6;
            int emeraldCost = emera + Math.abs(rand.nextInt()) % greed - multiplier;
            int mood = rand.nextInt() % 2;
            from.field_77994_a = multiplier + mood;
            to.field_77994_a = multiplier * emeraldCost - mood;
            if (to.field_77994_a < 0) {
                from.field_77994_a -= to.field_77994_a;
                to.field_77994_a -= to.field_77994_a;
            }
            this.addToList(list, from, to);
            ItemStack reverseTo = from.func_77946_l();
            ItemStack reverseFrom = to.func_77946_l();
            reverseFrom.field_77994_a = (int)((float)reverseFrom.field_77994_a * (rand.nextFloat() * 3.0f + 1.0f));
            this.addToList(list, reverseFrom, reverseTo);
        }
    }

    private void addTrade(MerchantRecipeList list, IItemDefinition inputDefinition, IItemDefinition outputDefinition, Random rand, int conversionVariance) {
        Optional<ItemStack> maybeInputStack = inputDefinition.maybeStack(1);
        Optional<ItemStack> maybeOutputStack = outputDefinition.maybeStack(1);
        if (maybeInputStack.isPresent() && maybeOutputStack.isPresent()) {
            ItemStack inputStack = ((ItemStack)maybeInputStack.get()).func_77946_l();
            ItemStack outputStack = ((ItemStack)maybeOutputStack.get()).func_77946_l();
            inputStack.field_77994_a = 1 + Math.abs(rand.nextInt()) % (1 + conversionVariance);
            outputStack.field_77994_a = 1;
            this.addToList(list, inputStack, outputStack);
        }
    }

    private void addToList(MerchantRecipeList l, ItemStack a, ItemStack b) {
        if (a.field_77994_a < 1) {
            a.field_77994_a = 1;
        }
        if (b.field_77994_a < 1) {
            b.field_77994_a = 1;
        }
        if (a.field_77994_a > a.func_77976_d()) {
            a.field_77994_a = a.func_77976_d();
        }
        if (b.field_77994_a > b.func_77976_d()) {
            b.field_77994_a = b.func_77976_d();
        }
        l.add((Object)new MerchantRecipe(a, b));
    }
}

