/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.util.AEColor;
import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseItemBlock;
import appeng.block.networking.BlockCableBus;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.render.WorldRender;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.MissingIcon;
import appeng.core.features.AEBlockFeatureHandler;
import appeng.core.features.AEFeature;
import appeng.core.features.FeatureNameExtractor;
import appeng.core.features.IAEFeature;
import appeng.core.features.IFeatureHandler;
import appeng.core.features.ItemStackSrc;
import appeng.helpers.AEGlassMaterial;
import appeng.helpers.ICustomCollision;
import appeng.tile.AEBaseTile;
import appeng.tile.networking.TileCableBus;
import appeng.tile.storage.TileSkyChest;
import appeng.util.LookDirection;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AEBaseBlock
extends BlockContainer
implements IAEFeature {
    private final String featureFullName;
    private final Optional<String> featureSubName;
    @SideOnly(value=Side.CLIENT)
    public IIcon renderIcon;
    protected boolean isOpaque = true;
    protected boolean isFullSize = true;
    protected boolean hasSubtypes = false;
    protected boolean isInventory = false;
    @SideOnly(value=Side.CLIENT)
    BlockRenderInfo renderInfo;
    private IFeatureHandler handler;
    @Nullable
    private Class<? extends TileEntity> tileEntityType = null;

    protected AEBaseBlock(Class<? extends AEBaseBlock> c, Material mat) {
        this(c, mat, (Optional<String>)Optional.absent());
        this.setLightOpacity(255);
        this.setLightLevel(0.0f);
        this.setHardness(2.2f);
        this.setTileProvider(false);
        this.setHarvestLevel("pickaxe", 0);
    }

    protected AEBaseBlock(Class<?> c, Material mat, Optional<String> subName) {
        super(mat);
        if (mat == AEGlassMaterial.INSTANCE || mat == Material.glass) {
            this.setStepSound(Block.soundTypeGlass);
        } else if (mat == Material.rock) {
            this.setStepSound(Block.soundTypeStone);
        } else if (mat == Material.wood) {
            this.setStepSound(Block.soundTypeWood);
        } else {
            this.setStepSound(Block.soundTypeMetal);
        }
        this.featureFullName = new FeatureNameExtractor(c, subName).get();
        this.featureSubName = subName;
    }

    private void setTileProvider(boolean b) {
        ReflectionHelper.setPrivateValue(Block.class, (Object)this, (Object)b, (String[])new String[]{"isTileProvider"});
    }

    public String toString() {
        return this.featureFullName;
    }

    public void registerNoIcons() {
        BlockRenderInfo info = this.getRendererInstance();
        FlippableIcon i = new FlippableIcon(new MissingIcon(this));
        info.updateIcons(i, i, i, i, i, i);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderInfo getRendererInstance() {
        if (this.renderInfo != null) {
            return this.renderInfo;
        }
        try {
            BaseBlockRender renderer = this.getRenderer().newInstance();
            this.renderInfo = new BlockRenderInfo(renderer);
            return this.renderInfo;
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.getRenderer(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to create a new instance of " + this.getRenderer() + " because of permissions.", e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected Class<? extends BaseBlockRender> getRenderer() {
        return BaseBlockRender.class;
    }

    public IIcon unmappedGetIcon(IBlockAccess w, int x, int y, int z, int s) {
        return super.getIcon(w, x, y, z, s);
    }

    protected void setTileEntity(Class<? extends TileEntity> c) {
        this.tileEntityType = c;
        AEBaseTile.registerTileItem(c, new ItemStackSrc((Block)this, 0));
        GameRegistry.registerTileEntity(this.tileEntityType, (String)this.featureFullName);
        this.isInventory = IInventory.class.isAssignableFrom(c);
        this.setTileProvider(this.hasBlockTileEntity());
    }

    public boolean hasBlockTileEntity() {
        return this.tileEntityType != null;
    }

    protected void setFeature(EnumSet<AEFeature> f) {
        this.handler = new AEBlockFeatureHandler(f, this, this.featureSubName);
    }

    @Override
    public final IFeatureHandler handler() {
        return this.handler;
    }

    @Override
    public void postInit() {
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public boolean renderAsNormalBlock() {
        return this.isFullSize && this.isOpaque;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderType() {
        return WorldRender.INSTANCE.getRenderId();
    }

    public IIcon getIcon(IBlockAccess w, int x, int y, int z, int s) {
        return this.getIcon(this.mapRotation(w, x, y, z, s), w.getBlockMetadata(x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int direction, int metadata) {
        if (this.renderIcon != null) {
            return this.renderIcon;
        }
        return this.getRendererInstance().getTexture(ForgeDirection.getOrientation((int)direction));
    }

    public void addCollisionBoxesToList(World w, int x, int y, int z, AxisAlignedBB bb, List out, Entity e) {
        ICustomCollision collisionHandler = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null && bb != null) {
            ArrayList<AxisAlignedBB> tmp = new ArrayList<AxisAlignedBB>();
            collisionHandler.addCollidingBlockToList(w, x, y, z, bb, tmp, e);
            for (AxisAlignedBB b : tmp) {
                b.minX += (double)x;
                b.minY += (double)y;
                b.minZ += (double)z;
                b.maxX += (double)x;
                b.maxY += (double)y;
                b.maxZ += (double)z;
                if (!bb.intersectsWith(b)) continue;
                out.add(b);
            }
        } else {
            super.addCollisionBoxesToList(w, x, y, z, bb, out, e);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final AxisAlignedBB getSelectedBoundingBoxFromPool(World w, int x, int y, int z) {
        ICustomCollision collisionHandler = null;
        AxisAlignedBB b = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null) {
            if (Platform.isClient()) {
                EntityClientPlayerMP player = Minecraft.getMinecraft().thePlayer;
                LookDirection ld = Platform.getPlayerRay((EntityPlayer)player, Platform.getEyeOffset((EntityPlayer)player));
                Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, (Entity)Minecraft.getMinecraft().thePlayer, true);
                AxisAlignedBB br = null;
                double lastDist = 0.0;
                for (AxisAlignedBB bb : bbs) {
                    this.setBlockBounds((float)bb.minX, (float)bb.minY, (float)bb.minZ, (float)bb.maxX, (float)bb.maxY, (float)bb.maxZ);
                    MovingObjectPosition r = super.collisionRayTrace(w, x, y, z, ld.a, ld.b);
                    this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    if (r == null) continue;
                    double xLen = ld.a.xCoord - r.hitVec.xCoord;
                    double yLen = ld.a.yCoord - r.hitVec.yCoord;
                    double zLen = ld.a.zCoord - r.hitVec.zCoord;
                    double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                    if (br != null && !(lastDist > thisDist)) continue;
                    lastDist = thisDist;
                    br = bb;
                }
                if (br != null) {
                    br.setBounds(br.minX + (double)x, br.minY + (double)y, br.minZ + (double)z, br.maxX + (double)x, br.maxY + (double)y, br.maxZ + (double)z);
                    return br;
                }
            }
            for (AxisAlignedBB bx : collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, null, false)) {
                if (b == null) {
                    b = bx;
                    continue;
                }
                double minX = Math.min(b.minX, bx.minX);
                double minY = Math.min(b.minY, bx.minY);
                double minZ = Math.min(b.minZ, bx.minZ);
                double maxX = Math.max(b.maxX, bx.maxX);
                double maxY = Math.max(b.maxY, bx.maxY);
                double maxZ = Math.max(b.maxZ, bx.maxZ);
                b.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
            }
            b.setBounds(b.minX + (double)x, b.minY + (double)y, b.minZ + (double)z, b.maxX + (double)x, b.maxY + (double)y, b.maxZ + (double)z);
        } else {
            b = super.getSelectedBoundingBoxFromPool(w, x, y, z);
        }
        return b;
    }

    public final boolean isOpaqueCube() {
        return this.isOpaque;
    }

    public MovingObjectPosition collisionRayTrace(World w, int x, int y, int z, Vec3 a, Vec3 b) {
        ICustomCollision collisionHandler = null;
        if (this instanceof ICustomCollision) {
            collisionHandler = (ICustomCollision)((Object)this);
        } else {
            AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
            if (te instanceof ICustomCollision) {
                collisionHandler = (ICustomCollision)((Object)te);
            }
        }
        if (collisionHandler != null) {
            Iterable<AxisAlignedBB> bbs = collisionHandler.getSelectedBoundingBoxesFromPool(w, x, y, z, null, true);
            MovingObjectPosition br = null;
            double lastDist = 0.0;
            for (AxisAlignedBB bb : bbs) {
                this.setBlockBounds((float)bb.minX, (float)bb.minY, (float)bb.minZ, (float)bb.maxX, (float)bb.maxY, (float)bb.maxZ);
                MovingObjectPosition r = super.collisionRayTrace(w, x, y, z, a, b);
                this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                if (r == null) continue;
                double xLen = a.xCoord - r.hitVec.xCoord;
                double yLen = a.yCoord - r.hitVec.yCoord;
                double zLen = a.zCoord - r.hitVec.zCoord;
                double thisDist = xLen * xLen + yLen * yLen + zLen * zLen;
                if (br != null && !(lastDist > thisDist)) continue;
                lastDist = thisDist;
                br = r;
            }
            if (br != null) {
                return br;
            }
            return null;
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.collisionRayTrace(w, x, y, z, a, b);
    }

    public final boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack is;
        if (player != null && (is = player.inventory.getCurrentItem()) != null) {
            if (Platform.isWrench(player, is, x, y, z) && player.isSneaking()) {
                Block id = w.getBlock(x, y, z);
                if (id != null) {
                    AEBaseTile tile = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                    Object[] drops = Platform.getBlockDrops(w, x, y, z);
                    if (tile == null) {
                        return false;
                    }
                    if (tile instanceof TileCableBus || tile instanceof TileSkyChest) {
                        return false;
                    }
                    ItemStack op = new ItemStack((Block)this);
                    for (ItemStack itemStack : drops) {
                        NBTTagCompound tag;
                        if (!Platform.isSameItemType(itemStack, op) || (tag = tile.downloadSettings(SettingsFrom.DISMANTLE_ITEM)) == null) continue;
                        itemStack.setTagCompound(tag);
                    }
                    if (id.removedByPlayer(w, player, x, y, z, false)) {
                        ArrayList l = Lists.newArrayList((Object[])drops);
                        Platform.spawnDrops(w, x, y, z, l);
                        w.setBlockToAir(x, y, z);
                    }
                }
                return false;
            }
            if (is.getItem() instanceof IMemoryCard && !(this instanceof BlockCableBus)) {
                IMemoryCard memoryCard = (IMemoryCard)is.getItem();
                if (player.isSneaking()) {
                    AEBaseTile t = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                    if (t != null) {
                        String name = this.getUnlocalizedName();
                        NBTTagCompound data = t.downloadSettings(SettingsFrom.MEMORY_CARD);
                        if (data != null) {
                            memoryCard.setMemoryCardContents(is, name, data);
                            memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
                            return true;
                        }
                    }
                } else {
                    String name = memoryCard.getSettingsName(is);
                    NBTTagCompound data = memoryCard.getData(is);
                    if (this.getUnlocalizedName().equals(name)) {
                        AEBaseTile t = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
                        t.uploadSettings(SettingsFrom.MEMORY_CARD, data);
                        memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                    } else {
                        memoryCard.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
                    }
                    return false;
                }
            }
        }
        return this.onActivated(w, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onBlockPlacedBy(World w, int x, int y, int z, EntityLivingBase player, ItemStack is) {
        Object te;
        if (is.hasDisplayName() && (te = this.getTileEntity((IBlockAccess)w, x, y, z)) instanceof AEBaseTile) {
            ((AEBaseTile)w.getTileEntity(x, y, z)).setName(is.getDisplayName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void getSubBlocks(Item item, CreativeTabs tabs, List itemStacks) {
        this.getCheckedSubBlocks(item, tabs, itemStacks);
    }

    public boolean hasComparatorInputOverride() {
        return this.isInventory;
    }

    public int getComparatorInputOverride(World w, int x, int y, int z, int s) {
        Object te = this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te instanceof IInventory) {
            return Container.calcRedstoneFromInventory((IInventory)((IInventory)te));
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegistry) {
        BlockRenderInfo info = this.getRendererInstance();
        FlippableIcon topIcon = this.optionalIcon(iconRegistry, this.getTextureName(), null);
        this.blockIcon = topIcon;
        FlippableIcon bottomIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "Bottom", topIcon);
        FlippableIcon sideIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "Side", topIcon);
        FlippableIcon eastIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "East", sideIcon);
        FlippableIcon westIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "West", sideIcon);
        FlippableIcon southIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "Front", sideIcon);
        FlippableIcon northIcon = this.optionalIcon(iconRegistry, this.getTextureName() + "Back", sideIcon);
        info.updateIcons(bottomIcon, topIcon, northIcon, southIcon, eastIcon, westIcon);
    }

    public final boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return this.isFullSize;
    }

    public final boolean rotateBlock(World w, int x, int y, int z, ForgeDirection axis) {
        IOrientable rotatable = null;
        if (this.hasBlockTileEntity()) {
            rotatable = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        } else if (this instanceof IOrientableBlock) {
            rotatable = ((IOrientableBlock)((Object)this)).getOrientable((IBlockAccess)w, x, y, z);
        }
        if (rotatable != null && rotatable.canBeRotated()) {
            if (this.hasCustomRotation()) {
                this.customRotateBlock(rotatable, axis);
                return true;
            }
            ForgeDirection forward = rotatable.getForward();
            ForgeDirection up = rotatable.getUp();
            for (int rs = 0; rs < 4; ++rs) {
                if (!this.isValidOrientation(w, x, y, z, forward = Platform.rotateAround(forward, axis), up = Platform.rotateAround(up, axis))) continue;
                rotatable.setOrientation(forward, up);
                return true;
            }
        }
        return super.rotateBlock(w, x, y, z, axis);
    }

    protected boolean hasCustomRotation() {
        return false;
    }

    protected void customRotateBlock(IOrientable rotatable, ForgeDirection axis) {
    }

    public boolean isValidOrientation(World w, int x, int y, int z, ForgeDirection forward, ForgeDirection up) {
        return true;
    }

    public final ForgeDirection[] getValidRotations(World w, int x, int y, int z) {
        AEBaseTile obj;
        if (this.hasBlockTileEntity() && (obj = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z)) != null && obj.canBeRotated()) {
            return ForgeDirection.VALID_DIRECTIONS;
        }
        return new ForgeDirection[0];
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        Object te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te instanceof IColorableTile) {
            AEColor newColor;
            IColorableTile ct = (IColorableTile)te;
            AEColor c = ct.getColor();
            if (c != (newColor = AEColor.values()[colour])) {
                ct.recolourBlock(side, newColor, null);
                return true;
            }
            return false;
        }
        return super.recolourBlock(world, x, y, z, side, colour);
    }

    @SideOnly(value=Side.CLIENT)
    private FlippableIcon optionalIcon(IIconRegister ir, String Name, IIcon substitute) {
        while (substitute instanceof FlippableIcon) {
            substitute = ((FlippableIcon)substitute).getOriginal();
        }
        if (substitute != null) {
            try {
                ResourceLocation resLoc = new ResourceLocation(Name);
                resLoc = new ResourceLocation(resLoc.getResourceDomain(), String.format("%s/%s%s", "textures/blocks", resLoc.getResourcePath(), ".png"));
                IResource res = Minecraft.getMinecraft().getResourceManager().getResource(resLoc);
                if (res != null) {
                    return new FlippableIcon(ir.registerIcon(Name));
                }
            }
            catch (Throwable e) {
                return new FlippableIcon(substitute);
            }
        }
        return new FlippableIcon(ir.registerIcon(Name));
    }

    @SideOnly(value=Side.CLIENT)
    public void getCheckedSubBlocks(Item item, CreativeTabs tabs, List<ItemStack> itemStacks) {
        super.getSubBlocks(item, tabs, itemStacks);
    }

    int mapRotation(IBlockAccess w, int x, int y, int z, int s) {
        IOrientable ori = null;
        if (this.hasBlockTileEntity()) {
            ori = (AEBaseTile)this.getTileEntity(w, x, y, z);
        } else if (this instanceof IOrientableBlock) {
            ori = ((IOrientableBlock)((Object)this)).getOrientable(w, x, y, z);
        }
        if (ori != null && ori.canBeRotated()) {
            return this.mapRotation(ori, ForgeDirection.getOrientation((int)s)).ordinal();
        }
        return s;
    }

    @Nullable
    public <T extends TileEntity> T getTileEntity(IBlockAccess w, int x, int y, int z) {
        if (!this.hasBlockTileEntity()) {
            return null;
        }
        TileEntity te = w.getTileEntity(x, y, z);
        if (this.tileEntityType.isInstance(te)) {
            return (T)te;
        }
        return null;
    }

    public ForgeDirection mapRotation(IOrientable ori, ForgeDirection dir) {
        ForgeDirection forward = ori.getForward();
        ForgeDirection up = ori.getUp();
        ForgeDirection west = ForgeDirection.UNKNOWN;
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        for (ForgeDirection dx : ForgeDirection.VALID_DIRECTIONS) {
            if (dx.offsetX != west_x || dx.offsetY != west_y || dx.offsetZ != west_z) continue;
            west = dx;
        }
        if (dir == forward) {
            return ForgeDirection.SOUTH;
        }
        if (dir == forward.getOpposite()) {
            return ForgeDirection.NORTH;
        }
        if (dir == up) {
            return ForgeDirection.UP;
        }
        if (dir == up.getOpposite()) {
            return ForgeDirection.DOWN;
        }
        if (dir == west) {
            return ForgeDirection.WEST;
        }
        if (dir == west.getOpposite()) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    public Class<? extends TileEntity> getTileEntityClass() {
        return this.tileEntityType;
    }

    @SideOnly(value=Side.CLIENT)
    public void setRenderStateByMeta(int itemDamage) {
    }

    public final TileEntity createNewTileEntity(World var1, int var2) {
        if (this.hasBlockTileEntity()) {
            try {
                return this.tileEntityType.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Failed to create a new instance of an illegal class " + this.tileEntityType, e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to create a new instance of " + this.tileEntityType + ", because lack of permissions", e);
            }
        }
        return null;
    }

    public void breakBlock(World w, int x, int y, int z, Block a, int b) {
        AEBaseTile te = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (te != null) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            if (te.dropItems()) {
                te.getDrops(w, x, y, z, drops);
            } else {
                te.getNoDrops(w, x, y, z, drops);
            }
            Platform.spawnDrops(w, x, y, z, drops);
        }
        super.breakBlock(w, x, y, z, a, b);
        if (te != null) {
            w.setTileEntity(x, y, z, null);
        }
    }

    public String getUnlocalizedName(ItemStack is) {
        return this.getUnlocalizedName();
    }

    public void addInformation(ItemStack is, EntityPlayer player, List<String> lines, boolean advancedItemTooltips) {
    }

    public Class<? extends AEBaseItemBlock> getItemBlockClass() {
        return AEBaseItemBlock.class;
    }

    public boolean hasSubtypes() {
        return this.hasSubtypes;
    }
}

