/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.AEApi;
import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderBlockCharger;
import appeng.client.render.effects.LightningFX;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.helpers.ICustomCollision;
import appeng.tile.AEBaseTile;
import appeng.tile.misc.TileCharger;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCharger
extends AEBaseBlock
implements ICustomCollision {
    public BlockCharger() {
        super(BlockCharger.class, Material.iron);
        this.setTileEntity(TileCharger.class);
        this.setLightOpacity(2);
        this.isOpaque = false;
        this.isFullSize = false;
        this.setFeature(EnumSet.of(AEFeature.Core));
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderBlockCharger.class;
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileCharger tc;
        if (player.isSneaking()) {
            return false;
        }
        if (Platform.isServer() && (tc = (TileCharger)this.getTileEntity((IBlockAccess)w, x, y, z)) != null) {
            tc.activate(player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World w, int x, int y, int z, Random r) {
        if (!AEConfig.instance.enableEffects) {
            return;
        }
        if ((double)r.nextFloat() < 0.98) {
            return;
        }
        AEBaseTile tile = (AEBaseTile)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile instanceof TileCharger) {
            TileCharger tc = (TileCharger)tile;
            if (AEApi.instance().definitions().materials().certusQuartzCrystalCharged().isSameAs(tc.getStackInSlot(0))) {
                double xOff = 0.0;
                double yOff = 0.0;
                double zOff = 0.0;
                for (int bolts = 0; bolts < 3; ++bolts) {
                    if (!CommonHelper.proxy.shouldAddParticles(r)) continue;
                    LightningFX fx = new LightningFX(w, xOff + 0.5 + (double)x, yOff + 0.5 + (double)y, zOff + 0.5 + (double)z, 0.0, 0.0, 0.0);
                    Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)fx);
                }
            }
        }
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        TileCharger tile = (TileCharger)this.getTileEntity((IBlockAccess)w, x, y, z);
        if (tile != null) {
            double twoPixels = 0.125;
            ForgeDirection up = tile.getUp();
            ForgeDirection forward = tile.getForward();
            AxisAlignedBB bb = AxisAlignedBB.getBoundingBox((double)twoPixels, (double)twoPixels, (double)twoPixels, (double)(1.0 - twoPixels), (double)(1.0 - twoPixels), (double)(1.0 - twoPixels));
            if (up.offsetX != 0) {
                bb.minX = 0.0;
                bb.maxX = 1.0;
            }
            if (up.offsetY != 0) {
                bb.minY = 0.0;
                bb.maxY = 1.0;
            }
            if (up.offsetZ != 0) {
                bb.minZ = 0.0;
                bb.maxZ = 1.0;
            }
            switch (forward) {
                case DOWN: {
                    bb.maxY = 1.0;
                    break;
                }
                case UP: {
                    bb.minY = 0.0;
                    break;
                }
                case NORTH: {
                    bb.maxZ = 1.0;
                    break;
                }
                case SOUTH: {
                    bb.minZ = 0.0;
                    break;
                }
                case EAST: {
                    bb.minX = 0.0;
                    break;
                }
                case WEST: {
                    bb.maxX = 1.0;
                    break;
                }
            }
            return Collections.singletonList(bb);
        }
        return Collections.singletonList(AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        out.add(AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
    }
}

