/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.blocks.RenderTinyTNT;
import appeng.client.texture.FullIcon;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.entity.EntityTinyTNTPrimed;
import appeng.helpers.ICustomCollision;
import appeng.hooks.DispenserBehaviorTinyTNT;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockTinyTNT
extends AEBaseBlock
implements ICustomCollision {
    public BlockTinyTNT() {
        super(BlockTinyTNT.class, Material.tnt);
        this.setLightOpacity(1);
        this.setBlockBounds(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
        this.isOpaque = false;
        this.isFullSize = false;
        this.setStepSound(soundTypeGrass);
        this.setHardness(0.0f);
        this.setFeature(EnumSet.of(AEFeature.TinyTNT));
        EntityRegistry.registerModEntity(EntityTinyTNTPrimed.class, (String)"EntityTinyTNTPrimed", (int)10, (Object)AppEng.instance, (int)16, (int)4, (boolean)true);
    }

    @Override
    protected Class<? extends BaseBlockRender> getRenderer() {
        return RenderTinyTNT.class;
    }

    @Override
    public void postInit() {
        super.postInit();
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)Item.getItemFromBlock((Block)this), (Object)new DispenserBehaviorTinyTNT());
    }

    @Override
    public IIcon getIcon(int direction, int metadata) {
        return new FullIcon(Blocks.tnt.getIcon(direction, metadata));
    }

    @Override
    public boolean onActivated(World w, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() == Items.flint_and_steel) {
            this.startFuse(w, x, y, z, (EntityLivingBase)player);
            w.setBlockToAir(x, y, z);
            player.getCurrentEquippedItem().damageItem(1, (EntityLivingBase)player);
            return true;
        }
        return super.onActivated(w, x, y, z, player, side, hitX, hitY, hitZ);
    }

    @Override
    public void registerBlockIcons(IIconRegister iconRegistry) {
    }

    public void startFuse(World w, int x, int y, int z, EntityLivingBase igniter) {
        if (!w.isRemote) {
            EntityTinyTNTPrimed primedTinyTNTEntity = new EntityTinyTNTPrimed(w, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, igniter);
            w.spawnEntityInWorld((Entity)primedTinyTNTEntity);
            w.playSoundAtEntity((Entity)primedTinyTNTEntity, "game.tnt.primed", 1.0f, 1.0f);
        }
    }

    public void onBlockAdded(World w, int x, int y, int z) {
        super.onBlockAdded(w, x, y, z);
        if (w.isBlockIndirectlyGettingPowered(x, y, z)) {
            this.startFuse(w, x, y, z, null);
            w.setBlockToAir(x, y, z);
        }
    }

    public void onNeighborBlockChange(World w, int x, int y, int z, Block id) {
        if (w.isBlockIndirectlyGettingPowered(x, y, z)) {
            this.startFuse(w, x, y, z, null);
            w.setBlockToAir(x, y, z);
        }
    }

    public void onBlockDestroyedByExplosion(World w, int x, int y, int z, Explosion exp) {
        if (!w.isRemote) {
            EntityTinyTNTPrimed primedTinyTNTEntity = new EntityTinyTNTPrimed(w, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, exp.getExplosivePlacedBy());
            primedTinyTNTEntity.fuse = w.rand.nextInt(primedTinyTNTEntity.fuse / 4) + primedTinyTNTEntity.fuse / 8;
            w.spawnEntityInWorld((Entity)primedTinyTNTEntity);
        }
    }

    public void onEntityCollidedWithBlock(World w, int x, int y, int z, Entity entity) {
        EntityArrow entityarrow;
        if (entity instanceof EntityArrow && !w.isRemote && (entityarrow = (EntityArrow)entity).isBurning()) {
            this.startFuse(w, x, y, z, entityarrow.shootingEntity instanceof EntityLivingBase ? (EntityLivingBase)entityarrow.shootingEntity : null);
            w.setBlockToAir(x, y, z);
        }
    }

    public boolean canDropFromExplosion(Explosion exp) {
        return false;
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, int x, int y, int z, Entity e, boolean isVisual) {
        return Collections.singletonList(AxisAlignedBB.getBoundingBox((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75));
    }

    @Override
    public void addCollidingBlockToList(World w, int x, int y, int z, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
        out.add(AxisAlignedBB.getBoundingBox((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75));
    }
}

