/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.LevelType;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.client.gui.implementations.GuiUpgradeable;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiNumberBox;
import appeng.container.implementations.ContainerLevelEmitter;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.parts.automation.PartLevelEmitter;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Mouse;

public class GuiLevelEmitter
extends GuiUpgradeable {
    GuiNumberBox level;
    GuiButton plus1;
    GuiButton plus10;
    GuiButton plus100;
    GuiButton plus1000;
    GuiButton minus1;
    GuiButton minus10;
    GuiButton minus100;
    GuiButton minus1000;
    GuiImgButton levelMode;
    GuiImgButton craftingMode;

    public GuiLevelEmitter(InventoryPlayer inventoryPlayer, PartLevelEmitter te) {
        super(new ContainerLevelEmitter(inventoryPlayer, te));
    }

    @Override
    public void initGui() {
        super.initGui();
        this.level = new GuiNumberBox(this.fontRendererObj, this.guiLeft + 24, this.guiTop + 43, 79, this.fontRendererObj.FONT_HEIGHT, Long.class);
        this.level.setEnableBackgroundDrawing(false);
        this.level.setMaxStringLength(16);
        this.level.setTextColor(0xFFFFFF);
        this.level.setVisible(true);
        this.level.setFocused(true);
        ((ContainerLevelEmitter)this.inventorySlots).setTextField(this.level);
    }

    @Override
    protected void addButtons() {
        this.levelMode = new GuiImgButton(this.guiLeft - 18, this.guiTop + 8, Settings.LEVEL_TYPE, LevelType.ITEM_LEVEL);
        this.redstoneMode = new GuiImgButton(this.guiLeft - 18, this.guiTop + 28, Settings.REDSTONE_EMITTER, RedstoneMode.LOW_SIGNAL);
        this.fuzzyMode = new GuiImgButton(this.guiLeft - 18, this.guiTop + 48, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.craftingMode = new GuiImgButton(this.guiLeft - 18, this.guiTop + 48, Settings.CRAFT_VIA_REDSTONE, YesNo.NO);
        int a = AEConfig.instance.levelByStackAmounts(0);
        int b = AEConfig.instance.levelByStackAmounts(1);
        int c = AEConfig.instance.levelByStackAmounts(2);
        int d = AEConfig.instance.levelByStackAmounts(3);
        this.plus1 = new GuiButton(0, this.guiLeft + 20, this.guiTop + 17, 22, 20, "+" + a);
        this.buttonList.add(this.plus1);
        this.plus10 = new GuiButton(0, this.guiLeft + 48, this.guiTop + 17, 28, 20, "+" + b);
        this.buttonList.add(this.plus10);
        this.plus100 = new GuiButton(0, this.guiLeft + 82, this.guiTop + 17, 32, 20, "+" + c);
        this.buttonList.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.guiLeft + 120, this.guiTop + 17, 38, 20, "+" + d);
        this.buttonList.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.guiLeft + 20, this.guiTop + 59, 22, 20, "-" + a);
        this.buttonList.add(this.minus1);
        this.minus10 = new GuiButton(0, this.guiLeft + 48, this.guiTop + 59, 28, 20, "-" + b);
        this.buttonList.add(this.minus10);
        this.minus100 = new GuiButton(0, this.guiLeft + 82, this.guiTop + 59, 32, 20, "-" + c);
        this.buttonList.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.guiLeft + 120, this.guiTop + 59, 38, 20, "-" + d);
        this.buttonList.add(this.minus1000);
        this.buttonList.add(this.levelMode);
        this.buttonList.add(this.redstoneMode);
        this.buttonList.add(this.fuzzyMode);
        this.buttonList.add(this.craftingMode);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        boolean notCraftingMode = this.bc.getInstalledUpgrades(Upgrades.CRAFTING) == 0;
        this.level.setEnabled(notCraftingMode);
        this.plus1.enabled = notCraftingMode;
        this.plus10.enabled = notCraftingMode;
        this.plus100.enabled = notCraftingMode;
        this.plus1000.enabled = notCraftingMode;
        this.minus1.enabled = notCraftingMode;
        this.minus10.enabled = notCraftingMode;
        this.minus100.enabled = notCraftingMode;
        this.minus1000.enabled = notCraftingMode;
        this.levelMode.enabled = notCraftingMode;
        this.redstoneMode.enabled = notCraftingMode;
        super.drawFG(offsetX, offsetY, mouseX, mouseY);
        if (this.craftingMode != null) {
            this.craftingMode.set(((ContainerLevelEmitter)this.cvb).cmType);
        }
        if (this.levelMode != null) {
            this.levelMode.set(((ContainerLevelEmitter)this.cvb).lvType);
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        super.drawBG(offsetX, offsetY, mouseX, mouseY);
        this.level.drawTextBox();
    }

    @Override
    protected void handleButtonVisibility() {
        this.craftingMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
    }

    @Override
    protected String getBackground() {
        return "guis/lvlemitter.png";
    }

    @Override
    protected GuiText getName() {
        return GuiText.LevelEmitter;
    }

    @Override
    protected void actionPerformed(GuiButton btn) {
        boolean isMinus;
        super.actionPerformed(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.craftingMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.craftingMode.getSetting(), backwards));
        }
        if (btn == this.levelMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.levelMode.getSetting(), backwards));
        }
        boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
        boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
        if (isPlus || isMinus) {
            this.addQty(this.getQty(btn));
        }
    }

    private void addQty(long i) {
        try {
            String Out = this.level.getText();
            boolean Fixed = false;
            while (Out.startsWith("0") && Out.length() > 1) {
                Out = Out.substring(1);
                Fixed = true;
            }
            if (Fixed) {
                this.level.setText(Out);
            }
            if (Out.length() == 0) {
                Out = "0";
            }
            long result = Long.parseLong(Out);
            if ((result += i) < 0L) {
                result = 0L;
            }
            Out = Long.toString(result);
            this.level.setText(Out);
            NetworkHandler.instance.sendToServer(new PacketValueConfig("LevelEmitter.Value", Out));
        }
        catch (NumberFormatException e) {
            this.level.setText("0");
        }
        catch (IOException e) {
            AELog.error(e);
        }
    }

    protected void keyTyped(char character, int key) {
        if (!this.checkHotbarKeys(key)) {
            if ((key == 211 || key == 205 || key == 203 || key == 14 || Character.isDigit(character)) && this.level.textboxKeyTyped(character, key)) {
                try {
                    String Out = this.level.getText();
                    boolean Fixed = false;
                    while (Out.startsWith("0") && Out.length() > 1) {
                        Out = Out.substring(1);
                        Fixed = true;
                    }
                    if (Fixed) {
                        this.level.setText(Out);
                    }
                    if (Out.length() == 0) {
                        Out = "0";
                    }
                    NetworkHandler.instance.sendToServer(new PacketValueConfig("LevelEmitter.Value", Out));
                }
                catch (IOException e) {
                    AELog.error(e);
                }
            } else {
                super.keyTyped(character, key);
            }
        }
    }
}

