/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiNumberBox;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerPriority;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.IPriorityHost;
import appeng.parts.automation.PartFormationPlane;
import appeng.parts.misc.PartInterface;
import appeng.parts.misc.PartStorageBus;
import appeng.tile.misc.TileInterface;
import appeng.tile.storage.TileChest;
import appeng.tile.storage.TileDrive;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class GuiPriority
extends AEBaseGui {
    GuiNumberBox priority;
    GuiTabButton originalGuiBtn;
    GuiButton plus1;
    GuiButton plus10;
    GuiButton plus100;
    GuiButton plus1000;
    GuiButton minus1;
    GuiButton minus10;
    GuiButton minus100;
    GuiButton minus1000;
    GuiBridge OriginalGui;

    public GuiPriority(InventoryPlayer inventoryPlayer, IPriorityHost te) {
        super(new ContainerPriority(inventoryPlayer, te));
    }

    @Override
    public void initGui() {
        ItemStack interfaceStack;
        Iterator i$;
        super.initGui();
        int a = AEConfig.instance.priorityByStacksAmounts(0);
        int b = AEConfig.instance.priorityByStacksAmounts(1);
        int c = AEConfig.instance.priorityByStacksAmounts(2);
        int d = AEConfig.instance.priorityByStacksAmounts(3);
        this.plus1 = new GuiButton(0, this.guiLeft + 20, this.guiTop + 32, 22, 20, "+" + a);
        this.buttonList.add(this.plus1);
        this.plus10 = new GuiButton(0, this.guiLeft + 48, this.guiTop + 32, 28, 20, "+" + b);
        this.buttonList.add(this.plus10);
        this.plus100 = new GuiButton(0, this.guiLeft + 82, this.guiTop + 32, 32, 20, "+" + c);
        this.buttonList.add(this.plus100);
        this.plus1000 = new GuiButton(0, this.guiLeft + 120, this.guiTop + 32, 38, 20, "+" + d);
        this.buttonList.add(this.plus1000);
        this.minus1 = new GuiButton(0, this.guiLeft + 20, this.guiTop + 69, 22, 20, "-" + a);
        this.buttonList.add(this.minus1);
        this.minus10 = new GuiButton(0, this.guiLeft + 48, this.guiTop + 69, 28, 20, "-" + b);
        this.buttonList.add(this.minus10);
        this.minus100 = new GuiButton(0, this.guiLeft + 82, this.guiTop + 69, 32, 20, "-" + c);
        this.buttonList.add(this.minus100);
        this.minus1000 = new GuiButton(0, this.guiLeft + 120, this.guiTop + 69, 38, 20, "-" + d);
        this.buttonList.add(this.minus1000);
        ItemStack myIcon = null;
        Object target = ((AEBaseContainer)this.inventorySlots).getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        IBlocks blocks = definitions.blocks();
        if (target instanceof PartStorageBus) {
            i$ = parts.storageBus().maybeStack(1).asSet().iterator();
            while (i$.hasNext()) {
                ItemStack storageBusStack;
                myIcon = storageBusStack = (ItemStack)i$.next();
            }
            this.OriginalGui = GuiBridge.GUI_STORAGEBUS;
        }
        if (target instanceof PartFormationPlane) {
            i$ = parts.formationPlane().maybeStack(1).asSet().iterator();
            while (i$.hasNext()) {
                ItemStack formationPlaneStack;
                myIcon = formationPlaneStack = (ItemStack)i$.next();
            }
            this.OriginalGui = GuiBridge.GUI_FORMATION_PLANE;
        }
        if (target instanceof TileDrive) {
            i$ = blocks.drive().maybeStack(1).asSet().iterator();
            while (i$.hasNext()) {
                ItemStack driveStack;
                myIcon = driveStack = (ItemStack)i$.next();
            }
            this.OriginalGui = GuiBridge.GUI_DRIVE;
        }
        if (target instanceof TileChest) {
            i$ = blocks.chest().maybeStack(1).asSet().iterator();
            while (i$.hasNext()) {
                ItemStack chestStack;
                myIcon = chestStack = (ItemStack)i$.next();
            }
            this.OriginalGui = GuiBridge.GUI_CHEST;
        }
        if (target instanceof TileInterface) {
            i$ = blocks.iface().maybeStack(1).asSet().iterator();
            while (i$.hasNext()) {
                myIcon = interfaceStack = (ItemStack)i$.next();
            }
            this.OriginalGui = GuiBridge.GUI_INTERFACE;
        }
        if (target instanceof PartInterface) {
            i$ = parts.iface().maybeStack(1).asSet().iterator();
            while (i$.hasNext()) {
                myIcon = interfaceStack = (ItemStack)i$.next();
            }
            this.OriginalGui = GuiBridge.GUI_INTERFACE;
        }
        if (this.OriginalGui != null && myIcon != null) {
            this.originalGuiBtn = new GuiTabButton(this.guiLeft + 154, this.guiTop, myIcon, myIcon.getDisplayName(), itemRender);
            this.buttonList.add(this.originalGuiBtn);
        }
        this.priority = new GuiNumberBox(this.fontRendererObj, this.guiLeft + 62, this.guiTop + 57, 59, this.fontRendererObj.FONT_HEIGHT, Long.class);
        this.priority.setEnableBackgroundDrawing(false);
        this.priority.setMaxStringLength(16);
        this.priority.setTextColor(0xFFFFFF);
        this.priority.setVisible(true);
        this.priority.setFocused(true);
        ((ContainerPriority)this.inventorySlots).setTextField(this.priority);
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.fontRendererObj.drawString(GuiText.Priority.getLocal(), 8, 6, 0x404040);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/priority.png");
        this.drawTexturedModalRect(offsetX, offsetY, 0, 0, this.xSize, this.ySize);
        this.priority.drawTextBox();
    }

    protected void actionPerformed(GuiButton btn) {
        boolean isMinus;
        super.actionPerformed(btn);
        if (btn == this.originalGuiBtn) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.OriginalGui));
        }
        boolean isPlus = btn == this.plus1 || btn == this.plus10 || btn == this.plus100 || btn == this.plus1000;
        boolean bl = isMinus = btn == this.minus1 || btn == this.minus10 || btn == this.minus100 || btn == this.minus1000;
        if (isPlus || isMinus) {
            this.addQty(this.getQty(btn));
        }
    }

    private void addQty(int i) {
        try {
            String out = this.priority.getText();
            boolean fixed = false;
            while (out.startsWith("0") && out.length() > 1) {
                out = out.substring(1);
                fixed = true;
            }
            if (fixed) {
                this.priority.setText(out);
            }
            if (out.length() == 0) {
                out = "0";
            }
            long result = Long.parseLong(out);
            out = Long.toString(result += (long)i);
            this.priority.setText(out);
            NetworkHandler.instance.sendToServer(new PacketValueConfig("PriorityHost.Priority", out));
        }
        catch (NumberFormatException e) {
            this.priority.setText("0");
        }
        catch (IOException e) {
            AELog.error(e);
        }
    }

    protected void keyTyped(char character, int key) {
        if (!this.checkHotbarKeys(key)) {
            if ((key == 211 || key == 205 || key == 203 || key == 14 || character == '-' || Character.isDigit(character)) && this.priority.textboxKeyTyped(character, key)) {
                try {
                    String out = this.priority.getText();
                    boolean fixed = false;
                    while (out.startsWith("0") && out.length() > 1) {
                        out = out.substring(1);
                        fixed = true;
                    }
                    if (fixed) {
                        this.priority.setText(out);
                    }
                    if (out.length() == 0) {
                        out = "0";
                    }
                    NetworkHandler.instance.sendToServer(new PacketValueConfig("PriorityHost.Priority", out));
                }
                catch (IOException e) {
                    AELog.error(e);
                }
            } else {
                super.keyTyped(character, key);
            }
        }
    }

    protected String getBackground() {
        return "guis/priority.png";
    }
}

