/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.texture.ExtraBlockTextures;
import appeng.helpers.Splotch;
import appeng.tile.misc.TilePaint;
import java.util.EnumSet;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderBlockPaint
extends BaseBlockRender {
    public RenderBlockPaint() {
        super(false, 0.0);
    }

    @Override
    public void renderInventory(AEBaseBlock block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
    }

    @Override
    public boolean renderInWorld(AEBaseBlock imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        TilePaint tp = (TilePaint)imb.getTileEntity(world, x, y, z);
        boolean out = false;
        if (tp != null) {
            IIcon[] icoSet = new IIcon[]{imb.getIcon(0, 0), ExtraBlockTextures.BlockPaint2.getIcon(), ExtraBlockTextures.BlockPaint3.getIcon()};
            Tessellator tess = Tessellator.instance;
            int lumen = 0xE000E0;
            int brightness = imb.getMixedBrightnessForBlock(world, x, y, z);
            double offsetConstant = 0.001;
            EnumSet<ForgeDirection> validSides = EnumSet.noneOf(ForgeDirection.class);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (!tp.isSideValid(side)) continue;
                validSides.add(side);
            }
            for (Splotch s : tp.getDots()) {
                if (!validSides.contains(s.side)) continue;
                if (s.lumen) {
                    tess.setColorOpaque_I(s.color.whiteVariant);
                    tess.setBrightness(lumen);
                } else {
                    tess.setColorOpaque_I(s.color.mediumVariant);
                    tess.setBrightness(brightness);
                }
                double offset = offsetConstant;
                offsetConstant += 0.001;
                double H = 0.1;
                double pos_x = s.x();
                double pos_y = s.y();
                pos_x = Math.max(H, Math.min(1.0 - H, pos_x));
                pos_y = Math.max(H, Math.min(1.0 - H, pos_y));
                if (s.side == ForgeDirection.SOUTH || s.side == ForgeDirection.NORTH) {
                    pos_x += (double)x;
                    pos_y += (double)y;
                } else if (s.side == ForgeDirection.UP || s.side == ForgeDirection.DOWN) {
                    pos_x += (double)x;
                    pos_y += (double)z;
                } else {
                    pos_x += (double)y;
                    pos_y += (double)z;
                }
                IIcon ico = icoSet[s.getSeed() % icoSet.length];
                switch (s.side) {
                    case UP: {
                        offset = 1.0 - offset;
                        tess.addVertexWithUV(pos_x - H, (double)y + offset, pos_y - H, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x + H, (double)y + offset, pos_y - H, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x + H, (double)y + offset, pos_y + H, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV(pos_x - H, (double)y + offset, pos_y + H, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case DOWN: {
                        tess.addVertexWithUV(pos_x + H, (double)y + offset, pos_y - H, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x - H, (double)y + offset, pos_y - H, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x - H, (double)y + offset, pos_y + H, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV(pos_x + H, (double)y + offset, pos_y + H, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case EAST: {
                        offset = 1.0 - offset;
                        tess.addVertexWithUV((double)x + offset, pos_x + H, pos_y - H, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV((double)x + offset, pos_x - H, pos_y - H, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV((double)x + offset, pos_x - H, pos_y + H, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV((double)x + offset, pos_x + H, pos_y + H, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case WEST: {
                        tess.addVertexWithUV((double)x + offset, pos_x - H, pos_y - H, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV((double)x + offset, pos_x + H, pos_y - H, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV((double)x + offset, pos_x + H, pos_y + H, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV((double)x + offset, pos_x - H, pos_y + H, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case SOUTH: {
                        offset = 1.0 - offset;
                        tess.addVertexWithUV(pos_x + H, pos_y - H, (double)z + offset, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x - H, pos_y - H, (double)z + offset, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x - H, pos_y + H, (double)z + offset, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV(pos_x + H, pos_y + H, (double)z + offset, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                    case NORTH: {
                        tess.addVertexWithUV(pos_x - H, pos_y - H, (double)z + offset, (double)ico.getMinU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x + H, pos_y - H, (double)z + offset, (double)ico.getMaxU(), (double)ico.getMinV());
                        tess.addVertexWithUV(pos_x + H, pos_y + H, (double)z + offset, (double)ico.getMaxU(), (double)ico.getMaxV());
                        tess.addVertexWithUV(pos_x - H, pos_y + H, (double)z + offset, (double)ico.getMinU(), (double)ico.getMaxV());
                        break;
                    }
                }
            }
            out = true;
        }
        return out;
    }
}

