/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.block.AEBaseBlock;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BlockRenderInfo;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.spatial.TileSpatialPylon;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderSpatialPylon
extends BaseBlockRender {
    public RenderSpatialPylon() {
        super(false, 0.0);
    }

    @Override
    public void renderInventory(AEBaseBlock block, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        renderer.overrideBlockTexture = ExtraBlockTextures.BlockSpatialPylon_dim.getIcon();
        super.renderInventory(block, is, renderer, type, obj);
        renderer.overrideBlockTexture = null;
        super.renderInventory(block, is, renderer, type, obj);
    }

    @Override
    public boolean renderInWorld(AEBaseBlock imb, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        TileSpatialPylon sp = (TileSpatialPylon)imb.getTileEntity(world, x, y, z);
        int displayBits = sp == null ? 0 : sp.getDisplayBits();
        ForgeDirection ori = ForgeDirection.UNKNOWN;
        if (displayBits != 0) {
            if ((displayBits & sp.DISPLAY_Z) == sp.DISPLAY_X) {
                ori = ForgeDirection.EAST;
                if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MAX) {
                    renderer.uvRotateEast = 1;
                    renderer.uvRotateWest = 2;
                    renderer.uvRotateTop = 2;
                    renderer.uvRotateBottom = 1;
                } else if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MIN) {
                    renderer.uvRotateEast = 2;
                    renderer.uvRotateWest = 1;
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 2;
                } else {
                    renderer.uvRotateEast = 1;
                    renderer.uvRotateWest = 1;
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateBottom = 1;
                }
            } else if ((displayBits & sp.DISPLAY_Z) == sp.DISPLAY_Y) {
                ori = ForgeDirection.UP;
                if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MAX) {
                    renderer.uvRotateNorth = 3;
                    renderer.uvRotateSouth = 3;
                    renderer.uvRotateEast = 3;
                    renderer.uvRotateWest = 3;
                }
            } else if ((displayBits & sp.DISPLAY_Z) == sp.DISPLAY_Z) {
                ori = ForgeDirection.NORTH;
                if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MAX) {
                    renderer.uvRotateSouth = 1;
                    renderer.uvRotateNorth = 2;
                } else if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MIN) {
                    renderer.uvRotateNorth = 1;
                    renderer.uvRotateSouth = 2;
                    renderer.uvRotateTop = 3;
                    renderer.uvRotateBottom = 3;
                } else {
                    renderer.uvRotateNorth = 1;
                    renderer.uvRotateSouth = 2;
                }
            }
            BlockRenderInfo bri = imb.getRendererInstance();
            bri.setTemporaryRenderIcon(null);
            bri.setTemporaryRenderIcons(this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.UP), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.DOWN), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.SOUTH), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.NORTH), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.EAST), this.getBlockTextureFromSideOutside(imb, sp, displayBits, ori, ForgeDirection.WEST));
            boolean r = renderer.renderStandardBlock((Block)imb, x, y, z);
            if ((displayBits & sp.DISPLAY_POWERED_ENABLED) == sp.DISPLAY_POWERED_ENABLED) {
                int bn = 15;
                Tessellator.instance.setBrightness(bn << 20 | bn << 4);
                Tessellator.instance.setColorOpaque_I(0xFFFFFF);
                for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                    this.renderFace(x, y, z, (Block)imb, this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, d), renderer, d);
                }
            } else {
                bri.setTemporaryRenderIcon(null);
                bri.setTemporaryRenderIcons(this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.UP), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.DOWN), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.SOUTH), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.NORTH), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.EAST), this.getBlockTextureFromSideInside(imb, sp, displayBits, ori, ForgeDirection.WEST));
                renderer.renderStandardBlock((Block)imb, x, y, z);
            }
            bri.setTemporaryRenderIcon(null);
            renderer.uvRotateBottom = 0;
            renderer.uvRotateTop = 0;
            renderer.uvRotateSouth = 0;
            renderer.uvRotateNorth = 0;
            renderer.uvRotateWest = 0;
            renderer.uvRotateEast = 0;
            return r;
        }
        renderer.overrideBlockTexture = imb.getIcon(0, 0);
        boolean result = renderer.renderStandardBlock((Block)imb, x, y, z);
        renderer.overrideBlockTexture = ExtraBlockTextures.BlockSpatialPylon_dim.getIcon();
        result = renderer.renderStandardBlock((Block)imb, x, y, z);
        renderer.overrideBlockTexture = null;
        return result;
    }

    private IIcon getBlockTextureFromSideOutside(AEBaseBlock blk, TileSpatialPylon sp, int displayBits, ForgeDirection ori, ForgeDirection dir) {
        if (ori == dir || ori.getOpposite() == dir) {
            return blk.getRendererInstance().getTexture(dir);
        }
        if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_MIDDLE) {
            return ExtraBlockTextures.BlockSpatialPylonC.getIcon();
        }
        if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MIN) {
            return ExtraBlockTextures.BlockSpatialPylonE.getIcon();
        }
        if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MAX) {
            return ExtraBlockTextures.BlockSpatialPylonE.getIcon();
        }
        return blk.getIcon(0, 0);
    }

    private IIcon getBlockTextureFromSideInside(AEBaseBlock blk, TileSpatialPylon sp, int displayBits, ForgeDirection ori, ForgeDirection dir) {
        boolean good;
        boolean bl = good = (displayBits & sp.DISPLAY_ENABLED) == sp.DISPLAY_ENABLED;
        if (ori == dir || ori.getOpposite() == dir) {
            return good ? ExtraBlockTextures.BlockSpatialPylon_dim.getIcon() : ExtraBlockTextures.BlockSpatialPylon_red.getIcon();
        }
        if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_MIDDLE) {
            return good ? ExtraBlockTextures.BlockSpatialPylonC_dim.getIcon() : ExtraBlockTextures.BlockSpatialPylonC_red.getIcon();
        }
        if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MIN) {
            return good ? ExtraBlockTextures.BlockSpatialPylonE_dim.getIcon() : ExtraBlockTextures.BlockSpatialPylonE_red.getIcon();
        }
        if ((displayBits & sp.DISPLAY_MIDDLE) == sp.DISPLAY_END_MAX) {
            return good ? ExtraBlockTextures.BlockSpatialPylonE_dim.getIcon() : ExtraBlockTextures.BlockSpatialPylonE_red.getIcon();
        }
        return blk.getIcon(0, 0);
    }
}

