/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.texture;

import net.minecraft.util.IIcon;

public class FlippableIcon
implements IIcon {
    protected IIcon original;
    boolean flip_u;
    boolean flip_v;

    public FlippableIcon(IIcon o) {
        if (o == null) {
            throw new IllegalArgumentException("Cannot create a wrapper icon with a null icon.");
        }
        this.original = o;
        this.flip_u = false;
        this.flip_v = false;
    }

    public int getIconWidth() {
        return this.original.getIconWidth();
    }

    public int getIconHeight() {
        return this.original.getIconHeight();
    }

    public float getMinU() {
        if (this.flip_u) {
            return this.original.getMaxU();
        }
        return this.original.getMinU();
    }

    public float getMaxU() {
        if (this.flip_u) {
            return this.original.getMinU();
        }
        return this.original.getMaxU();
    }

    public float getInterpolatedU(double px) {
        if (this.flip_u) {
            return this.original.getInterpolatedU(16.0 - px);
        }
        return this.original.getInterpolatedU(px);
    }

    public float getMinV() {
        if (this.flip_v) {
            return this.original.getMaxV();
        }
        return this.original.getMinV();
    }

    public float getMaxV() {
        if (this.flip_v) {
            return this.original.getMinV();
        }
        return this.original.getMaxV();
    }

    public float getInterpolatedV(double px) {
        if (this.flip_v) {
            return this.original.getInterpolatedV(16.0 - px);
        }
        return this.original.getInterpolatedV(px);
    }

    public String getIconName() {
        return this.original.getIconName();
    }

    public IIcon getOriginal() {
        return this.original;
    }

    public void setFlip(boolean u, boolean v) {
        this.flip_u = u;
        this.flip_v = v;
    }

    public int setFlip(int orientation) {
        this.flip_u = (orientation & 8) == 8;
        this.flip_v = (orientation & 0x10) == 16;
        return orientation & 7;
    }
}

