/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.util.IConfigManager;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotNormal;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import net.minecraft.entity.player.InventoryPlayer;

public class ContainerInterface
extends ContainerUpgradeable {
    final DualityInterface myDuality;
    @GuiSync(value=3)
    public YesNo bMode = YesNo.NO;
    @GuiSync(value=4)
    public YesNo iTermMode = YesNo.YES;

    public ContainerInterface(InventoryPlayer ip, IInterfaceHost te) {
        super(ip, te.getInterfaceDuality().getHost());
        int x;
        this.myDuality = te.getInterfaceDuality();
        for (x = 0; x < 9; ++x) {
            this.addSlotToContainer(new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, this.myDuality.getPatterns(), x, 8 + 18 * x, 97, this.invPlayer));
        }
        for (x = 0; x < 8; ++x) {
            this.addSlotToContainer(new SlotFake(this.myDuality.getConfig(), x, 17 + 18 * x, 35));
        }
        for (x = 0; x < 8; ++x) {
            this.addSlotToContainer(new SlotNormal(this.myDuality.getStorage(), x, 17 + 18 * x, 53));
        }
    }

    @Override
    protected int getHeight() {
        return 211;
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    public int availableUpgrades() {
        return 1;
    }

    @Override
    public void detectAndSendChanges() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        super.detectAndSendChanges();
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
        this.bMode = (YesNo)cm.getSetting(Settings.BLOCK);
        this.iTermMode = (YesNo)cm.getSetting(Settings.INTERFACE_TERMINAL);
    }
}

