/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.implementations.guiobjects.INetworkTool;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ContainerNetworkStatus
extends AEBaseContainer {
    @GuiSync(value=0)
    public long avgAddition;
    @GuiSync(value=1)
    public long powerUsage;
    @GuiSync(value=2)
    public long currentPower;
    @GuiSync(value=3)
    public long maxPower;
    IGrid network;
    int delay = 40;

    public ContainerNetworkStatus(InventoryPlayer ip, INetworkTool te) {
        super(ip, null, null);
        IGridHost host = te.getGridHost();
        if (host != null) {
            this.findNode(host, ForgeDirection.UNKNOWN);
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                this.findNode(host, d);
            }
        }
        if (this.network == null && Platform.isServer()) {
            this.isContainerValid = false;
        }
    }

    private void findNode(IGridHost host, ForgeDirection d) {
        IGridNode node;
        if (this.network == null && (node = host.getGridNode(d)) != null) {
            this.network = node.getGrid();
        }
    }

    @Override
    public void detectAndSendChanges() {
        ++this.delay;
        if (Platform.isServer() && this.delay > 15 && this.network != null) {
            this.delay = 0;
            IEnergyGrid eg = (IEnergyGrid)this.network.getCache(IEnergyGrid.class);
            if (eg != null) {
                this.avgAddition = (long)(100.0 * eg.getAvgPowerInjection());
                this.powerUsage = (long)(100.0 * eg.getAvgPowerUsage());
                this.currentPower = (long)(100.0 * eg.getStoredPower());
                this.maxPower = (long)(100.0 * eg.getMaxStoredPower());
            }
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                for (Class clazz : this.network.getMachinesClasses()) {
                    IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
                    for (IGridNode machine : this.network.getMachines(clazz)) {
                        IGridBlock blk = machine.getGridBlock();
                        ItemStack is = blk.getMachineRepresentation();
                        if (is == null || is.getItem() == null) continue;
                        AEItemStack ais = AEItemStack.create(is);
                        ais.setStackSize(1L);
                        ais.setCountRequestable((long)(blk.getIdlePowerUsage() * 100.0));
                        list.add(ais);
                    }
                    for (IAEItemStack ais : list) {
                        piu.appendItem(ais);
                    }
                }
                for (Object object : this.crafters) {
                    if (!(object instanceof EntityPlayer)) continue;
                    NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)object);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.detectAndSendChanges();
    }
}

