/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.AEApi;
import appeng.api.definitions.IMaterials;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.CommonHelper;
import appeng.core.features.AEFeature;
import appeng.entity.AEBaseEntityItem;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public final class EntityChargedQuartz
extends AEBaseEntityItem {
    int delay = 0;
    int transformTime = 0;

    public EntityChargedQuartz(World w) {
        super(w);
    }

    public EntityChargedQuartz(World w, double x, double y, double z, ItemStack is) {
        super(w, x, y, z, is);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!AEConfig.instance.isFeatureEnabled(AEFeature.inWorldFluix)) {
            return;
        }
        if (Platform.isClient() && this.delay > 30 && AEConfig.instance.enableEffects) {
            CommonHelper.proxy.spawnEffect(EffectType.Lightning, this.worldObj, this.posX, this.posY, this.posZ, null);
            this.delay = 0;
        }
        ++this.delay;
        int j = MathHelper.floor_double((double)this.posX);
        int i = MathHelper.floor_double((double)this.posY);
        int k = MathHelper.floor_double((double)this.posZ);
        Material mat = this.worldObj.getBlock(j, i, k).getMaterial();
        if (Platform.isServer() && mat.isLiquid()) {
            ++this.transformTime;
            if (this.transformTime > 60 && !this.transform()) {
                this.transformTime = 0;
            }
        } else {
            this.transformTime = 0;
        }
    }

    public boolean transform() {
        ItemStack item = this.getEntityItem();
        IMaterials materials = AEApi.instance().definitions().materials();
        if (materials.certusQuartzCrystalCharged().isSameAs(item)) {
            AxisAlignedBB region = AxisAlignedBB.getBoundingBox((double)(this.posX - 1.0), (double)(this.posY - 1.0), (double)(this.posZ - 1.0), (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0));
            List<Entity> l = this.getCheckedEntitiesWithinAABBExcludingEntity(region);
            EntityItem redstone = null;
            EntityItem netherQuartz = null;
            for (Entity e : l) {
                ItemStack other;
                if (!(e instanceof EntityItem) || e.isDead || (other = ((EntityItem)e).getEntityItem()) == null || other.stackSize <= 0) continue;
                if (Platform.isSameItem(other, new ItemStack(Items.redstone))) {
                    redstone = (EntityItem)e;
                }
                if (!Platform.isSameItem(other, new ItemStack(Items.quartz))) continue;
                netherQuartz = (EntityItem)e;
            }
            if (redstone != null && netherQuartz != null) {
                --this.getEntityItem().stackSize;
                --redstone.getEntityItem().stackSize;
                --netherQuartz.getEntityItem().stackSize;
                if (this.getEntityItem().stackSize <= 0) {
                    this.setDead();
                }
                if (redstone.getEntityItem().stackSize <= 0) {
                    redstone.setDead();
                }
                if (netherQuartz.getEntityItem().stackSize <= 0) {
                    netherQuartz.setDead();
                }
                for (ItemStack fluixCrystalStack : materials.fluixCrystal().maybeStack(2).asSet()) {
                    EntityItem entity = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, fluixCrystalStack);
                    this.worldObj.spawnEntityInWorld((Entity)entity);
                }
                return true;
            }
        }
        return false;
    }
}

