/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.client.gui.implementations.GuiCraftingTerm;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketNEIRecipe;
import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class NEICraftingHandler
implements IOverlayHandler {
    final int offsetX;
    final int offsetY;

    public NEICraftingHandler(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        try {
            List ingredients = recipe.getIngredientStacks(recipeIndex);
            this.overlayRecipe(gui, ingredients, shift);
        }
        catch (Exception ignored) {
        }
        catch (Error ignored) {
            // empty catch block
        }
    }

    public void overlayRecipe(GuiContainer gui, List<PositionedStack> ingredients, boolean shift) {
        try {
            NBTTagCompound recipe = new NBTTagCompound();
            if (gui instanceof GuiCraftingTerm || gui instanceof GuiPatternTerm) {
                block3: for (PositionedStack positionedStack : ingredients) {
                    int col = (positionedStack.relx - 25) / 18;
                    int row = (positionedStack.rely - 6) / 18;
                    if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
                    for (Slot slot : gui.inventorySlots.inventorySlots) {
                        if (!(slot instanceof SlotCraftingMatrix) && !(slot instanceof SlotFakeCraftingMatrix) || slot.getSlotIndex() != col + row * 3) continue;
                        NBTTagList tags = new NBTTagList();
                        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                        for (int x = 0; x < positionedStack.items.length; ++x) {
                            if (Platform.isRecipePrioritized(positionedStack.items[x])) {
                                list.add(0, positionedStack.items[x]);
                                continue;
                            }
                            list.add(positionedStack.items[x]);
                        }
                        for (ItemStack is : list) {
                            NBTTagCompound tag = new NBTTagCompound();
                            is.writeToNBT(tag);
                            tags.appendTag((NBTBase)tag);
                        }
                        recipe.setTag("#" + slot.getSlotIndex(), (NBTBase)tags);
                        continue block3;
                    }
                }
                NetworkHandler.instance.sendToServer(new PacketNEIRecipe(recipe));
            }
        }
        catch (Exception ignored) {
        }
        catch (Error ignored) {
            // empty catch block
        }
    }
}

