/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.NEIHelpers;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.core.localization.GuiText;
import appeng.facade.IFacadeItem;
import appeng.items.parts.ItemFacade;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiCrafting;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class NEIFacadeRecipeHandler
extends TemplateRecipeHandler {
    final ItemFacade facade;
    final IItemDefinition anchorDefinition;

    public NEIFacadeRecipeHandler() {
        IDefinitions definitions = AEApi.instance().definitions();
        this.facade = (ItemFacade)definitions.items().facade().maybeItem().get();
        this.anchorDefinition = definitions.parts().cableAnchor();
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "crafting", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == NEIFacadeRecipeHandler.class) {
            List<ItemStack> facades = this.facade.getFacades();
            for (ItemStack anchorStack : this.anchorDefinition.maybeStack(1).asSet()) {
                for (ItemStack is : facades) {
                    CachedShapedRecipe recipe = new CachedShapedRecipe(this.facade, anchorStack, is);
                    recipe.computeVisuals();
                    this.arecipes.add(recipe);
                }
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.getItem() == this.facade) {
            for (ItemStack anchorStack : this.anchorDefinition.maybeStack(1).asSet()) {
                CachedShapedRecipe recipe = new CachedShapedRecipe(this.facade, anchorStack, result);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<ItemStack> facades = this.facade.getFacades();
        for (ItemStack anchorStack : this.anchorDefinition.maybeStack(1).asSet()) {
            for (ItemStack is : facades) {
                CachedShapedRecipe recipe = new CachedShapedRecipe(this.facade, anchorStack, is);
                if (!recipe.contains(recipe.ingredients, ingredient.getItem())) continue;
                recipe.computeVisuals();
                if (!recipe.contains(recipe.ingredients, ingredient)) continue;
                recipe.setIngredientPermutation(recipe.ingredients, ingredient);
                this.arecipes.add(recipe);
            }
        }
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getOverlayIdentifier() {
        return "crafting";
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrafting.class;
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return super.hasOverlay(gui, container, recipe) || this.isRecipe2x2(recipe) && RecipeInfo.hasDefaultOverlay((GuiContainer)gui, (String)"crafting2x2");
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        IRecipeOverlayRenderer renderer = super.getOverlayRenderer(gui, recipe);
        if (renderer != null) {
            return renderer;
        }
        IStackPositioner positioner = RecipeInfo.getStackPositioner((GuiContainer)gui, (String)"crafting2x2");
        if (positioner == null) {
            return null;
        }
        return new DefaultOverlayRenderer(this.getIngredientStacks(recipe), positioner);
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        IOverlayHandler handler = super.getOverlayHandler(gui, recipe);
        if (handler != null) {
            return handler;
        }
        return RecipeInfo.getOverlayHandler((GuiContainer)gui, (String)"crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public String getRecipeName() {
        return GuiText.FacadeCrafting.getLocal();
    }

    private final class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final ArrayList<PositionedStack> ingredients;
        public final PositionedStack result;

        public CachedShapedRecipe(IFacadeItem facade, ItemStack anchor, ItemStack output) {
            super((TemplateRecipeHandler)NEIFacadeRecipeHandler.this);
            output.stackSize = 4;
            this.result = new PositionedStack((Object)output, 119, 24);
            this.ingredients = new ArrayList();
            ItemStack in = facade.getTextureItem(output);
            this.setIngredients(3, 3, new Object[]{null, anchor, null, anchor, in, anchor, null, anchor, null});
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    ItemStack is = (ItemStack)items[y * width + x];
                    PositionedStack stack = new PositionedStack((Object)is, 25 + x * 18, 6 + y * 18, false);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIFacadeRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
            this.result.generatePermutations();
        }
    }
}

