/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.quartz;

import appeng.api.implementations.items.IAEWrench;
import appeng.api.util.DimensionalCoord;
import appeng.core.features.AEFeature;
import appeng.items.AEBaseItem;
import appeng.transformer.annotations.Integration;
import appeng.util.Platform;
import buildcraft.api.tools.IToolWrench;
import com.google.common.base.Optional;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Integration.Interface(iface="buildcraft.api.tools.IToolWrench", iname="BC")
public class ToolQuartzWrench
extends AEBaseItem
implements IAEWrench,
IToolWrench {
    public ToolQuartzWrench(AEFeature type) {
        super((Optional<String>)Optional.of((Object)type.name()));
        this.setFeature(EnumSet.of(type, AEFeature.QuartzWrench));
        this.setMaxStackSize(1);
        this.setHarvestLevel("wrench", 0);
    }

    public boolean onItemUseFirst(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        Block b = world.getBlock(x, y, z);
        if (b != null && !player.isSneaking() && Platform.hasPermissions(new DimensionalCoord(world, x, y, z), player)) {
            if (Platform.isClient()) {
                return !world.isRemote;
            }
            ForgeDirection mySide = ForgeDirection.getOrientation((int)side);
            if (b.rotateBlock(world, x, y, z, mySide)) {
                b.onNeighborBlockChange(world, x, y, z, Platform.AIR);
                player.swingItem();
                return !world.isRemote;
            }
        }
        return false;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canWrench(ItemStack is, EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public boolean canWrench(EntityPlayer player, int x, int y, int z) {
        return true;
    }

    public void wrenchUsed(EntityPlayer player, int x, int y, int z) {
        player.swingItem();
    }
}

