/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class MEIInventoryWrapper
implements IMEInventory<IAEItemStack> {
    protected final IInventory target;
    protected final InventoryAdaptor adaptor;

    public MEIInventoryWrapper(IInventory m, InventoryAdaptor ia) {
        this.target = m;
        this.adaptor = ia;
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack iox, Actionable mode, BaseActionSource src) {
        ItemStack t;
        int x;
        ItemStack input = iox.getItemStack();
        if (this.adaptor != null) {
            ItemStack is;
            ItemStack itemStack = is = mode == Actionable.SIMULATE ? this.adaptor.simulateAdd(input) : this.adaptor.addItems(input);
            if (is == null) {
                return null;
            }
            return AEItemStack.create(is);
        }
        ItemStack out = Platform.cloneItemStack(input);
        if (mode == Actionable.MODULATE) {
            for (x = 0; x < this.target.getSizeInventory(); ++x) {
                t = this.target.getStackInSlot(x);
                if (!Platform.isSameItem(t, input)) continue;
                int oriStack = t.stackSize;
                t.stackSize += out.stackSize;
                this.target.setInventorySlotContents(x, t);
                if (t.stackSize > this.target.getInventoryStackLimit()) {
                    t.stackSize = this.target.getInventoryStackLimit();
                }
                if (t.stackSize > t.getMaxStackSize()) {
                    t.stackSize = t.getMaxStackSize();
                }
                out.stackSize -= t.stackSize - oriStack;
                if (out.stackSize > 0) continue;
                return null;
            }
        }
        for (x = 0; x < this.target.getSizeInventory(); ++x) {
            t = this.target.getStackInSlot(x);
            if (t != null) continue;
            t = Platform.cloneItemStack(input);
            t.stackSize = out.stackSize;
            if (t.stackSize > this.target.getInventoryStackLimit()) {
                t.stackSize = this.target.getInventoryStackLimit();
            }
            out.stackSize -= t.stackSize;
            if (mode == Actionable.MODULATE) {
                this.target.setInventorySlotContents(x, t);
            }
            if (out.stackSize > 0) continue;
            return null;
        }
        return AEItemStack.create(out);
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        ItemStack Req;
        ItemStack Gathered = null;
        int request_stackSize = Req.stackSize;
        Req = request.getItemStack();
        if (request_stackSize > Req.getMaxStackSize()) {
            request_stackSize = Req.getMaxStackSize();
        }
        Req.stackSize = request_stackSize;
        if (this.adaptor != null) {
            Gathered = this.adaptor.removeItems(Req.stackSize, Req, null);
        } else {
            Gathered = request.getItemStack();
            Gathered.stackSize = 0;
            for (int x = 0; x < this.target.getSizeInventory(); ++x) {
                ItemStack sub = this.target.getStackInSlot(x);
                if (!Platform.isSameItem(sub, Req)) continue;
                int reqNum = Req.stackSize;
                if (reqNum > sub.stackSize) {
                    reqNum = Req.stackSize;
                }
                ItemStack retrieved = null;
                if (sub.stackSize < Req.stackSize) {
                    retrieved = Platform.cloneItemStack(sub);
                    sub.stackSize = 0;
                } else {
                    retrieved = sub.splitStack(Req.stackSize);
                }
                if (sub.stackSize <= 0) {
                    this.target.setInventorySlotContents(x, null);
                } else {
                    this.target.setInventorySlotContents(x, sub);
                }
                if (retrieved != null) {
                    Gathered.stackSize += retrieved.stackSize;
                    Req.stackSize -= retrieved.stackSize;
                }
                if (request_stackSize != Gathered.stackSize) continue;
                return AEItemStack.create(Gathered);
            }
            if (Gathered.stackSize == 0) {
                return null;
            }
        }
        return AEItemStack.create(Gathered);
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        for (int x = 0; x < this.target.getSizeInventory(); ++x) {
            out.addStorage(AEItemStack.create(this.target.getStackInSlot(x)));
        }
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }
}

