/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.texture.CableBusTextures;
import appeng.core.settings.TickRates;
import appeng.core.sync.packets.PacketTransitionEffect;
import appeng.hooks.TickHandler;
import appeng.me.GridAccessException;
import appeng.parts.PartBasicState;
import appeng.server.ServerHelper;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;

public class PartAnnihilationPlane
extends PartBasicState
implements IGridTickable,
Callable<TickRateModulation> {
    private final BaseActionSource mySrc = new MachineSource(this);
    private boolean isAccepting = true;
    private boolean breaking = false;

    public PartAnnihilationPlane(ItemStack is) {
        super(is);
    }

    @Override
    public TickRateModulation call() throws Exception {
        this.breaking = false;
        return this.breakBlock(true);
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            int x = te.xCoord;
            int y = te.yCoord;
            int z = te.zCoord;
            ForgeDirection e = bch.getWorldX();
            ForgeDirection u = bch.getWorldY();
            if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x - e.offsetX, y - e.offsetY, z - e.offsetZ), this.side)) {
                minX = false;
            }
            if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x + e.offsetX, y + e.offsetY, z + e.offsetZ), this.side)) {
                maxX = 16;
            }
            if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x - u.offsetX, y - u.offsetY, z - u.offsetZ), this.side)) {
                minY = false;
            }
            if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x + u.offsetX, y + u.offsetY, z + u.offsetZ), this.side)) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, bch.isBBCollision() ? 15.0 : 16.0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        rh.setTexture(CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartTransitionPlaneBack.getIcon(), this.is.getIconIndex(), CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartPlaneSides.getIcon());
        rh.setBounds(1.0f, 1.0f, 15.0f, 15.0f, 15.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderInventoryBox(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        ForgeDirection e = rh.getWorldX();
        ForgeDirection u = rh.getWorldY();
        TileEntity te = this.getHost().getTile();
        if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x - e.offsetX, y - e.offsetY, z - e.offsetZ), this.side)) {
            minX = false;
        }
        if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x + e.offsetX, y + e.offsetY, z + e.offsetZ), this.side)) {
            maxX = 16;
        }
        if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x - u.offsetX, y - u.offsetY, z - u.offsetZ), this.side)) {
            minY = false;
        }
        if (this.isAnnihilationPlane(te.getWorldObj().getTileEntity(x + u.offsetX, y + u.offsetY, z + u.offsetZ), this.side)) {
            maxY = 16;
        }
        this.getClass();
        this.getClass();
        this.getClass();
        this.getClass();
        boolean isActive = (this.clientFlags & (1 | 2)) == (1 | 2);
        this.renderCache = rh.useSimplifiedRendering(x, y, z, this, this.renderCache);
        rh.setTexture(CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartTransitionPlaneBack.getIcon(), isActive ? CableBusTextures.BlockAnnihilationPlaneOn.getIcon() : this.is.getIconIndex(), CableBusTextures.PartPlaneSides.getIcon(), CableBusTextures.PartPlaneSides.getIcon());
        rh.setBounds((float)minX, (float)minY, 15.0f, maxX, maxY, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartTransitionPlaneBack.getIcon(), isActive ? CableBusTextures.BlockAnnihilationPlaneOn.getIcon() : this.is.getIconIndex(), CableBusTextures.PartMonitorSidesStatus.getIcon(), CableBusTextures.PartMonitorSidesStatus.getIcon());
        rh.setBounds(5.0f, 5.0f, 14.0f, 11.0f, 11.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderLights(x, y, z, rh, renderer);
    }

    @Override
    public void onNeighborChanged() {
        this.isAccepting = true;
        try {
            this.proxy.getTick().alertDevice(this.proxy.getNode());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    public void onEntityCollision(Entity entity) {
        if (this.isAccepting && entity instanceof EntityItem && !entity.isDead && Platform.isServer() && this.proxy.isActive()) {
            boolean capture = false;
            switch (this.side) {
                case DOWN: 
                case UP: {
                    if (!(entity.posX > (double)this.tile.xCoord) || !(entity.posX < (double)(this.tile.xCoord + 1)) || !(entity.posZ > (double)this.tile.zCoord) || !(entity.posZ < (double)(this.tile.zCoord + 1)) || !(entity.posY > (double)this.tile.yCoord + 0.9 && this.side == ForgeDirection.UP) && (!(entity.posY < (double)this.tile.yCoord + 0.1) || this.side != ForgeDirection.DOWN)) break;
                    capture = true;
                    break;
                }
                case SOUTH: 
                case NORTH: {
                    if (!(entity.posX > (double)this.tile.xCoord) || !(entity.posX < (double)(this.tile.xCoord + 1)) || !(entity.posY > (double)this.tile.yCoord) || !(entity.posY < (double)(this.tile.yCoord + 1)) || !(entity.posZ > (double)this.tile.zCoord + 0.9 && this.side == ForgeDirection.SOUTH) && (!(entity.posZ < (double)this.tile.zCoord + 0.1) || this.side != ForgeDirection.NORTH)) break;
                    capture = true;
                    break;
                }
                case EAST: 
                case WEST: {
                    if (!(entity.posZ > (double)this.tile.zCoord) || !(entity.posZ < (double)(this.tile.zCoord + 1)) || !(entity.posY > (double)this.tile.yCoord) || !(entity.posY < (double)(this.tile.yCoord + 1)) || !(entity.posX > (double)this.tile.xCoord + 0.9 && this.side == ForgeDirection.EAST) && (!(entity.posX < (double)this.tile.xCoord + 0.1) || this.side != ForgeDirection.WEST)) break;
                    capture = true;
                    break;
                }
            }
            if (capture) {
                ServerHelper.proxy.sendToAllNearExcept(null, this.tile.xCoord, this.tile.yCoord, this.tile.zCoord, 64.0, this.tile.getWorldObj(), new PacketTransitionEffect(entity.posX, entity.posY, entity.posZ, this.side, false));
                this.storeEntityItem((EntityItem)entity);
            }
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    private void storeEntityItem(EntityItem entityItem) {
        if (!entityItem.isDead) {
            this.storeItemStack(entityItem.getEntityItem());
            entityItem.setDead();
        }
    }

    private void storeItemStack(ItemStack item) {
        AEItemStack itemToStore = AEItemStack.create(item);
        try {
            IStorageGrid storage = this.proxy.getStorage();
            IEnergyGrid energy = this.proxy.getEnergy();
            IAEItemStack overflow = Platform.poweredInsert(energy, storage.getItemInventory(), itemToStore, this.mySrc);
            this.spawnOverflowItemStack(overflow);
            this.isAccepting = overflow == null;
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void spawnOverflowItemStack(IAEItemStack overflow) {
        if (overflow == null) {
            return;
        }
        TileEntity tileEntity = this.getTile();
        WorldServer world = (WorldServer)tileEntity.getWorldObj();
        int x = tileEntity.xCoord + this.side.offsetX;
        int y = tileEntity.yCoord + this.side.offsetY;
        int z = tileEntity.zCoord + this.side.offsetZ;
        Platform.spawnDrops((World)world, x, y, z, Lists.newArrayList((Object[])new ItemStack[]{overflow.getItemStack()}));
    }

    private boolean isAnnihilationPlane(TileEntity blockTileEntity, ForgeDirection side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p instanceof PartAnnihilationPlane;
        }
        return false;
    }

    private boolean isAccepting() {
        return this.isAccepting;
    }

    @Override
    @MENetworkEventSubscribe
    public void chanRender(MENetworkChannelsChanged c) {
        this.onNeighborChanged();
        this.getHost().markForUpdate();
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.onNeighborChanged();
        this.getHost().markForUpdate();
    }

    public TickRateModulation breakBlock(boolean modulate) {
        if (this.isAccepting && this.proxy.isActive()) {
            try {
                float hardness;
                boolean ignore;
                TileEntity te = this.getTile();
                WorldServer w = (WorldServer)te.getWorldObj();
                int x = te.xCoord + this.side.offsetX;
                int y = te.yCoord + this.side.offsetY;
                int z = te.zCoord + this.side.offsetZ;
                Block blk = w.getBlock(x, y, z);
                IEnergyGrid energy = this.proxy.getEnergy();
                Material mat = blk.getMaterial();
                boolean bl = ignore = mat == Material.air || mat == Material.lava || mat == Material.water || mat.isLiquid() || blk == Blocks.bedrock || blk == Blocks.end_portal || blk == Blocks.end_portal_frame || blk == Blocks.command_block;
                if (!ignore && !w.isAirBlock(x, y, z) && w.blockExists(x, y, z) && w.canMineBlock(Platform.getPlayer(w), x, y, z) && (double)(hardness = blk.getBlockHardness((World)w, x, y, z)) >= 0.0) {
                    ItemStack[] out = Platform.getBlockDrops((World)w, x, y, z);
                    float total = 1.0f + hardness;
                    for (ItemStack is : out) {
                        total += (float)is.stackSize;
                    }
                    boolean hasPower = energy.extractAEPower((double)total, Actionable.SIMULATE, PowerMultiplier.CONFIG) > (double)total - 0.1;
                    boolean canStore = this.canStoreItemStacks(out);
                    if (hasPower && canStore) {
                        if (modulate) {
                            w.setBlock(x, y, z, Platform.AIR, 0, 3);
                            energy.extractAEPower((double)total, Actionable.MODULATE, PowerMultiplier.CONFIG);
                            AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)((double)x - 0.2), (double)((double)y - 0.2), (double)((double)z - 0.2), (double)((double)x + 1.2), (double)((double)y + 1.2), (double)((double)z + 1.2));
                            for (Object ei : w.getEntitiesWithinAABB(EntityItem.class, box)) {
                                if (!(ei instanceof EntityItem)) continue;
                                EntityItem entityItem = (EntityItem)ei;
                                this.storeEntityItem(entityItem);
                            }
                            for (ItemStack snaggedItem : out) {
                                this.storeItemStack(snaggedItem);
                            }
                            ServerHelper.proxy.sendToAllNearExcept(null, x, y, z, 64.0, (World)w, new PacketTransitionEffect(x, y, z, this.side, true));
                        } else {
                            this.breaking = true;
                            TickHandler.INSTANCE.addCallable(this.tile.getWorldObj(), this);
                        }
                        return TickRateModulation.URGENT;
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
        return TickRateModulation.IDLE;
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane.min, TickRates.AnnihilationPlane.max, false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.breaking) {
            return TickRateModulation.URGENT;
        }
        this.isAccepting = true;
        return this.breakBlock(false);
    }

    private boolean canStoreItemStacks(ItemStack[] itemStacks) {
        boolean canStore = itemStacks.length == 0;
        try {
            IStorageGrid storage = this.proxy.getStorage();
            for (ItemStack itemStack : itemStacks) {
                AEItemStack itemToTest = AEItemStack.create(itemStack);
                IAEItemStack overflow = storage.getItemInventory().injectItems(itemToTest, Actionable.SIMULATE, this.mySrc);
                if (overflow != null && itemToTest.getStackSize() <= overflow.getStackSize()) continue;
                canStore = true;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        this.isAccepting = canStore;
        return canStore;
    }
}

