/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.layers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.LayerBase;
import appeng.api.parts.LayerFlags;
import appeng.util.Platform;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class LayerIEnergySink
extends LayerBase
implements IEnergySink {
    private TileEntity getEnergySinkTile() {
        IPartHost host = (IPartHost)((Object)this);
        return host.getTile();
    }

    private World getEnergySinkWorld() {
        if (this.getEnergySinkTile() == null) {
            return null;
        }
        return this.getEnergySinkTile().getWorldObj();
    }

    private boolean isTileValid() {
        TileEntity te = this.getEnergySinkTile();
        if (te == null) {
            return false;
        }
        return !te.isInvalid() && te.getWorldObj().blockExists(te.xCoord, te.yCoord, te.zCoord);
    }

    private void addToENet() {
        if (this.getEnergySinkWorld() == null) {
            return;
        }
        this.removeFromENet();
        if (!this.isInIC2() && Platform.isServer() && this.isTileValid()) {
            this.getLayerFlags().add(LayerFlags.IC2_ENET);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)((IEnergySink)this.getEnergySinkTile())));
        }
    }

    private void removeFromENet() {
        if (this.getEnergySinkWorld() == null) {
            return;
        }
        if (this.isInIC2() && Platform.isServer()) {
            this.getLayerFlags().remove((Object)LayerFlags.IC2_ENET);
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)((IEnergySink)this.getEnergySinkTile())));
        }
    }

    private boolean interestedInIC2() {
        if (!((IPartHost)((Object)this)).isInWorld()) {
            return false;
        }
        int interested = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergyTile)) continue;
            ++interested;
        }
        return interested == 1;
    }

    @Override
    public void partChanged() {
        super.partChanged();
        if (this.interestedInIC2()) {
            this.addToENet();
        } else {
            this.removeFromENet();
        }
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (!this.isInIC2()) {
            return false;
        }
        IPart part = this.getPart(direction);
        if (part instanceof IEnergySink) {
            return ((IEnergySink)part).acceptsEnergyFrom(emitter, direction);
        }
        return false;
    }

    private boolean isInIC2() {
        return this.getLayerFlags().contains((Object)LayerFlags.IC2_ENET);
    }

    public double getDemandedEnergy() {
        if (!this.isInIC2()) {
            return 0.0;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySink)) continue;
            return ((IEnergySink)part).getDemandedEnergy();
        }
        return 0.0;
    }

    public int getSinkTier() {
        return Integer.MAX_VALUE;
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        if (!this.isInIC2()) {
            return amount;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IPart part = this.getPart(dir);
            if (!(part instanceof IEnergySink)) continue;
            return ((IEnergySink)part).injectEnergy(directionFrom, amount, voltage);
        }
        return amount;
    }
}

