/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.client.texture.FlippableIcon;
import appeng.client.texture.OffsetIcon;
import appeng.client.texture.TaughtIcon;
import appeng.parts.networking.PartCable;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class PartCableSmart
extends PartCable {
    public PartCableSmart(ItemStack is) {
        super(is);
    }

    @MENetworkEventSubscribe
    public void channelUpdated(MENetworkChannelsChanged c) {
        this.getHost().markForUpdate();
    }

    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        this.getHost().markForUpdate();
    }

    @Override
    public AECableType getCableConnectionType() {
        return AECableType.SMART;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 5.0, 11.0, 11.0, 11.0);
        if (Platform.isServer()) {
            IGridNode n = this.getGridNode();
            if (n != null) {
                this.connections = n.getConnectedSides();
            } else {
                this.connections.clear();
            }
        }
        for (ForgeDirection of : this.connections) {
            switch (of) {
                case DOWN: {
                    bch.addBox(5.0, 0.0, 5.0, 11.0, 5.0, 11.0);
                    break;
                }
                case EAST: {
                    bch.addBox(11.0, 5.0, 5.0, 16.0, 11.0, 11.0);
                    break;
                }
                case NORTH: {
                    bch.addBox(5.0, 5.0, 0.0, 11.0, 11.0, 5.0);
                    break;
                }
                case SOUTH: {
                    bch.addBox(5.0, 5.0, 11.0, 11.0, 11.0, 16.0);
                    break;
                }
                case UP: {
                    bch.addBox(5.0, 11.0, 5.0, 11.0, 16.0, 11.0);
                    break;
                }
                case WEST: {
                    bch.addBox(0.0, 5.0, 5.0, 5.0, 11.0, 11.0);
                    break;
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        GL11.glTranslated((double)-0.0, (double)-0.0, (double)0.3);
        float offU = 0.0f;
        float offV = 9.0f;
        OffsetIcon main = new OffsetIcon(this.getTexture(this.getCableColor()), offU, offV);
        OffsetIcon ch1 = new OffsetIcon(this.getChannelTex(4, false).getIcon(), offU, offV);
        OffsetIcon ch2 = new OffsetIcon(this.getChannelTex(4, true).getIcon(), offU, offV);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.UP, ForgeDirection.DOWN)) {
            rh.setBounds(5.0f, 5.0f, 2.0f, 11.0f, 11.0f, 14.0f);
            rh.renderInventoryFace(main, side, renderer);
            rh.renderInventoryFace(ch1, side, renderer);
            rh.renderInventoryFace(ch2, side, renderer);
        }
        offU = 9.0f;
        offV = 0.0f;
        main = new OffsetIcon(this.getTexture(this.getCableColor()), offU, offV);
        ch1 = new OffsetIcon(this.getChannelTex(4, false).getIcon(), offU, offV);
        ch2 = new OffsetIcon(this.getChannelTex(4, true).getIcon(), offU, offV);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.EAST, ForgeDirection.WEST)) {
            rh.setBounds(5.0f, 5.0f, 2.0f, 11.0f, 11.0f, 14.0f);
            rh.renderInventoryFace(main, side, renderer);
            rh.renderInventoryFace(ch1, side, renderer);
            rh.renderInventoryFace(ch2, side, renderer);
        }
        main = new OffsetIcon(this.getTexture(this.getCableColor()), 0.0f, 0.0f);
        ch1 = new OffsetIcon(this.getChannelTex(4, false).getIcon(), 0.0f, 0.0f);
        ch2 = new OffsetIcon(this.getChannelTex(4, true).getIcon(), 0.0f, 0.0f);
        for (ForgeDirection side : EnumSet.of(ForgeDirection.SOUTH, ForgeDirection.NORTH)) {
            rh.setBounds(5.0f, 5.0f, 2.0f, 11.0f, 11.0f, 14.0f);
            rh.renderInventoryFace(main, side, renderer);
            rh.renderInventoryFace(ch1, side, renderer);
            rh.renderInventoryFace(ch2, side, renderer);
        }
        rh.setTexture(null);
    }

    @Override
    public IIcon getTexture(AEColor c) {
        return this.getSmartTexture(c);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        this.renderCache = rh.useSimplifiedRendering(x, y, z, this, this.renderCache);
        rh.setTexture(this.getTexture(this.getCableColor()));
        Object sides = this.connections.clone();
        boolean hasBuses = false;
        IPartHost ph = this.getHost();
        block13: for (ForgeDirection of : EnumSet.complementOf(this.connections)) {
            int len;
            IPart bp = ph.getPart(of);
            if (!(bp instanceof IGridHost)) continue;
            if (of != ForgeDirection.UNKNOWN) {
                ((AbstractCollection)sides).add(of);
                hasBuses = true;
            }
            if ((len = bp.cableConnectionRenderTo()) >= 8) continue;
            switch (of) {
                case DOWN: {
                    rh.setBounds(6.0f, len, 6.0f, 10.0f, 5.0f, 10.0f);
                    break;
                }
                case EAST: {
                    rh.setBounds(11.0f, 6.0f, 6.0f, 16 - len, 10.0f, 10.0f);
                    break;
                }
                case NORTH: {
                    rh.setBounds(6.0f, 6.0f, len, 10.0f, 10.0f, 5.0f);
                    break;
                }
                case SOUTH: {
                    rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 16 - len);
                    break;
                }
                case UP: {
                    rh.setBounds(6.0f, 11.0f, 6.0f, 10.0f, 16 - len, 10.0f);
                    break;
                }
                case WEST: {
                    rh.setBounds(len, 6.0f, 6.0f, 5.0f, 10.0f, 10.0f);
                    break;
                }
                default: {
                    continue block13;
                }
            }
            rh.renderBlock(x, y, z, renderer);
            this.setSmartConnectionRotations(of, renderer);
            TaughtIcon firstIcon = new TaughtIcon(this.getChannelTex(this.channelsOnSide[of.ordinal()], false).getIcon(), -0.2f);
            TaughtIcon secondIcon = new TaughtIcon(this.getChannelTex(this.channelsOnSide[of.ordinal()], true).getIcon(), -0.2f);
            if (of == ForgeDirection.EAST || of == ForgeDirection.WEST) {
                AEBaseBlock blk = (AEBaseBlock)rh.getBlock();
                FlippableIcon ico = blk.getRendererInstance().getTexture(ForgeDirection.EAST);
                ico.setFlip(false, true);
            }
            Tessellator.instance.setBrightness(0xF000F0);
            Tessellator.instance.setColorOpaque_I(this.getCableColor().blackVariant);
            rh.setTexture(firstIcon, firstIcon, firstIcon, firstIcon, firstIcon, firstIcon);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            Tessellator.instance.setColorOpaque_I(this.getCableColor().whiteVariant);
            rh.setTexture(secondIcon, secondIcon, secondIcon, secondIcon, secondIcon, secondIcon);
            this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
            renderer.uvRotateWest = 0;
            renderer.uvRotateTop = 0;
            renderer.uvRotateSouth = 0;
            renderer.uvRotateNorth = 0;
            renderer.uvRotateEast = 0;
            renderer.uvRotateBottom = 0;
            rh.setTexture(this.getTexture(this.getCableColor()));
        }
        if (((AbstractCollection)sides).size() != 2 || !this.nonLinear((EnumSet<ForgeDirection>)sides) || hasBuses) {
            for (ForgeDirection of : this.connections) {
                this.renderSmartConnection(x, y, z, rh, renderer, this.channelsOnSide[of.ordinal()], of);
            }
            rh.setTexture(this.getCoveredTexture(this.getCableColor()));
            rh.setBounds(5.0f, 5.0f, 5.0f, 11.0f, 11.0f, 11.0f);
            rh.renderBlock(x, y, z, renderer);
        } else {
            ForgeDirection selectedSide = ForgeDirection.UNKNOWN;
            Iterator i$ = this.connections.iterator();
            if (i$.hasNext()) {
                ForgeDirection of;
                selectedSide = of = (ForgeDirection)i$.next();
            }
            int channels = this.channelsOnSide[selectedSide.ordinal()];
            IIcon def = this.getTexture(this.getCableColor());
            OffsetIcon off = new OffsetIcon(def, 0.0f, -12.0f);
            TaughtIcon firstTaughtIcon = new TaughtIcon(this.getChannelTex(channels, false).getIcon(), -0.2f);
            OffsetIcon firstOffsetIcon = new OffsetIcon(firstTaughtIcon, 0.0f, -12.0f);
            TaughtIcon secondTaughtIcon = new TaughtIcon(this.getChannelTex(channels, true).getIcon(), -0.2f);
            OffsetIcon secondOffsetIcon = new OffsetIcon(secondTaughtIcon, 0.0f, -12.0f);
            switch (selectedSide) {
                case DOWN: 
                case UP: {
                    renderer.setRenderBounds(0.3125, 0.0, 0.3125, 0.6875, 1.0, 0.6875);
                    rh.setTexture(def, def, off, off, off, off);
                    rh.renderBlockCurrentBounds(x, y, z, renderer);
                    renderer.uvRotateTop = 0;
                    renderer.uvRotateBottom = 0;
                    renderer.uvRotateSouth = 3;
                    renderer.uvRotateEast = 3;
                    Tessellator.instance.setBrightness(0xF000F0);
                    Tessellator.instance.setColorOpaque_I(this.getCableColor().blackVariant);
                    rh.setTexture(firstTaughtIcon, firstTaughtIcon, firstOffsetIcon, firstOffsetIcon, firstOffsetIcon, firstOffsetIcon);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    Tessellator.instance.setColorOpaque_I(this.getCableColor().whiteVariant);
                    rh.setTexture(secondTaughtIcon, secondTaughtIcon, secondOffsetIcon, secondOffsetIcon, secondOffsetIcon, secondOffsetIcon);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    break;
                }
                case EAST: 
                case WEST: {
                    rh.setTexture(off, off, off, off, def, def);
                    renderer.uvRotateEast = 2;
                    renderer.uvRotateWest = 1;
                    renderer.uvRotateBottom = 2;
                    renderer.uvRotateTop = 1;
                    renderer.uvRotateSouth = 0;
                    renderer.uvRotateNorth = 0;
                    AEBaseBlock blk = (AEBaseBlock)rh.getBlock();
                    FlippableIcon ico = blk.getRendererInstance().getTexture(ForgeDirection.EAST);
                    ico.setFlip(false, true);
                    renderer.setRenderBounds(0.0, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
                    rh.renderBlockCurrentBounds(x, y, z, renderer);
                    Tessellator.instance.setBrightness(0xF000F0);
                    FlippableIcon fpA = new FlippableIcon(firstTaughtIcon);
                    FlippableIcon fpB = new FlippableIcon(secondTaughtIcon);
                    fpA = new FlippableIcon(firstTaughtIcon);
                    fpB = new FlippableIcon(secondTaughtIcon);
                    fpA.setFlip(true, false);
                    fpB.setFlip(true, false);
                    Tessellator.instance.setColorOpaque_I(this.getCableColor().blackVariant);
                    rh.setTexture(firstOffsetIcon, firstOffsetIcon, firstOffsetIcon, firstOffsetIcon, firstTaughtIcon, fpA);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    Tessellator.instance.setColorOpaque_I(this.getCableColor().whiteVariant);
                    rh.setTexture(secondOffsetIcon, secondOffsetIcon, secondOffsetIcon, secondOffsetIcon, secondTaughtIcon, fpB);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    rh.setTexture(off, off, def, def, off, off);
                    renderer.uvRotateTop = 3;
                    renderer.uvRotateBottom = 3;
                    renderer.uvRotateNorth = 1;
                    renderer.uvRotateSouth = 2;
                    renderer.uvRotateWest = 1;
                    renderer.setRenderBounds(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 1.0);
                    rh.renderBlockCurrentBounds(x, y, z, renderer);
                    Tessellator.instance.setBrightness(0xF000F0);
                    Tessellator.instance.setColorOpaque_I(this.getCableColor().blackVariant);
                    rh.setTexture(firstOffsetIcon, firstOffsetIcon, firstTaughtIcon, firstTaughtIcon, firstOffsetIcon, firstOffsetIcon);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    Tessellator.instance.setColorOpaque_I(this.getCableColor().whiteVariant);
                    rh.setTexture(secondOffsetIcon, secondOffsetIcon, secondTaughtIcon, secondTaughtIcon, secondOffsetIcon, secondOffsetIcon);
                    this.renderAllFaces((AEBaseBlock)rh.getBlock(), x, y, z, rh, renderer);
                    break;
                }
            }
        }
        renderer.uvRotateWest = 0;
        renderer.uvRotateTop = 0;
        renderer.uvRotateSouth = 0;
        renderer.uvRotateNorth = 0;
        renderer.uvRotateEast = 0;
        renderer.uvRotateBottom = 0;
        rh.setTexture(null);
    }
}

